/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.annotations.plugins;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.scanning.annotations.plugins.SignatureSerializer;
import org.jboss.util.JBossObject;

public class ClassSignaturePair
extends JBossObject
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String className;
    private Signature signature;
    private Annotation annotation;

    public ClassSignaturePair() {
    }

    public ClassSignaturePair(String className, Signature signature) {
        this(className, signature, null);
    }

    public ClassSignaturePair(String className, Signature signature, Annotation annotation) {
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        this.className = className;
        this.signature = signature;
        this.annotation = annotation;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.className);
        boolean bs = this.signature != null;
        out.writeBoolean(bs);
        if (bs) {
            out.writeObject(new SignatureSerializer(this.signature));
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = in.readUTF();
        if (in.readBoolean()) {
            SignatureSerializer ss = (SignatureSerializer)in.readObject();
            this.signature = ss.getSignature();
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    protected int getHashCode() {
        int hash = this.className.hashCode();
        if (this.signature != null) {
            hash += 7 * this.signature.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassSignaturePair)) {
            return false;
        }
        ClassSignaturePair csPair = (ClassSignaturePair)obj;
        if (this.className.equals(csPair.getClassName())) {
            return ClassSignaturePair.equals((Object)this.signature, (Object)csPair.getSignature());
        }
        return false;
    }
}

