/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jacorb.config.Configuration;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.IFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.FilterStageSource;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventAdapter;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.lifecycle.IServantLifecyle;
import org.jacorb.notification.lifecycle.ServantLifecyleControl;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractSupplierAdmin;
import org.jacorb.notification.servant.FilterStageListManager;
import org.jacorb.notification.util.AdminPropertySet;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimit;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.AdminNotFound;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.PortableServer.POA;
import org.picocontainer.MutablePicoContainer;
import org.slf4j.Logger;

public abstract class AbstractEventChannel
implements IServantLifecyle,
JMXManageable {
    private static final Integer DEFAULT_ADMIN_KEY = new Integer(0);
    private final DisposableManager disposables_ = new DisposableManager();
    protected final Logger logger_;
    protected final ORB orb_;
    private final POA poa_;
    private final Configuration configuration_;
    private final AtomicInteger maxNumberOfSuppliers_ = new AtomicInteger(0);
    private final AtomicInteger maxNumberOfConsumers_ = new AtomicInteger(0);
    private final AdminPropertySet adminSettings_;
    private final QoSPropertySet qosSettings_;
    private final FilterStageListManager listManager_;
    private final FilterFactory defaultFilterFactory_;
    private final java.lang.Object modifyConsumerAdminsLock_ = new java.lang.Object();
    private final java.lang.Object modifySupplierAdminsLock_ = new java.lang.Object();
    private final Map consumerAdminServants_ = new HashMap();
    private final Map supplierAdminServants_ = new HashMap();
    private final AtomicInteger adminIdPool_ = new AtomicInteger(1);
    private final AtomicInteger numberOfConsumers_ = new AtomicInteger(0);
    private final AtomicInteger numberOfSuppliers_ = new AtomicInteger(0);
    private final ProxyEventListener proxyConsumerEventListener_ = new ProxyEventAdapter(){

        public void actionProxyCreationRequest(ProxyEvent proxyEvent) throws AdminLimitExceeded {
            AbstractEventChannel.this.addConsumer();
        }

        public void actionProxyDisposed(ProxyEvent proxyEvent) {
            AbstractEventChannel.this.removeConsumer();
        }
    };
    private final ProxyEventListener proxySupplierEventListener_ = new ProxyEventAdapter(){

        public void actionProxyCreationRequest(ProxyEvent proxyEvent) throws AdminLimitExceeded {
            AbstractEventChannel.this.addSupplier();
        }

        public void actionProxyDisposed(ProxyEvent proxyEvent) {
            AbstractEventChannel.this.removeSupplier();
        }
    };
    protected final MutablePicoContainer container_;
    private final int id_;
    private final AtomicBoolean destroyed_ = new AtomicBoolean(false);
    protected JMXManageable.JMXCallback jmxCallback_;
    private final ServantLifecyleControl servantLifecyle_;

    public AbstractEventChannel(IFactory iFactory, ORB oRB, POA pOA, Configuration configuration, FilterFactory filterFactory) {
        this.id_ = iFactory.getChannelID();
        this.orb_ = oRB;
        this.poa_ = pOA;
        this.configuration_ = configuration;
        this.defaultFilterFactory_ = filterFactory;
        this.container_ = iFactory.getContainer();
        this.logger_ = configuration.getLogger(this.getClass().getName());
        this.container_.registerComponentImplementation(SubscriptionManager.class);
        this.container_.registerComponentImplementation(OfferManager.class);
        this.adminSettings_ = new AdminPropertySet(this.configuration_);
        this.qosSettings_ = new QoSPropertySet(this.configuration_, 0);
        this.listManager_ = new FilterStageListManager(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fetchListData(FilterStageListManager.FilterStageList filterStageList) {
                java.lang.Object object = AbstractEventChannel.this.modifyConsumerAdminsLock_;
                synchronized (object) {
                    for (Integer n : AbstractEventChannel.this.consumerAdminServants_.keySet()) {
                        filterStageList.add((FilterStage)AbstractEventChannel.this.consumerAdminServants_.get(n));
                    }
                }
            }
        };
        this.servantLifecyle_ = new ServantLifecyleControl((IServantLifecyle)this, configuration);
    }

    public final void deactivate() {
        this.servantLifecyle_.deactivate();
    }

    public final Object activate() {
        return this.servantLifecyle_.activate();
    }

    private void addConsumer() throws AdminLimitExceeded {
        int n = this.maxNumberOfConsumers_.get();
        int n2 = this.numberOfConsumers_.incrementAndGet();
        if (n != 0 && n2 > n) {
            this.numberOfConsumers_.decrementAndGet();
            Any any = this.orb_.create_any();
            any.insert_long(n);
            AdminLimit adminLimit = new AdminLimit("consumer limit", any);
            throw new AdminLimitExceeded("Consumer creation request exceeds AdminLimit.", adminLimit);
        }
    }

    private void removeConsumer() {
        this.numberOfConsumers_.decrementAndGet();
    }

    private void addSupplier() throws AdminLimitExceeded {
        int n = this.numberOfSuppliers_.incrementAndGet();
        int n2 = this.maxNumberOfSuppliers_.get();
        if (n2 != 0 && n > n2) {
            this.numberOfSuppliers_.decrementAndGet();
            Any any = this.orb_.create_any();
            any.insert_long(n2);
            AdminLimit adminLimit = new AdminLimit("supplier limit", any);
            throw new AdminLimitExceeded("supplier creation request exceeds AdminLimit.", adminLimit);
        }
    }

    private void removeSupplier() {
        this.numberOfSuppliers_.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isDefaultConsumerAdminActive() {
        java.lang.Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            return this.consumerAdminServants_.containsKey(DEFAULT_ADMIN_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isDefaultSupplierAdminActive() {
        java.lang.Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            return this.supplierAdminServants_.containsKey(DEFAULT_ADMIN_KEY);
        }
    }

    public final FilterFactory default_filter_factory() {
        return this.defaultFilterFactory_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] get_all_consumeradmins() {
        java.lang.Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            int[] nArray = new int[this.consumerAdminServants_.size()];
            Iterator iterator = this.consumerAdminServants_.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                nArray[n] = (Integer)iterator.next();
                ++n;
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] get_all_supplieradmins() {
        java.lang.Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            int[] nArray = new int[this.supplierAdminServants_.size()];
            Iterator iterator = this.supplierAdminServants_.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                nArray[n] = (Integer)iterator.next();
                ++n;
            }
            return nArray;
        }
    }

    public final Property[] get_admin() {
        return this.adminSettings_.toArray();
    }

    public final Property[] get_qos() {
        return this.qosSettings_.toArray();
    }

    public final void set_qos(Property[] propertyArray) throws UnsupportedQoS {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("AbstractEventChannel.set_qos: " + this.qosSettings_);
        }
        this.qosSettings_.validate_qos(propertyArray, new NamedPropertyRangeSeqHolder());
        this.qosSettings_.set_qos(propertyArray);
    }

    public final void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, namedPropertyRangeSeqHolder);
    }

    public final void set_admin(Property[] propertyArray) throws UnsupportedAdmin {
        this.adminSettings_.validate_admin(propertyArray);
        this.adminSettings_.set_admin(propertyArray);
        this.configureAdminLimits(this.adminSettings_);
    }

    private void configureAdminLimits(PropertySet propertySet) {
        Any any = propertySet.get("MaxConsumers");
        this.setMaxNumberOfConsumers(any.extract_long());
        Any any2 = propertySet.get("MaxSuppliers");
        this.setMaxNumberOfSuppliers(any2.extract_long());
    }

    public final void destroy() {
        if (this.destroyed_.compareAndSet(false, true)) {
            this.container_.dispose();
            List list = this.container_.getComponentInstancesOfType(IContainer.class);
            for (IContainer iContainer : list) {
                iContainer.destroy();
            }
        } else {
            throw new OBJECT_NOT_EXIST();
        }
    }

    public final void dispose() {
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("destroy channel " + this.id_);
        }
        this.deactivate();
        this.disposables_.dispose();
    }

    public final POA getPOA() {
        return this.poa_;
    }

    public boolean isPersistent() {
        return false;
    }

    public final int getNumberOfConnectedClients() {
        return this.numberOfConsumers_.get() + this.numberOfSuppliers_.get();
    }

    public final int getMaxNumberOfSuppliers() {
        return this.maxNumberOfSuppliers_.get();
    }

    public void setMaxNumberOfSuppliers(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.maxNumberOfSuppliers_.set(n);
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set MaxNumberOfSuppliers=" + this.maxNumberOfSuppliers_);
        }
    }

    public final int getMaxNumberOfConsumers() {
        return this.maxNumberOfConsumers_.get();
    }

    public void setMaxNumberOfConsumers(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.maxNumberOfConsumers_.set(n);
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set MaxNumberOfConsumers=" + this.maxNumberOfConsumers_);
        }
    }

    private Property[] createQoSPropertiesForAdmin() {
        HashMap hashMap = new HashMap(this.qosSettings_.toMap());
        hashMap.remove("EventReliability");
        return PropertySet.map2Props(hashMap);
    }

    protected AbstractAdmin get_consumeradmin_internal(int n) throws AdminNotFound {
        java.lang.Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            Integer n2 = new Integer(n);
            if (this.consumerAdminServants_.containsKey(n2)) {
                return (AbstractAdmin)this.consumerAdminServants_.get(n2);
            }
            throw new AdminNotFound("ID " + n + " does not exist.");
        }
    }

    protected AbstractAdmin get_supplieradmin_internal(int n) throws AdminNotFound {
        java.lang.Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            Integer n2 = new Integer(n);
            if (this.supplierAdminServants_.containsKey(n2)) {
                return (AbstractAdmin)this.supplierAdminServants_.get(n2);
            }
            throw new AdminNotFound("ID " + n + " does not exist.");
        }
    }

    private List getAllConsumerAdmins() {
        return this.listManager_.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAdmin getDefaultConsumerAdminServant() {
        AbstractAdmin abstractAdmin;
        java.lang.Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            abstractAdmin = (AbstractAdmin)this.consumerAdminServants_.get(DEFAULT_ADMIN_KEY);
            if (abstractAdmin == null) {
                abstractAdmin = this.newConsumerAdminServant(DEFAULT_ADMIN_KEY);
                abstractAdmin.setInterFilterGroupOperator(InterFilterGroupOperator.AND_OP);
                try {
                    abstractAdmin.set_qos(this.createQoSPropertiesForAdmin());
                }
                catch (UnsupportedQoS unsupportedQoS) {
                    this.logger_.error("unable to set qos", (Throwable)unsupportedQoS);
                }
                this.addToConsumerAdmins(abstractAdmin);
            }
        }
        return abstractAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToConsumerAdmins(AbstractAdmin abstractAdmin) {
        final Integer n = abstractAdmin.getID();
        abstractAdmin.registerDisposable(new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                java.lang.Object object = AbstractEventChannel.this.modifyConsumerAdminsLock_;
                synchronized (object) {
                    AbstractEventChannel.this.consumerAdminServants_.remove(n);
                    AbstractEventChannel.this.listManager_.actionSourceModified();
                }
            }
        });
        java.lang.Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            this.consumerAdminServants_.put(n, abstractAdmin);
            this.listManager_.actionSourceModified();
        }
    }

    protected AbstractAdmin new_for_consumers_servant(InterFilterGroupOperator interFilterGroupOperator, IntHolder intHolder) {
        AbstractAdmin abstractAdmin = this.newConsumerAdminServant(this.createAdminID());
        intHolder.value = abstractAdmin.getID();
        abstractAdmin.setInterFilterGroupOperator(interFilterGroupOperator);
        try {
            abstractAdmin.set_qos(this.createQoSPropertiesForAdmin());
        }
        catch (UnsupportedQoS unsupportedQoS) {
            this.logger_.error("unable to set QoS", (Throwable)unsupportedQoS);
        }
        abstractAdmin.addProxyEventListener(this.proxySupplierEventListener_);
        this.addToConsumerAdmins(abstractAdmin);
        return abstractAdmin;
    }

    private int createAdminID() {
        return this.adminIdPool_.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSupplierAdmins(AbstractAdmin abstractAdmin) {
        final Integer n = abstractAdmin.getID();
        abstractAdmin.registerDisposable(new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                java.lang.Object object = AbstractEventChannel.this.modifySupplierAdminsLock_;
                synchronized (object) {
                    AbstractEventChannel.this.supplierAdminServants_.remove(n);
                }
            }
        });
        java.lang.Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            this.supplierAdminServants_.put(n, abstractAdmin);
        }
    }

    protected AbstractAdmin new_for_suppliers_servant(InterFilterGroupOperator interFilterGroupOperator, IntHolder intHolder) {
        AbstractAdmin abstractAdmin = this.newSupplierAdminServant(this.createAdminID());
        intHolder.value = abstractAdmin.getID();
        abstractAdmin.setInterFilterGroupOperator(interFilterGroupOperator);
        try {
            abstractAdmin.set_qos(this.createQoSPropertiesForAdmin());
        }
        catch (UnsupportedQoS unsupportedQoS) {
            this.logger_.error("unable to set QoS", (Throwable)unsupportedQoS);
        }
        abstractAdmin.addProxyEventListener(this.proxyConsumerEventListener_);
        this.addToSupplierAdmins(abstractAdmin);
        return abstractAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAdmin getDefaultSupplierAdminServant() {
        AbstractAdmin abstractAdmin;
        java.lang.Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            abstractAdmin = (AbstractAdmin)this.supplierAdminServants_.get(DEFAULT_ADMIN_KEY);
            if (abstractAdmin == null) {
                abstractAdmin = this.newSupplierAdminServant(DEFAULT_ADMIN_KEY);
                abstractAdmin.setInterFilterGroupOperator(InterFilterGroupOperator.AND_OP);
                try {
                    abstractAdmin.set_qos(this.createQoSPropertiesForAdmin());
                }
                catch (UnsupportedQoS unsupportedQoS) {
                    this.logger_.error("unable to set qos", (Throwable)unsupportedQoS);
                }
                this.addToSupplierAdmins(abstractAdmin);
            }
        }
        return abstractAdmin;
    }

    private AbstractAdmin newConsumerAdminServant(int n) {
        return this.newConsumerAdmin(n);
    }

    protected abstract AbstractAdmin newConsumerAdmin(int var1);

    private AbstractAdmin newSupplierAdminServant(int n) {
        AbstractSupplierAdmin abstractSupplierAdmin = this.newSupplierAdmin(n);
        abstractSupplierAdmin.setSubsequentFilterStageSource(new FilterStageSourceAdapter(this));
        return abstractSupplierAdmin;
    }

    protected abstract AbstractSupplierAdmin newSupplierAdmin(int var1);

    public int getID() {
        return this.id_;
    }

    public final void registerDisposable(Disposable disposable) {
        this.disposables_.addDisposable(disposable);
    }

    public final String getJMXObjectName() {
        return "channel=" + this.getMBeanName();
    }

    public final String getMBeanName() {
        return this.getMBeanType() + "-" + this.getID();
    }

    protected abstract String getMBeanType();

    public String[] getJMXNotificationTypes() {
        return new String[0];
    }

    public void setJMXCallback(JMXManageable.JMXCallback jMXCallback) {
        this.jmxCallback_ = jMXCallback;
    }

    private static class FilterStageSourceAdapter
    implements FilterStageSource {
        final WeakReference channelRef_;

        FilterStageSourceAdapter(AbstractEventChannel abstractEventChannel) {
            this.channelRef_ = new WeakReference<AbstractEventChannel>(abstractEventChannel);
        }

        public List getSubsequentFilterStages() {
            return ((AbstractEventChannel)this.channelRef_.get()).getAllConsumerAdmins();
        }
    }
}

