/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.util.state.State;
import org.jboss.util.state.StateMachine;
import org.jboss.util.state.Transition;

public final class ServiceMBeanState {
    public static final State STATE_UNREGISTERED = new State("Unregistered");
    public static final State STATE_REGISTERED = new State("Registered");
    public static final State STATE_CREATED = new State("Created");
    public static final State STATE_STARTING = new State("Starting");
    public static final State STATE_STARTED = new State("Started");
    public static final State STATE_STOPPING = new State("Stopping");
    public static final State STATE_STOPPED = new State("Stopped");
    public static final State STATE_DESTROYED = new State("Destroyed");
    public static final State STATE_FAILED = new State("Failed");
    public static final Transition TRANS_REGISTER = new Transition("register", STATE_REGISTERED);
    public static final Transition TRANS_CREATE = new Transition("create", STATE_CREATED);
    public static final Transition TRANS_START_BEGIN = new Transition("startBegin", STATE_STARTING);
    public static final Transition TRANS_START_END = new Transition("startEnd", STATE_STARTED);
    public static final Transition TRANS_STOP_BEGIN = new Transition("stopBegin", STATE_STOPPING);
    public static final Transition TRANS_STOP_END = new Transition("stopEnd", STATE_STOPPED);
    public static final Transition TRANS_DESTROY = new Transition("destroy", STATE_DESTROYED);
    public static final Transition TRANS_UNREGISTER = new Transition("unregister", STATE_UNREGISTERED);
    public static final Transition TRANS_FAIL = new Transition("fail", STATE_FAILED);
    public static final Set STATES = new HashSet<State>(Arrays.asList(STATE_UNREGISTERED, STATE_REGISTERED, STATE_CREATED, STATE_STARTING, STATE_STARTED, STATE_STOPPING, STATE_STOPPED, STATE_DESTROYED, STATE_FAILED));

    public static StateMachine createStateMachine(String description) {
        return new StateMachine(STATES, STATE_UNREGISTERED, description);
    }

    private ServiceMBeanState() {
    }

    static {
        STATE_UNREGISTERED.addTransition(TRANS_REGISTER).addTransition(TRANS_FAIL);
        STATE_REGISTERED.addTransition(TRANS_CREATE).addTransition(TRANS_UNREGISTER).addTransition(TRANS_FAIL);
        STATE_CREATED.addTransition(TRANS_START_BEGIN).addTransition(TRANS_DESTROY).addTransition(TRANS_FAIL);
        STATE_STARTING.addTransition(TRANS_START_END).addTransition(TRANS_FAIL);
        STATE_STARTED.addTransition(TRANS_STOP_BEGIN).addTransition(TRANS_FAIL);
        STATE_STOPPING.addTransition(TRANS_STOP_END).addTransition(TRANS_FAIL);
        STATE_STOPPED.addTransition(TRANS_START_BEGIN).addTransition(TRANS_DESTROY).addTransition(TRANS_FAIL);
        STATE_DESTROYED.addTransition(TRANS_CREATE).addTransition(TRANS_UNREGISTER).addTransition(TRANS_FAIL);
    }
}

