/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.util.JBossObject;
import org.jboss.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationProxy
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Configuration configuration = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

        @Override
        public Configuration run() {
            return new PropertyConfiguration();
        }
    });
    private Class<?> annotationType;
    private transient BeanInfo beanInfo;
    private Map<String, Object> map;

    public AnnotationProxy(Class<?> annotationType, Map<String, Object> valueMap) {
        if (annotationType == null) {
            throw new IllegalArgumentException("Null annotation type.");
        }
        this.annotationType = annotationType;
        this.map = valueMap != null ? valueMap : Collections.emptyMap();
    }

    protected BeanInfo getBeanInfo() {
        if (this.beanInfo == null) {
            this.beanInfo = configuration.getBeanInfo(this.annotationType);
        }
        return this.beanInfo;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if ("equals".equals(name)) {
            return this.doEquals(proxy, args[0]);
        }
        if ("hashCode".equals(name)) {
            return this.doHashCode();
        }
        if ("toString".equals(name)) {
            return "@" + this.annotationType.getName() + this.map.toString();
        }
        if ("annotationType".equals(name)) {
            return this.annotationType;
        }
        return this.map.get(name);
    }

    public Object getValue(String name) {
        return this.map.get(name);
    }

    private Object doEquals(Object proxy, Object obj) {
        if (obj == proxy) {
            return Boolean.TRUE;
        }
        if (obj == null) {
            return Boolean.FALSE;
        }
        if (!this.annotationType.isInstance(obj)) {
            return Boolean.FALSE;
        }
        try {
            for (String key : this.map.keySet()) {
                Object value = this.getValue(key);
                Object other = this.getBeanInfo().getProperty(obj, key);
                if (Objects.isArray((Object)value)) {
                    if (!Objects.isArray((Object)other)) {
                        return Boolean.FALSE;
                    }
                    int length = Array.getLength(value);
                    if (length != Array.getLength(other)) {
                        return Boolean.FALSE;
                    }
                    for (int i = 0; i < length; ++i) {
                        if (JBossObject.equals((Object)Array.get(value, i), (Object)Array.get(other, i))) continue;
                        return Boolean.FALSE;
                    }
                    continue;
                }
                if (JBossObject.equals((Object)value, (Object)other)) continue;
                return Boolean.FALSE;
            }
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
        return Boolean.TRUE;
    }

    private Object doHashCode() {
        return ((Object)this.map).hashCode();
    }

    public static Object createProxy(Map<String, Object> map, Class<?> annotation) throws Exception {
        AnnotationProxy proxyHandler = new AnnotationProxy(annotation, map);
        return Proxy.newProxyInstance(annotation.getClassLoader(), new Class[]{annotation}, (InvocationHandler)proxyHandler);
    }
}

