/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.deployers.switchboard;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.jpa.deployers.switchboard.PersistenceUnitRefResource;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.logging.Logger;
import org.jboss.switchboard.javaee.environment.PersistenceUnitRefType;
import org.jboss.switchboard.mc.spi.MCBasedResourceProvider;
import org.jboss.switchboard.spi.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitResourceProvider
implements MCBasedResourceProvider<PersistenceUnitRefType> {
    private static final Logger log = Logger.getLogger(PersistenceUnitResourceProvider.class);
    private PersistenceUnitDependencyResolver persistenceUnitDependencyResolver;

    public PersistenceUnitResourceProvider(PersistenceUnitDependencyResolver resolver) {
        this.persistenceUnitDependencyResolver = resolver;
    }

    public Resource provide(DeploymentUnit unit, PersistenceUnitRefType puRef) {
        DeploymentUnit dependentDU = unit;
        if (unit.isComponent()) {
            dependentDU = unit.getParent();
        }
        log.debug((Object)("Resolving PU supplier for: " + puRef.getPersistenceUnitName() + " in unit " + dependentDU));
        String puSupplier = this.persistenceUnitDependencyResolver.resolvePersistenceUnitSupplier(dependentDU, puRef.getPersistenceUnitName());
        log.debug((Object)("Resolved PU supplier: " + puSupplier + " for persistence-unit-ref: " + puRef.getName() + " in unit " + dependentDU));
        return new PersistenceUnitRefResource(puSupplier);
    }

    public Class<PersistenceUnitRefType> getEnvironmentEntryType() {
        return PersistenceUnitRefType.class;
    }
}

