/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.io.Serializable;
import javax.jms.Queue;
import javax.jms.Topic;
import org.hornetq.core.logging.Logger;
import org.hornetq.ra.ConnectionFactoryProperties;
import org.hornetq.ra.Util;

public class HornetQRAMCFProperties
extends ConnectionFactoryProperties
implements Serializable {
    static final long serialVersionUID = -5951352236582886862L;
    private static final Logger log = Logger.getLogger(HornetQRAMCFProperties.class);
    private static boolean trace = log.isTraceEnabled();
    private static final String QUEUE_TYPE = Queue.class.getName();
    private static final String TOPIC_TYPE = Topic.class.getName();
    public String strConnectionParameters;
    public String strBackupConnectionParameters;
    private int type = 0;
    private Integer useTryLock;

    public HornetQRAMCFProperties() {
        if (trace) {
            log.trace((Object)"constructor()");
        }
        this.useTryLock = null;
    }

    public int getType() {
        if (trace) {
            log.trace((Object)"getType()");
        }
        return this.type;
    }

    public String getStrConnectionParameters() {
        return this.strConnectionParameters;
    }

    public void setConnectionParameters(String configuration) {
        this.strConnectionParameters = configuration;
        this.setParsedConnectionParameters(Util.parseConfig(configuration));
    }

    public String getBackupConnectionParameters() {
        return this.strBackupConnectionParameters;
    }

    public void setBackupConnectionParameters(String configuration) {
        this.strBackupConnectionParameters = configuration;
        this.setParsedBackupConnectionParameters(Util.parseConfig(configuration));
    }

    public void setSessionDefaultType(String defaultType) {
        if (trace) {
            log.trace((Object)("setSessionDefaultType(" + this.type + ")"));
        }
        this.type = defaultType.equals(QUEUE_TYPE) ? 1 : (defaultType.equals(TOPIC_TYPE) ? 2 : 0);
    }

    public String getSessionDefaultType() {
        if (trace) {
            log.trace((Object)"getSessionDefaultType()");
        }
        if (this.type == 0) {
            return "BOTH";
        }
        if (this.type == 1) {
            return TOPIC_TYPE;
        }
        return QUEUE_TYPE;
    }

    public Integer getUseTryLock() {
        if (trace) {
            log.trace((Object)"getUseTryLock()");
        }
        return this.useTryLock;
    }

    public void setUseTryLock(Integer useTryLock) {
        if (trace) {
            log.trace((Object)("setUseTryLock(" + useTryLock + ")"));
        }
        this.useTryLock = useTryLock;
    }
}

