/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.helpers;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.vfs.VirtualFile;

public class SecurityActions {
    private SecurityActions() {
    }

    static boolean isLeaf(VirtualFile f) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return FileActions.PRIVILEGED.isLeaf(f);
        }
        return FileActions.NON_PRIVILEGED.isLeaf(f);
    }

    static interface FileActions {
        public static final FileActions PRIVILEGED = new FileActions(){

            public boolean isLeaf(final VirtualFile f) {
                return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return f.isFile();
                    }
                });
            }
        };
        public static final FileActions NON_PRIVILEGED = new FileActions(){

            public boolean isLeaf(VirtualFile f) {
                return f.isFile();
            }
        };

        public boolean isLeaf(VirtualFile var1);
    }
}

