/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.util.Set;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.ForwardingResolvable;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeDisposerResolver
extends TypeSafeResolver<Resolvable, DisposalMethod<?, ?>> {
    private final BeanManagerImpl manager;

    public TypeSafeDisposerResolver(BeanManagerImpl manager, Iterable<DisposalMethod<?, ?>> disposers) {
        super(disposers);
        this.manager = manager;
    }

    @Override
    protected boolean matches(Resolvable resolvable, DisposalMethod<?, ?> disposer) {
        return resolvable.getDeclaringBean().equals(disposer.getDeclaringBean()) && Reflections.isAssignableFrom(disposer.getType(), resolvable.getTypes()) && Beans.containsAllQualifiers(disposer.getQualifiers(), resolvable.getQualifiers(), this.manager);
    }

    @Override
    protected Resolvable wrap(final Resolvable resolvable) {
        return new ForwardingResolvable(){

            protected Resolvable delegate() {
                return resolvable;
            }

            public boolean equals(Object o) {
                if (o instanceof Resolvable && super.equals(o)) {
                    Resolvable r = (Resolvable)o;
                    return r.getDeclaringBean().equals(this.getDeclaringBean());
                }
                return false;
            }

            public int hashCode() {
                return 31 * super.hashCode() + this.getDeclaringBean().hashCode();
            }
        };
    }

    public BeanManagerImpl getManager() {
        return this.manager;
    }

    @Override
    protected Set<DisposalMethod<?, ?>> filterResult(Set<DisposalMethod<?, ?>> matched) {
        return matched;
    }

    @Override
    protected Set<DisposalMethod<?, ?>> sortResult(Set<DisposalMethod<?, ?>> matched) {
        return matched;
    }
}

