/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.integration.deployer.env.bda.ArchiveInfo;
import org.jboss.weld.integration.deployer.env.bda.ArchiveLifecycleListener;
import org.jboss.weld.integration.deployer.env.bda.BeanDeploymentArchiveImpl;
import org.jboss.weld.integration.deployer.env.bda.ClassLoaderResourceLoader;
import org.jboss.weld.integration.deployer.env.bda.Classpath;
import org.jboss.weld.integration.util.IdFactory;
import org.jboss.weld.resources.spi.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Archive {
    private static final Map<ClassLoader, WeakReference<Archive>> instances = new WeakHashMap<ClassLoader, WeakReference<Archive>>();
    private final Collection<String> classes;
    private final Collection<URL> xmlURLs;
    private final ClassLoader classLoader;
    private final Classpath classpath;
    private BeanDeploymentArchiveImpl bda;
    private final Collection<EjbDescriptor<?>> ejbs;
    private final Collection<ArchiveLifecycleListener> lifecycleListeners = new ArrayList<ArchiveLifecycleListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Archive getInstance(ClassLoader classLoader) {
        Map<ClassLoader, WeakReference<Archive>> map = instances;
        synchronized (map) {
            WeakReference<Archive> reference = instances.get(classLoader);
            if (reference == null) {
                return null;
            }
            return (Archive)reference.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archive(ArchiveInfo archiveInfo, Collection<EjbDescriptor<?>> ejbs) {
        this.classes = archiveInfo.getEnvironment().getWeldClasses();
        this.xmlURLs = archiveInfo.getEnvironment().getWeldXml();
        this.classLoader = archiveInfo.getClassLoader();
        this.classpath = archiveInfo.getClasspath();
        this.classpath.addArchive(this);
        this.ejbs = Archive.filterDescriptors(archiveInfo, ejbs);
        Map<ClassLoader, WeakReference<Archive>> map = instances;
        synchronized (map) {
            instances.put(this.classLoader, new WeakReference<Archive>(this));
        }
    }

    private static Collection<EjbDescriptor<?>> filterDescriptors(ArchiveInfo archiveInfo, Collection<EjbDescriptor<?>> ejbs) {
        ArrayList descriptors = new ArrayList();
        for (EjbDescriptor<?> ejbDescriptor : ejbs) {
            Collection<String> ejbNames = archiveInfo.getEjbNames();
            if (!ejbNames.contains(ejbDescriptor.getEjbName())) continue;
            descriptors.add(ejbDescriptor);
        }
        return descriptors;
    }

    public Collection<String> getClasses() {
        return this.classes;
    }

    public boolean containsClass(Class<?> beanClass) {
        return beanClass.getClassLoader() == this.classLoader;
    }

    public boolean isClassVisible(Class<?> beanClass) {
        Class<?> loadedClass;
        try {
            loadedClass = this.getClassLoader().loadClass(beanClass.getName());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return loadedClass == beanClass;
    }

    public void addClass(Class<?> beanClass) {
        this.classes.add(beanClass.getName());
    }

    public Collection<URL> getXmlURLs() {
        return this.xmlURLs;
    }

    public boolean hasXml() {
        return this.xmlURLs != null && !this.xmlURLs.isEmpty();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Classpath getClasspath() {
        return this.classpath;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive() {
        return this.bda;
    }

    public BeanDeploymentArchive createBeanDeploymentArchive(Bootstrap bootstrap, ServiceRegistry services) {
        if (this.bda == null) {
            services.add(ResourceLoader.class, (Service)new ClassLoaderResourceLoader(this.classLoader));
            this.bda = new BeanDeploymentArchiveImpl(IdFactory.getIdFromClassLoader(this.classLoader), bootstrap, services, this);
            for (ArchiveLifecycleListener listener : this.lifecycleListeners) {
                listener.archiveVisible(this, this.bda);
            }
        }
        return this.bda;
    }

    public BeanDeploymentArchive createBeanDeploymentArchive(ServiceRegistry services) {
        return this.createBeanDeploymentArchive(null, services);
    }

    public void addLifecycleListener(ArchiveLifecycleListener listener) {
        this.lifecycleListeners.add(listener);
        if (this.bda != null) {
            listener.archiveVisible(this, this.bda);
        }
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return this.ejbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        Map<ClassLoader, WeakReference<Archive>> map = instances;
        synchronized (map) {
            instances.remove(this.classLoader);
        }
        for (ArchiveLifecycleListener listener : this.lifecycleListeners) {
            listener.archiveDestroyed(this);
        }
    }

    public String toString() {
        return "Archive[" + this.classLoader + "]";
    }
}

