/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.loader.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.metadata.plugins.loader.BasicMetaDataLoader;
import org.jboss.metadata.plugins.loader.SimpleMetaDataLoader;
import org.jboss.metadata.plugins.loader.reflection.SecurityActions;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationItem;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationsItem;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.scope.UnmodifiableScopeKey;
import org.jboss.metadata.spi.signature.ConstructorParametersSignature;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodParametersSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedElementMetaDataLoader
extends BasicMetaDataLoader {
    private static final Logger log = Logger.getLogger(AnnotatedElementMetaDataLoader.class);
    private AnnotatedElement annotated;

    private static final ScopeKey getScopeKey(AnnotatedElement annotated) {
        Scope scope;
        if (annotated instanceof Class) {
            Class clazz = (Class)Class.class.cast(annotated);
            scope = new Scope(CommonLevels.CLASS, clazz);
        } else if (annotated instanceof Member) {
            Member member = (Member)((Object)annotated);
            scope = new Scope(CommonLevels.JOINPOINT, member);
        } else {
            return ScopeKey.DEFAULT_SCOPE;
        }
        return new UnmodifiableScopeKey(new Scope[]{scope});
    }

    public AnnotatedElementMetaDataLoader(AnnotatedElement annotated) {
        super(AnnotatedElementMetaDataLoader.getScopeKey(annotated));
        if (annotated == null) {
            throw new IllegalArgumentException("Null annotated element");
        }
        this.annotated = annotated;
    }

    @Override
    public AnnotationsItem retrieveAnnotations() {
        Annotation[] annotations = this.annotated.getAnnotations();
        if (annotations.length == 0) {
            return SimpleAnnotationsItem.NO_ANNOTATIONS;
        }
        AnnotationItem[] items = new AnnotationItem[annotations.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new SimpleAnnotationItem<Annotation>(annotations[i]);
        }
        return new SimpleAnnotationsItem(items);
    }

    @Override
    public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType) {
        T annotation = this.annotated.getAnnotation(annotationType);
        if (annotation == null) {
            return null;
        }
        return new SimpleAnnotationItem<T>(annotation);
    }

    @Override
    public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature) {
        if (signature == null) {
            return null;
        }
        if (this.annotated instanceof Class) {
            Class<?> clazz = (Class<?>)Class.class.cast(this.annotated);
            if (signature instanceof ConstructorSignature) {
                ConstructorSignature constructorSignature = (ConstructorSignature)signature;
                Constructor<?> constructor = constructorSignature.getConstructor();
                if (constructor == null) {
                    constructor = SecurityActions.findConstructor(clazz, signature.getParametersTypes(clazz));
                }
                if (constructor == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Constructor with signature " + signature + " does not exist on class " + clazz.getName()));
                    }
                    return null;
                }
                if (constructor.getAnnotations().length == 0) {
                    return null;
                }
                return new AnnotatedElementMetaDataLoader(constructor);
            }
            if (signature instanceof MethodSignature) {
                MethodSignature methodSignature = (MethodSignature)signature;
                Method method = methodSignature.getMethod();
                if (method == null) {
                    method = SecurityActions.findMethod(clazz, signature.getName(), signature.getParametersTypes(clazz));
                }
                if (method == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Method with signature " + signature + " does not exist on class " + clazz.getName()));
                    }
                    return null;
                }
                if (method.getAnnotations().length == 0) {
                    if (method.isBridge()) {
                        if ((method = this.searchForRealBridgeMethodSignature(method)) == null) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                return new AnnotatedElementMetaDataLoader(method);
            }
            if (signature instanceof DeclaredMethodSignature) {
                DeclaredMethodSignature methodSignature = (DeclaredMethodSignature)signature;
                Method method = methodSignature.getMethod();
                if (method == null) {
                    if ((clazz = AnnotatedElementMetaDataLoader.getDeclaringClass(clazz, methodSignature.getDeclaringClass())) == null) {
                        return null;
                    }
                    try {
                        method = SecurityActions.findDeclaredMethod(clazz, signature.getName(), signature.getParametersTypes(clazz));
                    }
                    catch (NoSuchMethodException nsme) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Method with signature " + signature + " does not exist on class " + clazz.getName()));
                        }
                        return null;
                    }
                }
                if (method.getAnnotations().length == 0) {
                    if (method.isBridge()) {
                        if ((method = this.searchForRealBridgeMethodSignature(method)) == null) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                return new AnnotatedElementMetaDataLoader(method);
            }
            if (signature instanceof MethodParametersSignature) {
                MethodParametersSignature methodParametersSignature = (MethodParametersSignature)signature;
                Method method = methodParametersSignature.getMethod();
                if (method == null) {
                    method = SecurityActions.findMethod(clazz, signature.getName(), signature.getParametersTypes(clazz));
                }
                if (method == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Method with signature " + signature + " does not exist on class " + clazz.getName()));
                    }
                    return null;
                }
                Annotation[][] paramAnnotations = method.getParameterAnnotations();
                if (paramAnnotations[methodParametersSignature.getParam()].length == 0) {
                    return null;
                }
                return new SimpleMetaDataLoader(paramAnnotations[methodParametersSignature.getParam()]);
            }
            if (signature instanceof ConstructorParametersSignature) {
                ConstructorParametersSignature constructorParametersSignature = (ConstructorParametersSignature)signature;
                Constructor<?> constructor = constructorParametersSignature.getConstructor();
                if (constructor == null) {
                    constructor = SecurityActions.findConstructor(clazz, signature.getParametersTypes(clazz));
                }
                if (constructor == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Constructor with signature " + signature + " does not exist on class " + clazz.getName()));
                    }
                    return null;
                }
                Annotation[][] paramAnnotations = constructor.getParameterAnnotations();
                if (paramAnnotations[constructorParametersSignature.getParam()].length == 0) {
                    return null;
                }
                return new SimpleMetaDataLoader(paramAnnotations[constructorParametersSignature.getParam()]);
            }
            if (signature instanceof FieldSignature) {
                FieldSignature fieldSignature = (FieldSignature)signature;
                Field field = fieldSignature.getField();
                if (field == null) {
                    field = SecurityActions.findField(clazz, signature.getName());
                }
                if (field == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Field " + signature.getName() + " does not exist on class " + clazz.getName()));
                    }
                    return null;
                }
                if (field.getAnnotations().length == 0) {
                    return null;
                }
                return new AnnotatedElementMetaDataLoader(field);
            }
        }
        if (this.annotated instanceof Method && signature instanceof MethodParametersSignature) {
            MethodParametersSignature sig;
            Method method = (Method)this.annotated;
            Annotation[][] paramAnnotations = method.getParameterAnnotations();
            if (paramAnnotations[(sig = (MethodParametersSignature)signature).getParam()].length == 0) {
                return null;
            }
            return new SimpleMetaDataLoader(paramAnnotations[sig.getParam()]);
        }
        if (this.annotated instanceof Constructor && signature instanceof ConstructorParametersSignature) {
            ConstructorParametersSignature sig;
            Constructor constructor = (Constructor)Constructor.class.cast(this.annotated);
            Annotation[][] paramAnnotations = constructor.getParameterAnnotations();
            if (paramAnnotations[(sig = (ConstructorParametersSignature)signature).getParam()].length == 0) {
                return null;
            }
            return new SimpleMetaDataLoader(paramAnnotations[sig.getParam()]);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        Annotation[] annotations = this.annotated.getAnnotations();
        return annotations == null || annotations.length == 0;
    }

    public String toString() {
        JBossStringBuilder buffer = new JBossStringBuilder();
        Strings.defaultToString((JBossStringBuilder)buffer, (Object)this);
        buffer.append("[");
        buffer.append((Object)this.annotated);
        buffer.append("]");
        return buffer.toString();
    }

    private static Class<?> getDeclaringClass(Class<?> reference, String declaringClass) {
        while (reference != null) {
            if (declaringClass.equals(reference.getName())) {
                return reference;
            }
            reference = reference.getSuperclass();
        }
        return null;
    }

    private Method searchForRealBridgeMethodSignature(Method bridge) {
        Method[] all;
        Class<?> declaringClass = bridge.getDeclaringClass();
        Class<?>[] parameters = bridge.getParameterTypes();
        ArrayList<Method> matching = new ArrayList<Method>();
        for (Method m : all = declaringClass.getDeclaredMethods()) {
            if (!m.getName().equals(bridge.getName()) || m.getParameterTypes().length != parameters.length || m.equals(bridge) || m.isBridge()) continue;
            matching.add(m);
        }
        if (matching.size() == 1) {
            return (Method)matching.get(0);
        }
        if (matching.size() == 0) {
            throw new IllegalStateException("No original methods found: " + bridge);
        }
        Iterator it = matching.iterator();
        block1: while (it.hasNext()) {
            Method cur = (Method)it.next();
            if (!bridge.getReturnType().isAssignableFrom(cur.getReturnType())) {
                it.remove();
                continue;
            }
            Class<?>[] currentParameters = cur.getParameterTypes();
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isAssignableFrom(currentParameters[i])) continue;
                it.remove();
                continue block1;
            }
        }
        if (matching.size() == 1) {
            return (Method)matching.get(0);
        }
        if (matching.size() == 0) {
            throw new IllegalStateException("No original methods found: " + bridge);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Could not determine original method for " + bridge + " found: " + matching));
        }
        return null;
    }
}

