/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.wsdl.xml.WSDLLocator;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.utils.ResourceURL;
import org.jboss.ws.tools.wsdl.WSDLDefinitionsFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

class WSDLLocatorImpl
implements WSDLLocator {
    private static final Logger log = Logger.getLogger(WSDLDefinitionsFactory.class);
    private EntityResolver entityResolver;
    private URL wsdlLocation;
    private String latestImportURI;

    public WSDLLocatorImpl(EntityResolver entityResolver, URL wsdlLocation) {
        if (wsdlLocation == null) {
            throw new IllegalArgumentException("WSDL file argument cannot be null");
        }
        this.entityResolver = entityResolver;
        this.wsdlLocation = wsdlLocation;
    }

    public InputSource getBaseInputSource() {
        log.trace((Object)("getBaseInputSource [wsdlUrl=" + this.wsdlLocation + "]"));
        try {
            InputStream inputStream = new ResourceURL(this.wsdlLocation).openStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Cannot obtain wsdl from [" + this.wsdlLocation + "]");
            }
            return new InputSource(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot access wsdl from [" + this.wsdlLocation + "], " + e.getMessage());
        }
    }

    public String getBaseURI() {
        return this.wsdlLocation.toExternalForm();
    }

    public InputSource getImportInputSource(String parent, String resource) {
        log.trace((Object)("getImportInputSource [parent=" + parent + ",resource=" + resource + "]"));
        URL parentURL = null;
        try {
            parentURL = new URL(parent);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Not a valid URL: " + parent));
            return null;
        }
        String wsdlImport = null;
        String external = parentURL.toExternalForm();
        if (resource.startsWith("http://") || resource.startsWith("https://")) {
            if (resource.indexOf(parentURL.getFile()) != -1) {
                URI uri = null;
                try {
                    uri = new URI(resource);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot resolve imported resource: " + resource);
                }
                String path = uri.getPath();
                String query = uri.getQuery() != null ? "?" + uri.getQuery() : "";
                wsdlImport = parentURL.getProtocol() + "://" + parentURL.getHost() + ":" + parentURL.getPort() + path + query;
            } else {
                wsdlImport = resource;
            }
        } else if (resource.startsWith("/")) {
            String beforePath = external.substring(0, external.indexOf(parentURL.getPath()));
            wsdlImport = beforePath + resource;
        } else {
            String parentDir = external.substring(0, external.lastIndexOf("/"));
            while (resource.startsWith("./")) {
                resource = resource.substring(2);
            }
            while (resource.startsWith("../")) {
                parentDir = parentDir.substring(0, parentDir.lastIndexOf("/"));
                resource = resource.substring(3);
            }
            wsdlImport = parentDir + "/" + resource;
        }
        try {
            log.trace((Object)("Trying to resolve: " + wsdlImport));
            InputSource inputSource = this.entityResolver.resolveEntity(wsdlImport, wsdlImport);
            if (inputSource == null) {
                throw new IllegalArgumentException("Cannot resolve imported resource: " + wsdlImport);
            }
            this.latestImportURI = wsdlImport;
            return inputSource;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSException("Cannot access imported wsdl [" + wsdlImport + "], " + e.getMessage());
        }
    }

    public String getLatestImportURI() {
        return this.latestImportURI;
    }

    public void close() {
    }
}

