/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.policy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.ws.WSException;
import org.jboss.ws.extensions.policy.PolicyAssertion;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PolicyAlternative {
    private Collection<PolicyAssertion> assertions = new ArrayList<PolicyAssertion>();

    PolicyAlternative() {
    }

    static PolicyAlternative parse(Element elAll) {
        elAll = (Element)elAll.cloneNode(true);
        PolicyAlternative all = new PolicyAlternative();
        Iterator it = DOMUtils.getChildElements((Node)elAll);
        while (it.hasNext()) {
            Element el = (Element)it.next();
            all.addPolicyAssertion(new PolicyAssertion(el));
        }
        return all;
    }

    public void addPolicyAssertion(PolicyAssertion polAssertion) {
        this.assertions.add(polAssertion);
    }

    public Collection<PolicyAssertion> getPolicyAssertions() {
        return new ArrayList<PolicyAssertion>(this.assertions);
    }

    public Element toElement() {
        String xmlString = this.toXMLString(false);
        try {
            return DOMUtils.parse((String)xmlString);
        }
        catch (IOException ex) {
            throw new WSException("Cannot parse: " + xmlString, ex);
        }
    }

    public String toXMLString(boolean pretty) {
        if (pretty) {
            Element elAll = this.toElement();
            return DOMWriter.printNode((Node)elAll, (boolean)true);
        }
        StringBuilder xmlBuffer = new StringBuilder("<wsp:All>");
        for (PolicyAssertion assertion : this.assertions) {
            xmlBuffer.append(assertion.toXMLString(false));
        }
        xmlBuffer.append("</wsp:All>");
        return xmlBuffer.toString();
    }

    public String toString() {
        return this.toXMLString(true);
    }
}

