/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.security.PrivilegedActionException;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Wrapper;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityUtil;
import org.jboss.web.tomcat.security.SecurityAssociationActions;

public class RunAsListener
implements InstanceListener {
    public static ThreadLocal<JBossWebMetaData> metaDataLocal = new ThreadLocal();
    private static Logger log = Logger.getLogger(RunAsListener.class);
    private JBossWebMetaData metaData = metaDataLocal.get();

    public void instanceEvent(InstanceEvent event) {
        Wrapper servlet = event.getWrapper();
        String type = event.getType();
        if (servlet != null && this.metaData != null) {
            boolean trace = log.isTraceEnabled();
            String name = servlet.getName();
            RunAsIdentityMetaData identity = this.metaData.getRunAsIdentity(name);
            RunAsIdentity runAsIdentity = null;
            if (identity != null) {
                runAsIdentity = new RunAsIdentity(identity.getRoleName(), identity.getPrincipalName(), identity.getRunAsRoles());
            }
            if (trace) {
                log.trace((Object)(name + ", runAs: " + identity));
            }
            if (type.equals("beforeInit") || type.equals("beforeDestroy") || type.equals("beforeService")) {
                this.ensureSecurityContext();
                SecurityAssociationActions.pushRunAsIdentity(runAsIdentity);
            } else if (type.equals("afterInit") || type.equals("afterDestroy") || type.equals("afterService")) {
                this.ensureSecurityContext();
                SecurityAssociationActions.popRunAsIdentity();
            }
        }
    }

    private void ensureSecurityContext() {
        String securityDomain = this.metaData.getSecurityDomain();
        securityDomain = securityDomain == null ? "other" : SecurityUtil.unprefixSecurityDomain((String)securityDomain);
        if (SecurityAssociationActions.getSecurityContext() == null) {
            SecurityContext sc = null;
            try {
                sc = SecurityAssociationActions.createSecurityContext(securityDomain);
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
            SecurityAssociationActions.setSecurityContext(sc);
        }
    }
}

