/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.mbeanserver;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.jboss.jmx.mbeanserver.RegistryEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossMBeanRegistry {
    static ThreadLocal<RegistryEntry> current = new ThreadLocal();
    private Map<String, Map<String, RegistryEntry>> domainMap = new ConcurrentHashMap<String, Map<String, RegistryEntry>>();
    private String defaultDomain;
    private MBeanServer server;

    public JBossMBeanRegistry(MBeanServer server) {
        this.server = server;
        this.defaultDomain = server.getDefaultDomain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance registerMBean(Object object, ObjectName name, Map<String, Object> valueMap) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        RegistryEntry entry = new RegistryEntry(this.qualifyName(name), valueMap);
        RegistryEntry previous = current.get();
        current.set(entry);
        try {
            ObjectInstance objectInstance = this.server.registerMBean(object, entry.getObjectName());
            return objectInstance;
        }
        finally {
            current.set(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        RegistryEntry entry = new RegistryEntry(this.qualifyName(name), null);
        RegistryEntry previous = current.get();
        current.set(entry);
        try {
            this.server.unregisterMBean(name);
        }
        finally {
            current.set(previous);
        }
    }

    public RegistryEntry get(ObjectName name) throws InstanceNotFoundException {
        return this.get(name, true);
    }

    public RegistryEntry get(ObjectName name, boolean errorIfNotFound) throws InstanceNotFoundException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("null object name"));
        }
        String domain = name.getDomain();
        if (domain.length() == 0) {
            domain = this.defaultDomain;
        }
        String props = name.getCanonicalKeyPropertyListString();
        Map<String, RegistryEntry> mbeanMap = this.getMBeanMap(domain, false);
        RegistryEntry entry = null;
        if ((null == mbeanMap || null == (entry = mbeanMap.get(props))) && errorIfNotFound) {
            throw new InstanceNotFoundException(name + " is not registered.");
        }
        return entry;
    }

    public String getDefaultDomain() {
        return this.server.getDefaultDomain();
    }

    public String[] getDomains() {
        return this.server.getDomains();
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.server.getObjectInstance(name);
    }

    public Object getValue(ObjectName name, String key) throws InstanceNotFoundException {
        return this.get(name).getValue(key);
    }

    public boolean contains(ObjectName name) {
        return this.server.isRegistered(name);
    }

    public int getSize() {
        return this.server.getMBeanCount();
    }

    protected synchronized void add(RegistryEntry entry) throws InstanceAlreadyExistsException {
        ObjectName name = entry.getObjectName();
        String domain = name.getDomain();
        String props = name.getCanonicalKeyPropertyListString();
        Map<String, RegistryEntry> mbeanMap = this.getMBeanMap(domain, true);
        if (mbeanMap.get(props) != null) {
            throw new InstanceAlreadyExistsException(name + " already registered.");
        }
        mbeanMap.put(props, entry);
    }

    protected synchronized void remove(ObjectName name) throws InstanceNotFoundException {
        String domain = name.getDomain();
        String props = name.getCanonicalKeyPropertyListString();
        Map<String, RegistryEntry> mbeanMap = this.getMBeanMap(domain, false);
        if (null == mbeanMap || null == mbeanMap.remove(props)) {
            throw new InstanceNotFoundException(name + " not registered.");
        }
    }

    protected ObjectName qualifyName(ObjectName name) {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null object name"));
        }
        try {
            if (name.getDomain().length() == 0) {
                return new ObjectName(this.defaultDomain + ":" + name.getCanonicalKeyPropertyListString());
            }
            return name;
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeOperationsException(new IllegalArgumentException(e.toString()));
        }
    }

    private Map<String, RegistryEntry> getMBeanMap(String domain, boolean createIfMissing) {
        Map<String, RegistryEntry> mbeanMap = this.domainMap.get(domain);
        if (mbeanMap == null && createIfMissing) {
            mbeanMap = new ConcurrentHashMap<String, RegistryEntry>();
            this.domainMap.put(domain, mbeanMap);
        }
        return mbeanMap;
    }
}

