/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.configprovider.ConfigurationResourceProvider;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaInfResourceProvider
implements ConfigurationResourceProvider {
    private static final Pattern JAR_PATTERN = Pattern.compile(".*/(\\S*\\.jar).*");
    private static final String META_INF_RESOURCES = "META-INF/faces-config.xml";

    @Override
    public Collection<URL> getResources(ServletContext context) {
        WebConfiguration webConfig = WebConfiguration.getInstance(context);
        String duplicateJarPattern = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.DuplicateJARPattern);
        Pattern duplicatePattern = null;
        if (duplicateJarPattern != null) {
            duplicatePattern = Pattern.compile(duplicateJarPattern);
        }
        TreeMap<String, URL> sortedJarMap = new TreeMap<String, URL>();
        ArrayList<URL> unsortedResourceList = new ArrayList<URL>();
        try {
            Enumeration<URL> items = Util.getCurrentLoader(this).getResources(META_INF_RESOURCES);
            while (items.hasMoreElements()) {
                URL nextElement = items.nextElement();
                String jarUrl = nextElement.toString();
                String jarName = null;
                Matcher m = JAR_PATTERN.matcher(jarUrl);
                if (m.matches()) {
                    jarName = m.group(1);
                }
                if (jarName != null) {
                    if (duplicatePattern != null && (m = duplicatePattern.matcher(jarName)).matches()) {
                        jarName = m.group(1);
                    }
                    sortedJarMap.put(jarName, nextElement);
                    continue;
                }
                unsortedResourceList.add(0, nextElement);
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        ArrayList<URL> result = new ArrayList<URL>(sortedJarMap.size() + unsortedResourceList.size());
        for (Map.Entry entry : sortedJarMap.entrySet()) {
            result.add((URL)entry.getValue());
        }
        result.addAll(unsortedResourceList);
        return result;
    }
}

