/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Executor;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.ServiceMapperListener;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;

public class StandardService
implements Lifecycle,
Service,
MBeanRegistration {
    private static Logger log = Logger.getLogger(StandardService.class);
    public static final boolean DELAY_CONNECTOR_STARTUP = Boolean.valueOf(System.getProperty("org.apache.catalina.core.StandardService.DELAY_CONNECTOR_STARTUP", "true"));
    private static final String info = "org.apache.catalina.core.StandardService/1.0";
    private String name = null;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private Server server = null;
    private boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Connector[] connectors = new Connector[0];
    protected ArrayList<Executor> executors = new ArrayList();
    protected Container container = null;
    protected Mapper mapper = new Mapper();
    protected ServiceMapperListener mapperListener = new ServiceMapperListener(this.mapper);
    protected boolean initialized = false;
    protected String type;
    protected String domain;
    protected String suffix;
    protected ObjectName oname;
    protected ObjectName controller;
    protected MBeanServer mserver;

    @Override
    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        if (oldContainer != null && oldContainer instanceof Engine) {
            ((Engine)oldContainer).setService(null);
        }
        this.container = container;
        if (this.container != null && this.container instanceof Engine) {
            ((Engine)this.container).setService(this);
        }
        if (this.started && this.container != null && this.container instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.container)).start();
            }
            catch (LifecycleException e) {
                // empty catch block
            }
        }
        Connector[] e = this.connectors;
        synchronized (this.connectors) {
            for (int i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].setContainer(this.container);
            }
            // ** MonitorExit[e] (shouldn't be in output)
            if (this.started && oldContainer != null && oldContainer instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldContainer)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("container", oldContainer, this.container);
            return;
        }
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    public ObjectName getContainerName() {
        if (this.container instanceof ContainerBase) {
            return ((ContainerBase)this.container).getJmxName();
        }
        return null;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            connector.setContainer(this.container);
            connector.setService(this);
            Connector[] results = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, results, 0, this.connectors.length);
            results[this.connectors.length] = connector;
            this.connectors = results;
            if (this.initialized) {
                try {
                    connector.initialize();
                }
                catch (LifecycleException e) {
                    log.error((Object)"Connector.initialize", (Throwable)e);
                }
            }
            if (this.started && connector instanceof Lifecycle) {
                try {
                    connector.start();
                }
                catch (LifecycleException e) {
                    log.error((Object)"Connector.start", (Throwable)e);
                }
            }
            this.support.firePropertyChange("connector", null, connector);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ObjectName[] getConnectorNames() {
        ObjectName[] results = new ObjectName[this.connectors.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.connectors[i].getObjectName();
        }
        return results;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Connector[] findConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            int j = -1;
            for (int i = 0; i < this.connectors.length; ++i) {
                if (connector != this.connectors[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.started && this.connectors[j] instanceof Lifecycle) {
                try {
                    this.connectors[j].stop();
                }
                catch (LifecycleException e) {
                    log.error((Object)"Connector.stop", (Throwable)e);
                }
            }
            this.connectors[j].setContainer(null);
            connector.setService(null);
            int k = 0;
            Connector[] results = new Connector[this.connectors.length - 1];
            for (int i = 0; i < this.connectors.length; ++i) {
                if (i == j) continue;
                results[k++] = this.connectors[i];
            }
            this.connectors = results;
            this.support.firePropertyChange("connector", connector, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardService[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutor(Executor ex) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (!this.executors.contains(ex)) {
                this.executors.add(ex);
                if (this.started) {
                    try {
                        ex.start();
                    }
                    catch (LifecycleException x) {
                        log.error((Object)"Executor.start", (Throwable)x);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor[] findExecutors() {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            Executor[] arr = new Executor[this.executors.size()];
            this.executors.toArray(arr);
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor getExecutor(String name) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            for (int i = 0; i < this.executors.size(); ++i) {
                if (!name.equals(this.executors.get(i).getName())) continue;
                return this.executors.get(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutor(Executor ex) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (this.executors.remove(ex) && this.started) {
                try {
                    ex.stop();
                }
                catch (LifecycleException e) {
                    log.error((Object)"Executor.stop", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void start() throws LifecycleException {
        int i;
        Connector[] connectorArray;
        if (log.isInfoEnabled() && this.started) {
            log.info((Object)sm.getString("standardService.start.started"));
        }
        if (!this.initialized) {
            this.init();
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("standardService.start.name", this.name));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.container != null) {
            connectorArray = this.container;
            // MONITORENTER : connectorArray
            if (this.container instanceof Lifecycle) {
                ((Lifecycle)((Object)this.container)).start();
            }
            // MONITOREXIT : connectorArray
        }
        connectorArray = this.executors;
        // MONITORENTER : connectorArray
        for (i = 0; i < this.executors.size(); ++i) {
            this.executors.get(i).start();
        }
        // MONITOREXIT : connectorArray
        if (!DELAY_CONNECTOR_STARTUP) {
            connectorArray = this.connectors;
            // MONITORENTER : this.connectors
            for (i = 0; i < this.connectors.length; ++i) {
                if (!(this.connectors[i] instanceof Lifecycle)) continue;
                this.connectors[i].start();
            }
            // MONITOREXIT : connectorArray
        }
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void stop() throws LifecycleException {
        int i;
        Object object;
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        if (!DELAY_CONNECTOR_STARTUP) {
            object = this.connectors;
            // MONITORENTER : this.connectors
            for (i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].pause();
            }
            // MONITOREXIT : object
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("standardService.stop.name", this.name));
        }
        this.started = false;
        if (this.container != null) {
            object = this.container;
            // MONITORENTER : object
            if (this.container instanceof Lifecycle) {
                ((Lifecycle)((Object)this.container)).stop();
            }
            // MONITOREXIT : object
        }
        if (!DELAY_CONNECTOR_STARTUP) {
            object = this.connectors;
            // MONITORENTER : this.connectors
            for (i = 0; i < this.connectors.length; ++i) {
                if (!(this.connectors[i] instanceof Lifecycle)) continue;
                this.connectors[i].stop();
            }
            // MONITOREXIT : object
        }
        object = this.executors;
        // MONITORENTER : object
        for (i = 0; i < this.executors.size(); ++i) {
            this.executors.get(i).stop();
        }
        // MONITOREXIT : object
        if (this.oname == this.controller) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
            Executor[] executors = this.findExecutors();
            for (i = 0; i < executors.length; ++i) {
                try {
                    ObjectName executorObjectName = new ObjectName(this.domain + ":type=Executor,name=" + executors[i].getName());
                    Registry.getRegistry(null, null).unregisterComponent(executorObjectName);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws LifecycleException {
        if (this.initialized) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("standardService.initialize.initialized"));
            }
            return;
        }
        this.initialized = true;
        if (this.oname == null) {
            try {
                Container engine = this.getContainer();
                this.domain = engine.getName();
                this.controller = this.oname = new ObjectName(this.domain + ":type=Service,serviceName=" + this.name);
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
                Executor[] executors = this.findExecutors();
                for (int i = 0; i < executors.length; ++i) {
                    ObjectName executorObjectName = new ObjectName(this.domain + ":type=Executor,name=" + executors[i].getName());
                    Registry.getRegistry(null, null).registerComponent((Object)executors[i], executorObjectName, null);
                }
            }
            catch (Exception e) {
                log.error((Object)sm.getString("standardService.register.failed", this.domain), (Throwable)e);
            }
        }
        if (this.server == null) {
            this.server = new StandardServer();
            this.server.addService(this);
        }
        this.addLifecycleListener(this.mapperListener);
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (int i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].initialize();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void destroy() throws LifecycleException {
        if (this.started) {
            this.stop();
        }
        this.removeLifecycleListener(this.mapperListener);
    }

    public void init() {
        try {
            this.initialize();
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("standardService.initialize.failed", this.domain), t);
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }
}

