/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security.authenticators;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.security.ExtendedRealm;

public class JASPIFormAuthenticator
extends FormAuthenticator {
    private static Logger log = Logger.getLogger(JASPIFormAuthenticator.class);

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        boolean loginAction;
        Session session = null;
        Principal principal = request.getUserPrincipal();
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            if (ssoId != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        if (ssoId != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SSO Id " + ssoId + " set; attempting " + "reauthentication"));
            }
            if (this.reauthenticateFromSSO(ssoId, request)) {
                return true;
            }
        }
        if (!this.cache) {
            session = request.getSessionInternal(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking for reauthenticate in session " + session));
            }
            String username = (String)session.getNote("org.apache.catalina.session.USERNAME");
            String password = (String)session.getNote("org.apache.catalina.session.PASSWORD");
            if (username != null && password != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reauthenticating username '" + username + "'"));
                }
                ExtendedRealm realm = (ExtendedRealm)this.context.getRealm();
                try {
                    principal = realm.authenticate(request, response, config);
                }
                catch (Exception e) {
                    log.error((Object)"Exception in realm authenticate:", (Throwable)e);
                }
                if (principal != null) {
                    session.setNote("org.apache.catalina.authenticator.PRINCIPAL", (Object)principal);
                    if (!this.matchRequest(request)) {
                        this.register(request, response, principal, "FORM", username, password);
                        return true;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Reauthentication failed, proceed normally");
                }
            }
        }
        if (this.matchRequest(request)) {
            session = request.getSessionInternal(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restore request from session '" + session.getIdInternal() + "'"));
            }
            principal = (Principal)session.getNote("org.apache.catalina.authenticator.PRINCIPAL");
            this.register(request, response, principal, "FORM", (String)session.getNote("org.apache.catalina.session.USERNAME"), (String)session.getNote("org.apache.catalina.session.PASSWORD"));
            if (this.cache) {
                session.removeNote("org.apache.catalina.session.USERNAME");
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
            if (this.restoreRequest(request, session)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Proceed to restored request");
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Restore of original request failed");
            }
            response.sendError(400);
            return false;
        }
        MessageBytes uriMB = MessageBytes.newInstance();
        CharChunk uriCC = uriMB.getCharChunk();
        uriCC.setLimit(-1);
        String contextPath = request.getContextPath();
        String requestURI = request.getDecodedRequestURI();
        boolean bl = loginAction = requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check");
        if (!loginAction) {
            session = request.getSessionInternal(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Save request in session '" + session.getIdInternal() + "'"));
            }
            try {
                this.saveRequest(request, session);
            }
            catch (IOException ioe) {
                log.debug((Object)"Request body too big to save during authentication");
                response.sendError(403, sm.getString("authenticator.requestBodyTooBig"));
                return false;
            }
            this.forwardToLoginPage(request, response, config);
            return false;
        }
        ExtendedRealm realm = (ExtendedRealm)this.context.getRealm();
        if (this.characterEncoding != null) {
            request.setCharacterEncoding(this.characterEncoding);
        }
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authenticating username '" + username + "'"));
        }
        try {
            principal = realm.authenticate(request, response, config);
        }
        catch (Exception e) {
            log.error((Object)"Exception in realm authenticate:", (Throwable)e);
        }
        if (principal == null) {
            this.forwardToErrorPage(request, response, config);
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication of '" + username + "' was successful"));
        }
        if (session == null) {
            session = request.getSessionInternal(false);
        }
        if (session == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"User took so long to log on the session expired");
            }
            response.sendError(408, sm.getString("authenticator.sessionExpired"));
            return false;
        }
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", (Object)principal);
        session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
        session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
        requestURI = this.savedRequestURL(session);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirecting to original '" + requestURI + "'"));
        }
        if (requestURI == null) {
            response.sendError(400, sm.getString("authenticator.formlogin"));
        } else {
            response.sendRedirect(response.encodeRedirectURL(requestURI));
        }
        return false;
    }
}

