/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.ejb.spi.HandleDelegate;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.log4j.Logger;
import org.jboss.config.ServerConfigUtil;
import org.jboss.iiop.CorbaORB;
import org.jboss.iiop.CorbaORBServiceMBean;
import org.jboss.iiop.naming.ORBInitialContextFactory;
import org.jboss.metadata.IorSecurityConfigMetaData;
import org.jboss.proxy.ejb.handle.HandleDelegateImpl;
import org.jboss.security.SecurityDomain;
import org.jboss.system.ORBSingleton;
import org.jboss.system.Registry;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaORBService
implements CorbaORBServiceMBean,
ObjectFactory {
    public static String ORB_NAME = "JBossCorbaORB";
    public static String POA_NAME = "JBossCorbaPOA";
    public static String IR_POA_NAME = "JBossCorbaInterfaceRepositoryPOA";
    public static String SSL_DOMAIN = "JBossCorbaSSLDomain";
    public static String IOR_SECURITY_CONFIG = "IORSecurityConfig";
    private String orbClass = null;
    private String orbSingletonClass = null;
    private String orbSingletonDelegate = null;
    private String orbPropertiesFileName = "orb-properties-file-not-defined";
    private List<String> portableInterceptorInitializers = null;
    private int port = 0;
    private int sslPort = 0;
    private SecurityDomain sslDomain = null;
    private IorSecurityConfigMetaData defaultIORSecurityConfig = null;
    private static ORB orb;
    private static POA poa;
    private static POA otsPoa;
    private static POA otsResourcePoa;
    private static POA irPoa;
    private static HandleDelegate hd;
    private static int oaSslPort;
    private static Logger log;
    private static boolean sslComponentsEnabledFlag;
    private static boolean sendSasAcceptWithExceptionEnabledFlag;
    private static boolean otsContextPropagationEnabledFlag;

    public static int getTheActualSSLPort() {
        return oaSslPort;
    }

    public static boolean getSSLComponentsEnabledFlag() {
        return sslComponentsEnabledFlag;
    }

    public static boolean getSendSASAcceptWithExceptionEnabledFlag() {
        return sendSasAcceptWithExceptionEnabledFlag;
    }

    public static boolean getOTSContextPropagationEnabledFlag() {
        return otsContextPropagationEnabledFlag;
    }

    public static POA getOtsPoa() {
        return otsPoa;
    }

    public static POA getOtsResourcePoa() {
        return otsResourcePoa;
    }

    public void start() throws Exception {
        String oaSslPortString;
        String str;
        Properties props = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(this.orbPropertiesFileName);
        props.load(is);
        String oaiAddr = props.getProperty("OAIAddr");
        if (oaiAddr == null) {
            oaiAddr = ServerConfigUtil.getSpecificBindAddress();
        }
        if (oaiAddr != null) {
            props.setProperty("OAIAddr", oaiAddr);
        }
        log.debug((java.lang.Object)("Using OAIAddr=" + oaiAddr));
        Properties systemProps = System.getProperties();
        if (this.orbClass != null) {
            props.put("org.omg.CORBA.ORBClass", this.orbClass);
            systemProps.put("org.omg.CORBA.ORBClass", this.orbClass);
        }
        if (this.orbSingletonClass != null) {
            props.put("org.omg.CORBA.ORBSingletonClass", this.orbSingletonClass);
            systemProps.put("org.omg.CORBA.ORBSingletonClass", this.orbSingletonClass);
        }
        if (this.orbSingletonDelegate != null) {
            systemProps.put(ORBSingleton.DELEGATE_CLASS_KEY, this.orbSingletonDelegate);
        }
        if ((str = props.getProperty("jacorb.config.log.verbosity")) != null) {
            systemProps.put("jacorb.config.log.verbosity", str);
        }
        System.setProperties(systemProps);
        if (this.defaultIORSecurityConfig == null) {
            this.defaultIORSecurityConfig = new IorSecurityConfigMetaData();
        }
        Registry.bind((java.lang.Object)IOR_SECURITY_CONFIG, (java.lang.Object)this.defaultIORSecurityConfig);
        if (this.portableInterceptorInitializers != null) {
            for (String initializer : this.portableInterceptorInitializers) {
                if (initializer == null || initializer.equals("")) continue;
                log.debug((java.lang.Object)("Adding portable interceptor initializer: " + initializer));
                props.put("org.omg.PortableInterceptor.ORBInitializerClass." + initializer, "");
            }
        }
        if (this.port != 0) {
            props.put("OAPort", Integer.toString(this.port));
        }
        if (this.sslPort != 0) {
            props.put("OASSLPort", Integer.toString(this.sslPort));
        }
        if ((oaSslPortString = props.getProperty("OASSLPort")) != null) {
            oaSslPort = Integer.parseInt(oaSslPortString);
        }
        if (this.sslDomain != null) {
            Registry.bind((java.lang.Object)SSL_DOMAIN, (java.lang.Object)this.sslDomain);
        }
        orb = ORB.init((String[])new String[0], (Properties)props);
        this.bind(ORB_NAME, "org.omg.CORBA.ORB");
        CorbaORB.setInstance(orb);
        ORBInitialContextFactory.setORB(orb);
        poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        this.bind(POA_NAME, "org.omg.PortableServer.POA");
        Policy[] policies = new Policy[]{poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), poa.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), poa.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), poa.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID)};
        otsPoa = poa.create_POA("OTS", null, policies);
        otsResourcePoa = poa.create_POA("OTSResources", otsPoa.the_POAManager(), policies);
        poa.the_POAManager().activate();
        new Thread(new Runnable(){

            public void run() {
                orb.run();
            }
        }, "ORB thread").start();
        try {
            LifespanPolicy lifespanPolicy = poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT);
            IdAssignmentPolicy idAssignmentPolicy = poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
            irPoa = poa.create_POA("IR", null, new Policy[]{lifespanPolicy, idAssignmentPolicy});
            this.bind(IR_POA_NAME, "org.omg.PortableServer.POA");
            irPoa.the_POAManager().activate();
        }
        catch (Exception ex) {
            log.error((java.lang.Object)"Error in IR POA initialization", (Throwable)ex);
        }
        hd = new HandleDelegateImpl();
    }

    public void stop() throws Exception {
        try {
            this.unbind(ORB_NAME);
            this.unbind(POA_NAME);
            this.unbind(IR_POA_NAME);
            orb.shutdown(false);
            Registry.unbind((java.lang.Object)SSL_DOMAIN);
        }
        catch (Exception e) {
            log.error((java.lang.Object)"Exception while stopping ORB service", (Throwable)e);
        }
    }

    @Override
    public ORB getORB() {
        return orb;
    }

    @Override
    public HandleDelegate getHandleDelegate() {
        return hd;
    }

    @Override
    public String getORBClass() {
        return this.orbClass;
    }

    @Override
    public void setORBClass(String orbClass) {
        this.orbClass = orbClass;
    }

    @Override
    public String getORBSingletonClass() {
        return this.orbSingletonClass;
    }

    @Override
    public void setORBSingletonClass(String orbSingletonClass) {
        this.orbSingletonClass = orbSingletonClass;
    }

    @Override
    public String getORBSingletonDelegate() {
        return this.orbSingletonDelegate;
    }

    @Override
    public void setORBSingletonDelegate(String orbSingletonDelegate) {
        this.orbSingletonDelegate = orbSingletonDelegate;
    }

    @Override
    public void setORBPropertiesFileName(String orbPropertiesFileName) {
        this.orbPropertiesFileName = orbPropertiesFileName;
    }

    @Override
    public String getORBPropertiesFileName() {
        return this.orbPropertiesFileName;
    }

    @Override
    public List<String> getPortableInterceptorInitializers() {
        return this.portableInterceptorInitializers;
    }

    @Override
    public void setPortableInterceptorInitializers(List<String> portableInterceptorInitializers) {
        this.portableInterceptorInitializers = portableInterceptorInitializers;
    }

    @Override
    public IorSecurityConfigMetaData getDefaultIORSecurityConfig() {
        return this.defaultIORSecurityConfig;
    }

    @Override
    public void setDefaultIORSecurityConfig(IorSecurityConfigMetaData config) {
        this.defaultIORSecurityConfig = config;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setSSLPort(int sslPort) {
        this.sslPort = sslPort;
    }

    @Override
    public int getSSLPort() {
        return this.sslPort;
    }

    @Override
    public void setSecurityDomain(SecurityDomain sslDomain) {
        this.sslDomain = sslDomain;
    }

    @Override
    public SecurityDomain getSecurityDomain() {
        return this.sslDomain;
    }

    @Override
    public boolean getSSLComponentsEnabled() {
        return sslComponentsEnabledFlag;
    }

    @Override
    public void setSSLComponentsEnabled(boolean sslComponentsEnabled) {
        sslComponentsEnabledFlag = sslComponentsEnabled;
    }

    @Override
    public boolean getSendSASAcceptWithExceptionEnabled() {
        return sendSasAcceptWithExceptionEnabledFlag;
    }

    @Override
    public void setSendSASAcceptWithExceptionEnabled(boolean value) {
        sendSasAcceptWithExceptionEnabledFlag = value;
    }

    @Override
    public boolean getOTSContextPropagationEnabled() {
        return otsContextPropagationEnabledFlag;
    }

    @Override
    public void setOTSContextPropagationEnabled(boolean value) {
        otsContextPropagationEnabledFlag = value;
    }

    @Override
    public boolean getSunJDK14IsLocalBugFix() {
        return false;
    }

    @Override
    public void setSunJDK14IsLocalBugFix(boolean sunJDK14IsLocalBugFix) {
        log.warn((java.lang.Object)"Not setting SunJDK14IsLocalBugFix since JDK1.4 is no longer supported.");
    }

    @Override
    public java.lang.Object getObjectInstance(java.lang.Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        String s = name.toString();
        if (log.isTraceEnabled()) {
            log.trace((java.lang.Object)("getObjectInstance: obj.getClass().getName=\"" + obj.getClass().getName() + "\n                   name=" + s));
        }
        if (ORB_NAME.equals(s)) {
            return orb;
        }
        if (POA_NAME.equals(s)) {
            return poa;
        }
        if (IR_POA_NAME.equals(s)) {
            return irPoa;
        }
        return null;
    }

    private void bind(String name, String className) throws Exception {
        Reference ref = new Reference(className, this.getClass().getName(), null);
        new InitialContext().bind("java:/" + name, (java.lang.Object)ref);
    }

    private void unbind(String name) throws Exception {
        new InitialContext().unbind("java:/" + name);
    }

    static {
        log = Logger.getLogger(CorbaORBService.class);
        sslComponentsEnabledFlag = false;
        sendSasAcceptWithExceptionEnabledFlag = true;
        otsContextPropagationEnabledFlag = false;
    }
}

