/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class RectListManager
implements Collection {
    Rectangle[] rects = null;
    int size = 0;
    Rectangle bounds = null;
    public static Comparator comparator = new RectXComparator();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$Rectangle;

    public RectListManager(Collection collection) {
        this.rects = new Rectangle[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.rects[n++] = (Rectangle)iterator.next();
        }
        this.size = this.rects.length;
        Arrays.sort(this.rects, comparator);
    }

    public RectListManager(Rectangle[] rectangleArray) {
        this(rectangleArray, 0, rectangleArray.length);
    }

    public RectListManager(Rectangle[] rectangleArray, int n, int n2) {
        this.size = n2;
        this.rects = new Rectangle[n2];
        System.arraycopy(rectangleArray, n, this.rects, 0, n2);
        Arrays.sort(this.rects, comparator);
    }

    public RectListManager(RectListManager rectListManager) {
        this(rectListManager.rects);
    }

    public RectListManager(Rectangle rectangle) {
        this();
        this.add(rectangle);
    }

    public RectListManager() {
        this.rects = new Rectangle[10];
        this.size = 0;
    }

    public RectListManager(int n) {
        this.rects = new Rectangle[n];
    }

    public Rectangle getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        if (this.size == 0) {
            return null;
        }
        this.bounds = new Rectangle(this.rects[0]);
        int n = 1;
        while (n < this.size) {
            Rectangle rectangle = this.rects[n];
            if (rectangle.x < this.bounds.x) {
                this.bounds.width = this.bounds.x + this.bounds.width - rectangle.x;
                this.bounds.x = rectangle.x;
            }
            if (rectangle.y < this.bounds.y) {
                this.bounds.height = this.bounds.y + this.bounds.height - rectangle.y;
                this.bounds.y = rectangle.y;
            }
            if (rectangle.x + rectangle.width > this.bounds.x + this.bounds.width) {
                this.bounds.width = rectangle.x + rectangle.width - this.bounds.x;
            }
            if (rectangle.y + rectangle.height > this.bounds.y + this.bounds.height) {
                this.bounds.height = rectangle.y + rectangle.height - this.bounds.y;
            }
            ++n;
        }
        return this.bounds;
    }

    public Object clone() {
        return this.copy();
    }

    public RectListManager copy() {
        return new RectListManager(this.rects);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        int n = 0;
        while (n < this.size) {
            this.rects[n] = null;
            ++n;
        }
        this.size = 0;
    }

    public Iterator iterator() {
        return new RLMIterator();
    }

    public ListIterator listIterator() {
        return new RLMIterator();
    }

    public Object[] toArray() {
        Object[] objectArray = new Rectangle[this.size];
        System.arraycopy(this.rects, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        if (clazz != (class$java$lang$Object == null ? (class$java$lang$Object = RectListManager.class$("java.lang.Object")) : class$java$lang$Object) & clazz != (class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = RectListManager.class$("java.awt.Rectangle")) : class$java$awt$Rectangle)) {
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = null;
                ++n;
            }
            return objectArray;
        }
        if (objectArray.length < this.size) {
            objectArray = new Rectangle[this.size];
        }
        System.arraycopy(this.rects, 0, objectArray, 0, this.size);
        int n = this.size;
        while (n < objectArray.length) {
            objectArray[n] = null;
            ++n;
        }
        return objectArray;
    }

    public boolean add(Object object) {
        this.add((Rectangle)object);
        return true;
    }

    public void add(Rectangle rectangle) {
        this.add(rectangle, 0, this.size - 1);
    }

    protected void add(Rectangle rectangle, int n, int n2) {
        this.ensureCapacity(this.size + 1);
        int n3 = n;
        while (n <= n2) {
            n3 = (n + n2) / 2;
            while (this.rects[n3] == null && n3 < n2) {
                ++n3;
            }
            if (this.rects[n3] == null) {
                n2 = (n + n2) / 2;
                n3 = (n + n2) / 2;
                if (n > n2) {
                    n3 = n;
                }
                while (this.rects[n3] == null && n3 > n) {
                    --n3;
                }
                if (this.rects[n3] == null) {
                    this.rects[n3] = rectangle;
                    return;
                }
            }
            if (rectangle.x == this.rects[n3].x) break;
            if (rectangle.x < this.rects[n3].x) {
                if (n3 == 0 || this.rects[n3 - 1] != null && rectangle.x >= this.rects[n3 - 1].x) break;
                n2 = n3 - 1;
                continue;
            }
            if (n3 == this.size - 1) {
                ++n3;
                break;
            }
            if (this.rects[n3 + 1] != null && rectangle.x <= this.rects[n3 + 1].x) {
                ++n3;
                break;
            }
            n = n3 + 1;
        }
        if (n3 < this.size) {
            System.arraycopy(this.rects, n3, this.rects, n3 + 1, this.size - n3);
        }
        this.rects[n3] = rectangle;
        ++this.size;
    }

    public boolean addAll(Collection collection) {
        if (collection instanceof RectListManager) {
            this.add((RectListManager)collection);
        } else {
            this.add(new RectListManager(collection));
        }
        return collection.size() != 0;
    }

    public boolean contains(Object object) {
        Rectangle rectangle = (Rectangle)object;
        int n = 0;
        int n2 = this.size - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = (n + n2) / 2;
            if (rectangle.x == this.rects[n3].x) break;
            if (rectangle.x < this.rects[n3].x) {
                if (n3 == 0 || rectangle.x >= this.rects[n3 - 1].x) break;
                n2 = n3 - 1;
                continue;
            }
            if (n3 == this.size - 1) {
                ++n3;
                break;
            }
            if (rectangle.x <= this.rects[n3 + 1].x) {
                ++n3;
                break;
            }
            n = n3 + 1;
        }
        if (this.rects[n3].x != rectangle.x) {
            return false;
        }
        int n4 = n3;
        while (n4 >= 0) {
            if (this.rects[n3].equals(rectangle)) {
                return true;
            }
            if (this.rects[n3].x != rectangle.x) break;
            --n4;
        }
        int n5 = n3 + 1;
        while (n5 < this.size) {
            if (this.rects[n3].equals(rectangle)) {
                return true;
            }
            if (this.rects[n3].x != rectangle.x) break;
            ++n5;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        if (collection instanceof RectListManager) {
            return this.containsAll((RectListManager)collection);
        }
        return this.containsAll(new RectListManager(collection));
    }

    public boolean containsAll(RectListManager rectListManager) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < rectListManager.size) {
            n3 = n;
            while (this.rects[n3].x < rectListManager.rects[n2].x) {
                if (++n3 != this.size) continue;
                return false;
            }
            n = n3;
            int n4 = this.rects[n3].x;
            while (!rectListManager.rects[n2].equals(this.rects[n3])) {
                if (++n3 == this.size) {
                    return false;
                }
                if (n4 == this.rects[n3].x) continue;
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean remove(Object object) {
        return this.remove((Rectangle)object);
    }

    public boolean remove(Rectangle rectangle) {
        int n = 0;
        int n2 = this.size - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = (n + n2) / 2;
            if (rectangle.x == this.rects[n3].x) break;
            if (rectangle.x < this.rects[n3].x) {
                if (n3 == 0 || rectangle.x >= this.rects[n3 - 1].x) break;
                n2 = n3 - 1;
                continue;
            }
            if (n3 == this.size - 1) {
                ++n3;
                break;
            }
            if (rectangle.x <= this.rects[n3 + 1].x) {
                ++n3;
                break;
            }
            n = n3 + 1;
        }
        if (this.rects[n3].x != rectangle.x) {
            return false;
        }
        int n4 = n3;
        while (n4 >= 0) {
            if (this.rects[n3].equals(rectangle)) {
                System.arraycopy(this.rects, n3 + 1, this.rects, n3, this.size - n3);
                --this.size;
                return true;
            }
            if (this.rects[n3].x != rectangle.x) break;
            --n4;
        }
        int n5 = n3 + 1;
        while (n5 < this.size) {
            if (this.rects[n3].equals(rectangle)) {
                System.arraycopy(this.rects, n3 + 1, this.rects, n3, this.size - n3);
                --this.size;
                return true;
            }
            if (this.rects[n3].x != rectangle.x) break;
            ++n5;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        if (collection instanceof RectListManager) {
            return this.removeAll((RectListManager)collection);
        }
        return this.removeAll(new RectListManager(collection));
    }

    public boolean removeAll(RectListManager rectListManager) {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n2 < rectListManager.size) {
            n3 = n;
            while (this.rects[n3] == null || this.rects[n3].x < rectListManager.rects[n2].x) {
                if (++n3 == this.size) break;
            }
            if (n3 == this.size) break;
            n = n3;
            int n4 = this.rects[n3].x;
            while (true) {
                if (this.rects[n3] == null) {
                    if (++n3 != this.size) continue;
                    break;
                }
                if (rectListManager.rects[n2].equals(this.rects[n3])) {
                    this.rects[n3] = null;
                    bl = true;
                }
                if (++n3 == this.size || n4 != this.rects[n3].x) break;
            }
            ++n2;
        }
        if (bl) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.size) {
                if (this.rects[n6] != null) {
                    this.rects[n5++] = this.rects[n6];
                }
                ++n6;
            }
            this.size = n5;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        if (collection instanceof RectListManager) {
            return this.retainAll((RectListManager)collection);
        }
        return this.retainAll(new RectListManager(collection));
    }

    public boolean retainAll(RectListManager rectListManager) {
        int n;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.size) {
            n4 = n2;
            while (rectListManager.rects[n4].x < this.rects[n3].x) {
                if (++n4 == rectListManager.size) break;
            }
            if (n4 == rectListManager.size) {
                bl = true;
                n = n3;
                while (n < this.size) {
                    this.rects[n] = null;
                    ++n;
                }
                this.size = n3;
                break;
            }
            n2 = n4;
            int n5 = rectListManager.rects[n4].x;
            while (!this.rects[n3].equals(rectListManager.rects[n4])) {
                if (++n4 != rectListManager.size && n5 == rectListManager.rects[n4].x) continue;
                this.rects[n3] = null;
                bl = true;
                break;
            }
            ++n3;
        }
        if (bl) {
            n = 0;
            int n6 = 0;
            while (n6 < this.size) {
                if (this.rects[n6] != null) {
                    this.rects[n++] = this.rects[n6];
                }
                ++n6;
            }
            this.size = n;
        }
        return bl;
    }

    public void add(RectListManager rectListManager) {
        if (rectListManager.size == 0) {
            return;
        }
        Rectangle[] rectangleArray = this.rects;
        if (this.rects.length < this.size + rectListManager.size) {
            rectangleArray = new Rectangle[this.size + rectListManager.size];
        }
        if (this.size == 0) {
            System.arraycopy(rectListManager.rects, 0, rectangleArray, this.size, rectListManager.size);
            this.size = rectListManager.size;
            return;
        }
        Rectangle[] rectangleArray2 = rectListManager.rects;
        int n = rectListManager.size;
        int n2 = n - 1;
        Rectangle[] rectangleArray3 = this.rects;
        int n3 = this.size;
        int n4 = n3 - 1;
        int n5 = this.size + rectListManager.size - 1;
        int n6 = rectangleArray2[n2].x;
        int n7 = rectangleArray3[n4].x;
        while (n5 >= 0) {
            if (n6 <= n7) {
                rectangleArray[n5] = rectangleArray3[n4];
                if (n4 == 0) {
                    System.arraycopy(rectangleArray2, 0, rectangleArray, 0, n2 + 1);
                    break;
                }
                n7 = rectangleArray3[--n4].x;
            } else {
                rectangleArray[n5] = rectangleArray2[n2];
                if (n2 == 0) {
                    System.arraycopy(rectangleArray3, 0, rectangleArray, 0, n4 + 1);
                    break;
                }
                n6 = rectangleArray2[--n2].x;
            }
            --n5;
        }
        this.rects = rectangleArray;
        this.size += rectListManager.size;
    }

    public void mergeRects(int n, int n2) {
        int n3;
        int n4;
        Rectangle rectangle;
        if (this.size == 0) {
            return;
        }
        Rectangle rectangle2 = new Rectangle();
        Rectangle[] rectangleArray = new Rectangle[4];
        int n5 = 0;
        while (n5 < this.size) {
            rectangle = this.rects[n5];
            if (rectangle != null) {
                int n6;
                int n7 = n + rectangle.height * n2 + rectangle.height * rectangle.width;
                block1: do {
                    n4 = rectangle.x + rectangle.width + n / rectangle.height;
                    n6 = n5 + 1;
                    while (n6 < this.size) {
                        Rectangle rectangle3 = this.rects[n6];
                        if (rectangle3 != null && rectangle3 != rectangle) {
                            if (rectangle3.x >= n4) {
                                n6 = this.size;
                                continue block1;
                            }
                            int n8 = n + rectangle3.height * n2 + rectangle3.height * rectangle3.width;
                            rectangle2 = rectangle.union(rectangle3);
                            int n9 = n + rectangle2.height * n2 + rectangle2.height * rectangle2.width;
                            if (n9 <= n7 + n8) {
                                rectangle = this.rects[n5] = rectangle2;
                                this.rects[n6] = null;
                                n7 = n9;
                                n6 = -1;
                                continue block1;
                            }
                            if (rectangle.intersects(rectangle3)) {
                                this.splitRect(rectangle3, rectangle, rectangleArray);
                                n3 = 0;
                                int n10 = 0;
                                int n11 = 0;
                                while (n11 < 4) {
                                    if (rectangleArray[n11] != null) {
                                        Rectangle rectangle4 = rectangleArray[n11];
                                        if (n11 < 3) {
                                            rectangleArray[n10++] = rectangle4;
                                        }
                                        n3 += n + rectangle4.height * n2 + rectangle4.height * rectangle4.width;
                                    }
                                    ++n11;
                                }
                                if (n3 < n8) {
                                    if (n10 == 0) {
                                        this.rects[n6] = null;
                                        if (rectangleArray[3] != null) {
                                            this.add(rectangleArray[3], n6, this.size - 1);
                                        }
                                    } else {
                                        this.rects[n6] = rectangleArray[0];
                                        if (n10 > 1) {
                                            this.insertRects(rectangleArray, 1, n6 + 1, n10 - 1);
                                        }
                                        if (rectangleArray[3] != null) {
                                            this.add(rectangleArray[3], n6, this.size - 1);
                                        }
                                    }
                                }
                            }
                        }
                        ++n6;
                    }
                } while (n6 != this.size);
            }
            ++n5;
        }
        n4 = 0;
        n3 = 0;
        float f = 0.0f;
        while (n3 < this.size) {
            if (this.rects[n3] != null) {
                rectangle = this.rects[n3];
                this.rects[n4++] = rectangle;
                f += (float)(n + rectangle.height * n2 + rectangle.height * rectangle.width);
            }
            ++n3;
        }
        this.size = n4;
        rectangle = this.getBounds();
        if (rectangle == null) {
            return;
        }
        if ((float)(n + rectangle.height * n2 + rectangle.height * rectangle.width) < f) {
            this.rects[0] = rectangle;
            this.size = 1;
        }
    }

    public void subtract(RectListManager rectListManager, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        Rectangle[] rectangleArray = new Rectangle[4];
        int n6 = 0;
        while (n6 < this.size) {
            Rectangle rectangle = this.rects[n6];
            int n7 = n + rectangle.height * n2 + rectangle.height * rectangle.width;
            n4 = n5;
            while (n4 < rectListManager.size) {
                Rectangle rectangle2 = rectListManager.rects[n4];
                if (rectangle2.x + rectangle2.width < rectangle.x) {
                    if (n4 == n5) {
                        ++n5;
                    }
                } else {
                    if (rectangle2.x > rectangle.x + rectangle.width) break;
                    if (rectangle.intersects(rectangle2)) {
                        this.splitRect(rectangle, rectangle2, rectangleArray);
                        n3 = 0;
                        int n8 = 0;
                        while (n8 < 4) {
                            Rectangle rectangle3 = rectangleArray[n8];
                            if (rectangle3 != null) {
                                n3 += n + rectangle3.height * n2 + rectangle3.height * rectangle3.width;
                            }
                            ++n8;
                        }
                        if (n3 < n7) {
                            int n9 = 0;
                            int n10 = 0;
                            while (n10 < 3) {
                                if (rectangleArray[n10] != null) {
                                    rectangleArray[n9++] = rectangleArray[n10];
                                }
                                ++n10;
                            }
                            if (n9 == 0) {
                                this.rects[n6].width = 0;
                                if (rectangleArray[3] == null) break;
                                this.add(rectangleArray[3], n6, this.size - 1);
                                break;
                            }
                            this.rects[n6] = rectangle = rectangleArray[0];
                            n7 = n + rectangle.height * n2 + rectangle.height * rectangle.width;
                            if (n9 > 1) {
                                this.insertRects(rectangleArray, 1, n6 + 1, n9 - 1);
                            }
                            if (rectangleArray[3] != null) {
                                this.add(rectangleArray[3], n6 + n9, this.size - 1);
                            }
                        }
                    }
                }
                ++n4;
            }
            ++n6;
        }
        n4 = 0;
        n3 = 0;
        while (n3 < this.size) {
            if (this.rects[n3].width == 0) {
                this.rects[n3] = null;
            } else {
                this.rects[n4++] = this.rects[n3];
            }
            ++n3;
        }
        this.size = n4;
    }

    protected void splitRect(Rectangle rectangle, Rectangle rectangle2, Rectangle[] rectangleArray) {
        int n = rectangle.x;
        int n2 = n + rectangle.width - 1;
        int n3 = rectangle.y;
        int n4 = n3 + rectangle.height - 1;
        int n5 = rectangle2.x;
        int n6 = n5 + rectangle2.width - 1;
        int n7 = rectangle2.y;
        int n8 = n7 + rectangle2.height - 1;
        if (n3 < n7 && n4 >= n7) {
            rectangleArray[0] = new Rectangle(n, n3, rectangle.width, n7 - n3);
            n3 = n7;
        } else {
            rectangleArray[0] = null;
        }
        if (n3 <= n8 && n4 > n8) {
            rectangleArray[1] = new Rectangle(n, n8 + 1, rectangle.width, n4 - n8);
            n4 = n8;
        } else {
            rectangleArray[1] = null;
        }
        rectangleArray[2] = n < n5 && n2 >= n5 ? new Rectangle(n, n3, n5 - n, n4 - n3 + 1) : null;
        rectangleArray[3] = n <= n6 && n2 > n6 ? new Rectangle(n6 + 1, n3, n2 - n6, n4 - n3 + 1) : null;
    }

    protected void insertRects(Rectangle[] rectangleArray, int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        this.ensureCapacity(this.size + n3);
        int n4 = this.size - 1;
        while (n4 >= n2) {
            this.rects[n4 + n3] = this.rects[n4];
            --n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            this.rects[n5 + n2] = rectangleArray[n5 + n];
            ++n5;
        }
        this.size += n3;
    }

    public void ensureCapacity(int n) {
        if (n <= this.rects.length) {
            return;
        }
        int n2 = this.rects.length + (this.rects.length >> 1) + 1;
        while (n2 < n) {
            n2 += (n2 >> 1) + 1;
        }
        Rectangle[] rectangleArray = new Rectangle[n2];
        System.arraycopy(this.rects, 0, rectangleArray, 0, this.size);
        this.rects = rectangleArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RLMIterator
    implements ListIterator {
        int idx = 0;
        boolean removeOk = false;
        boolean forward = true;

        RLMIterator() {
        }

        public boolean hasNext() {
            return this.idx < RectListManager.this.size;
        }

        public int nextIndex() {
            return this.idx;
        }

        public Object next() {
            if (this.idx >= RectListManager.this.size) {
                throw new NoSuchElementException("No Next Element");
            }
            this.forward = true;
            this.removeOk = true;
            return RectListManager.this.rects[this.idx++];
        }

        public boolean hasPrevious() {
            return this.idx > 0;
        }

        public int previousIndex() {
            return this.idx - 1;
        }

        public Object previous() {
            if (this.idx <= 0) {
                throw new NoSuchElementException("No Previous Element");
            }
            this.forward = false;
            this.removeOk = true;
            return RectListManager.this.rects[--this.idx];
        }

        public void remove() {
            if (!this.removeOk) {
                throw new IllegalStateException("remove can only be called directly after next/previous");
            }
            if (this.forward) {
                --this.idx;
            }
            if (this.idx != RectListManager.this.size - 1) {
                System.arraycopy(RectListManager.this.rects, this.idx + 1, RectListManager.this.rects, this.idx, RectListManager.this.size - (this.idx + 1));
            }
            --RectListManager.this.size;
            RectListManager.this.rects[RectListManager.this.size] = null;
            this.removeOk = false;
        }

        public void set(Object object) {
            Rectangle rectangle = (Rectangle)object;
            if (!this.removeOk) {
                throw new IllegalStateException("set can only be called directly after next/previous");
            }
            if (this.forward) {
                --this.idx;
            }
            if (this.idx + 1 < RectListManager.this.size && RectListManager.this.rects[this.idx + 1].x < rectangle.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            if (this.idx >= 0 && RectListManager.this.rects[this.idx - 1].x > rectangle.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            RectListManager.this.rects[this.idx] = rectangle;
            this.removeOk = false;
        }

        public void add(Object object) {
            Rectangle rectangle = (Rectangle)object;
            if (this.idx < RectListManager.this.size && RectListManager.this.rects[this.idx].x < rectangle.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            if (this.idx != 0 && RectListManager.this.rects[this.idx - 1].x > rectangle.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            RectListManager.this.ensureCapacity(RectListManager.this.size + 1);
            if (this.idx != RectListManager.this.size) {
                System.arraycopy(RectListManager.this.rects, this.idx, RectListManager.this.rects, this.idx + 1, RectListManager.this.size - this.idx);
            }
            RectListManager.this.rects[this.idx] = rectangle;
            ++this.idx;
            this.removeOk = false;
        }
    }

    private static class RectXComparator
    implements Comparator,
    Serializable {
        RectXComparator() {
        }

        public final int compare(Object object, Object object2) {
            return ((Rectangle)object).x - ((Rectangle)object2).x;
        }
    }
}

