/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;

public class WeakValueHashMap
extends LinkedHashMap {
    private ReferenceQueue reaped = new ReferenceQueue();

    public Object put(Object key, Object value) {
        this.reap();
        ValueRef vr = new ValueRef(value, key, this.reaped);
        return super.put(key, vr);
    }

    public Object get(Object key) {
        this.reap();
        ValueRef vr = (ValueRef)super.get(key);
        Object result = null;
        if (vr != null) {
            result = vr.get();
        }
        return result;
    }

    public Object remove(Object key) {
        this.reap();
        ValueRef vr = (ValueRef)super.get(key);
        if (vr == null) {
            return null;
        }
        vr.clear();
        super.remove(key);
        return null;
    }

    public int size() {
        this.reap();
        return super.size();
    }

    public void reap() {
        ValueRef ref;
        while ((ref = (ValueRef)this.reaped.poll()) != null) {
            super.remove(ref.key);
        }
    }

    private static class ValueRef
    extends WeakReference {
        private final Object key;

        ValueRef(Object val, Object key, ReferenceQueue q) {
            super(val, q);
            this.key = key;
        }
    }
}

