/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendRequest;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class FriendRequestPanel
extends JPanel
implements Disposable {
    private final List<FriendRequest> pendingRequests;
    private EventListener<FriendConnectionEvent> connectionListener;
    private ListenerSupport<FriendConnectionEvent> connectionSupport;
    private JLabel requestLabel;

    @Inject
    public FriendRequestPanel() {
        GuiUtils.assignResources(this);
        this.setLayout(new MigLayout("nogrid, gap 0, insets 2 8 8 8, fill"));
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.pendingRequests = new ArrayList<FriendRequest>();
        HyperlinkButton yes = new HyperlinkButton(new AbstractAction(I18n.tr("Yes")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FriendRequestPanel.this.completeRequest(true);
            }
        });
        HyperlinkButton no = new HyperlinkButton(new AbstractAction(I18n.tr("No")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FriendRequestPanel.this.completeRequest(false);
            }
        });
        this.requestLabel = new JLabel();
        this.add((Component)this.requestLabel, "growx, wrap");
        this.add((Component)new JLabel(I18n.tr("Accept?")), "gapbefore push");
        this.add(yes);
        this.add(new JLabel("/"));
        this.add(no);
    }

    @Inject
    void registerListener(ListenerSupport<FriendConnectionEvent> connectionSupport) {
        this.connectionSupport = connectionSupport;
        this.connectionListener = new EventListener<FriendConnectionEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FriendConnectionEvent event) {
                switch ((FriendConnectionEvent.Type)((Object)event.getType())) {
                    case CONNECT_FAILED: 
                    case DISCONNECTED: {
                        FriendRequestPanel.this.close();
                    }
                }
            }
        };
        connectionSupport.addListener(this.connectionListener);
    }

    public void addRequest(FriendRequest request) {
        this.pendingRequests.add(request);
        this.ensureRequestVisible();
    }

    private void ensureRequestVisible() {
        if (this.pendingRequests.size() > 0) {
            String start = "<html><img src='" + FriendRequestPanel.getURL("/org/limewire/ui/swing/mainframe/resources/icons/friends/friends_icon.png") + "' />&nbsp;";
            String end = "</html>";
            this.requestLabel.setText(start + I18n.tr("{0} wants to be your friend.", this.pendingRequests.get(0).getFriendUsername()) + end);
        } else {
            this.close();
        }
    }

    private static String getURL(String path) {
        URL resource = FriendRequestPanel.class.getResource(path);
        return resource != null ? resource.toExternalForm() : "";
    }

    private void completeRequest(final boolean accept) {
        final FriendRequest request = this.pendingRequests.remove(0);
        BackgroundExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                request.getDecisionHandler().handleDecision(request.getFriendUsername(), accept);
            }
        });
        this.ensureRequestVisible();
    }

    private void close() {
        this.setVisible(false);
    }

    @Override
    public void dispose() {
        this.connectionSupport.removeListener(this.connectionListener);
    }
}

