/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components.decorators;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Paint;
import javax.swing.BorderFactory;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.painter.Painter;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.painter.ButtonBackgroundPainter;
import org.limewire.ui.swing.painter.ButtonForegroundPainter;
import org.limewire.ui.swing.painter.DropDownHeaderButtonBackgroundPainter;
import org.limewire.ui.swing.painter.HeaderButtonBackgroundPainter;
import org.limewire.ui.swing.painter.StatusBarPopupButtonPainter;
import org.limewire.ui.swing.painter.factories.ButtonPainterFactory;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.GuiUtils;

@Singleton
public class ButtonDecorator {
    private final ButtonPainterFactory painterFactory;
    @Resource
    private Font miniTextFont;
    @Resource
    private Color miniTextForeground;
    @Resource
    private Font linkTextFont;
    @Resource
    private Color linkTextForeground;
    @Resource
    private Font lightFullTextFont;
    @Resource
    private Color lightFullTextForeground;
    @Resource
    private Font darkFullTextFont;
    @Resource
    private Color darkFullTextForeground;
    @Resource
    private Font flatTextFont;
    @Resource
    private Color flatTextForeground;
    @Resource
    private Font headerTextFont;
    @Resource
    private Color headerTextForeground;

    @Inject
    ButtonDecorator(ButtonPainterFactory painterFactory) {
        GuiUtils.assignResources(this);
        this.painterFactory = painterFactory;
        this.linkTextFont = FontUtils.deriveUnderline(this.linkTextFont, true);
        this.flatTextFont = FontUtils.deriveUnderline(this.flatTextFont, true);
    }

    public void decorateMiniButton(JXButton button) {
        button.setForegroundPainter(this.painterFactory.createMiniButtonForegroundPainter());
        button.setBackgroundPainter(this.painterFactory.createMiniButtonBackgroundPainter());
        ButtonDecorator.decorateGeneral(button);
        button.setBorder(BorderFactory.createEmptyBorder(2, 6, 3, 6));
        button.setForeground(this.miniTextForeground);
        button.setFont(this.miniTextFont);
    }

    public void decorateLinkButton(JXButton button) {
        button.setForegroundPainter(this.painterFactory.createLinkButtonForegroundPainter());
        button.setBackgroundPainter(this.painterFactory.createLinkButtonBackgroundPainter());
        ButtonDecorator.decorateGeneral(button);
        button.setBorder(BorderFactory.createEmptyBorder(2, 6, 3, 6));
        button.setForeground(this.linkTextForeground);
        button.setFont(this.linkTextFont);
    }

    public void decorateDarkFullButton(JXButton button, BorderPainter.AccentType accent) {
        this.decorateDarkFullButton(button, ButtonBackgroundPainter.DrawMode.FULLY_ROUNDED, accent);
        button.setBorder(BorderFactory.createEmptyBorder(2, 10, 3, 10));
    }

    public void decorateDarkFullButton(JXButton button) {
        this.decorateDarkFullButton(button, ButtonBackgroundPainter.DrawMode.FULLY_ROUNDED, BorderPainter.AccentType.SHADOW);
        button.setBorder(BorderFactory.createEmptyBorder(2, 10, 3, 10));
    }

    public void decorateDarkFullImageButton(JXButton button, BorderPainter.AccentType accent) {
        this.decorateDarkFullButton(button, button.getForegroundPainter(), this.painterFactory.createDarkFullButtonBackgroundPainter(ButtonBackgroundPainter.DrawMode.FULLY_ROUNDED, accent));
        button.setContentAreaFilled(false);
        button.setPaintBorderInsets(true);
    }

    public void decorateDarkFullImageButton(JXButton button, ButtonBackgroundPainter.DrawMode mode) {
        this.decorateDarkFullButton(button, button.getForegroundPainter(), this.painterFactory.createDarkFullButtonBackgroundPainter(mode, BorderPainter.AccentType.SHADOW));
        button.setContentAreaFilled(false);
        button.setPaintBorderInsets(true);
    }

    public void decorateDarkFullButton(JXButton button, ButtonBackgroundPainter.DrawMode mode, BorderPainter.AccentType accent) {
        this.decorateDarkFullButton(button, this.painterFactory.createDarkFullButtonForegroundPainter(), this.painterFactory.createDarkFullButtonBackgroundPainter(mode, accent));
        button.setBorder(BorderFactory.createEmptyBorder(2, 10, 3, 10));
    }

    private void decorateDarkFullButton(JXButton button, Painter<JXButton> foregroundPainter, Painter<JXButton> backgroundPainter) {
        button.setForegroundPainter(foregroundPainter);
        button.setBackgroundPainter(backgroundPainter);
        ButtonDecorator.decorateGeneral(button);
        button.setForeground(this.darkFullTextForeground);
        button.setFont(this.darkFullTextFont);
    }

    public void decorateLightFullButton(JXButton button) {
        button.setForegroundPainter(this.painterFactory.createLightFullButtonForegroundPainter());
        button.setBackgroundPainter(this.painterFactory.createLightFullButtonBackgroundPainter());
        ButtonDecorator.decorateGeneral(button);
        button.setBorder(BorderFactory.createEmptyBorder(2, 10, 3, 10));
        button.setForeground(this.lightFullTextForeground);
        button.setFont(this.lightFullTextFont);
    }

    public void decorateGreenFullButton(JXButton button) {
        button.setForegroundPainter(this.painterFactory.createLightFullButtonForegroundPainter());
        button.setBackgroundPainter(this.painterFactory.createGreenFullButtonBackgroundPainter());
        ButtonDecorator.decorateGeneral(button);
        button.setForeground(this.lightFullTextForeground);
        button.setFont(this.lightFullTextFont);
    }

    public void decorateFlatButton(JXButton button) {
        button.setBackgroundPainter(this.painterFactory.createFlatButtonBackgroundPainter());
        ButtonDecorator.decorateGeneral(button);
        button.setForeground(this.flatTextForeground);
        button.setFont(this.flatTextFont);
        button.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void decorateStatusPopupButton(JXButton button, StatusBarPopupButtonPainter.PopupVisibilityChecker visibilityChecker, Paint background, Paint border, StatusBarPopupButtonPainter.DrawMode mode) {
        button.setBackgroundPainter(new StatusBarPopupButtonPainter(visibilityChecker, background, border, mode));
        button.setForegroundPainter(new ButtonForegroundPainter());
        ButtonDecorator.decorateGeneral(button);
        button.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
    }

    public void decorateChatButton(JXButton button, StatusBarPopupButtonPainter.PopupVisibilityChecker visibilityChecker, Paint background, Paint border) {
        button.setBackgroundPainter(new StatusBarPopupButtonPainter(visibilityChecker, background, border, StatusBarPopupButtonPainter.DrawMode.RIGHT_CONNECTING));
        ButtonDecorator.decorateGeneral(button);
        button.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
    }

    public void decorateBasicHeaderButton(JXButton button) {
        button.setBackgroundPainter(new HeaderButtonBackgroundPainter());
        this.decorateHeaderGeneral(button);
        button.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
    }

    public void decorateDropDownHeaderButton(JXButton button) {
        button.setBackgroundPainter(new DropDownHeaderButtonBackgroundPainter());
        this.decorateHeaderGeneral(button);
        button.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 6));
    }

    private void decorateHeaderGeneral(JXButton button) {
        ButtonDecorator.decorateGeneral(button);
        button.setFont(this.headerTextFont);
        button.setForeground(this.headerTextForeground);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setIconTextGap(0);
        button.setCursor(Cursor.getPredefinedCursor(12));
    }

    private static void decorateGeneral(JXButton button) {
        button.setOpaque(false);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
    }
}

