/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.libtorrent;

import org.limewire.bittorrent.TorrentPieceState;
import org.limewire.bittorrent.TorrentPiecesInfo;
import org.limewire.libtorrent.LibTorrentPiecesInfoContainer;

class LibTorrentPiecesInfo
implements TorrentPiecesInfo {
    private static final char PIECE_DOWNLOADED = 'x';
    private static final char PIECE_PARTIAL = 'p';
    private static final char PIECE_PENDING = '0';
    private static final char PIECE_ACTIVE = 'a';
    private static final char PIECE_UNAVAILABLE = 'U';
    private static final char PIECE_QUEUED = 'q';
    private static final char PIECE_UNAVAILABLE_PARTIAL = 'u';
    private final String stateInfo;
    private final int numPiecesCompleted;

    LibTorrentPiecesInfo(LibTorrentPiecesInfoContainer piecesInfoContainer) {
        this.stateInfo = piecesInfoContainer.getStateInfo();
        this.numPiecesCompleted = piecesInfoContainer.getNumPiecesCompleted();
    }

    @Override
    public int getNumPieces() {
        return this.stateInfo.length();
    }

    @Override
    public int getNumPiecesCompleted() {
        return this.numPiecesCompleted;
    }

    @Override
    public TorrentPieceState getPieceState(int piece) {
        return LibTorrentPiecesInfo.getPieceState(this.stateInfo.charAt(piece));
    }

    private static TorrentPieceState getPieceState(char c) {
        switch (c) {
            case 'x': {
                return TorrentPieceState.DOWNLOADED;
            }
            case 'p': {
                return TorrentPieceState.PARTIAL;
            }
            case '0': 
            case 'q': {
                return TorrentPieceState.AVAILABLE;
            }
            case 'a': {
                return TorrentPieceState.ACTIVE;
            }
            case 'U': 
            case 'u': {
                return TorrentPieceState.UNAVAILABLE;
            }
        }
        throw new IllegalArgumentException("Unknown Piece Descriptor: " + c);
    }
}

