/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.inject;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.LinkedBindingImpl;
import com.google.inject.spi.BindingScopingVisitor;
import java.lang.annotation.Annotation;

public class MoreScopes {
    public static final Scope LAZY_SINGLETON = new Scope(){

        @Override
        public <T> Provider<T> scope(Key<T> key, Provider<T> creator) {
            return Scopes.SINGLETON.scope(key, creator);
        }

        @Override
        public String toString() {
            return "MoreScopes.LAZY_SINGLETON";
        }
    };
    public static final Scope EAGER_SINGLETON = new Scope(){

        @Override
        public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
            return Scopes.SINGLETON.scope(key, unscoped);
        }

        @Override
        public String toString() {
            return "MoreScopes.EAGER_SINGLETON";
        }
    };

    public static Scope getLinkedScope(Binding<?> binding) {
        BindingScopingVisitor<Scope> scoper = new BindingScopingVisitor<Scope>(){

            @Override
            public Scope visitNoScoping() {
                return Scopes.NO_SCOPE;
            }

            @Override
            public Scope visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
                throw new IllegalStateException("no annotations allowed here");
            }

            @Override
            public Scope visitScope(Scope scope) {
                return scope;
            }

            @Override
            public Scope visitEagerSingleton() {
                return EAGER_SINGLETON;
            }
        };
        while (true) {
            LinkedBindingImpl linkedBinding;
            InjectorImpl injector;
            Scope scope;
            if ((scope = binding.acceptScopingVisitor(scoper)) != Scopes.NO_SCOPE) {
                return scope;
            }
            if (!(binding instanceof LinkedBindingImpl) || (injector = (linkedBinding = (LinkedBindingImpl)binding).getInjector()) == null) break;
            binding = injector.getBinding(linkedBinding.getLinkedKey());
        }
        return Scopes.NO_SCOPE;
    }
}

