/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RAF {
    protected File f;
    protected String mode;
    protected RandomAccessFile raf;
    private boolean closed;
    protected boolean deleteOnClose;

    public File getFile() {
        return this.f;
    }

    public synchronized void seekAndWrite(long pos, byte[] b, int off, int len) throws IOException {
        this.raf.seek(pos);
        this.raf.write(b, off, len);
    }

    public synchronized int seekAndRead(long pos, byte[] b, int off, int len) throws IOException {
        this.raf.seek(pos);
        return this.raf.read(b, off, len);
    }

    public synchronized void seekAndReadFully(long pos, byte[] b, int off, int len) throws IOException {
        this.raf.seek(pos);
        this.raf.readFully(b, off, len);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void renameTo(File destFile) throws IOException {
        block11: {
            block10: {
                if (this.closed) {
                    throw new IOException("File closed.");
                }
                this.raf.close();
                try {
                    if (this.f.getCanonicalFile().equals(destFile.getCanonicalFile())) {
                        Object var3_2 = null;
                        break block10;
                    }
                    if (destFile.exists() && !destFile.delete()) {
                        throw new IOException("Unable to delete destination :" + destFile);
                    }
                    if (!this.f.renameTo(destFile)) {
                        try {
                            byte[] b = new byte[8192];
                            FileInputStream is = new FileInputStream(this.f);
                            FileOutputStream os = new FileOutputStream(destFile);
                            while (true) {
                                void var7_9;
                                int c;
                                if ((c = ((InputStream)is).read(b, 0, b.length)) == -1) {
                                    ((InputStream)is).close();
                                    ((OutputStream)os).close();
                                    if (this.f.delete()) break;
                                    throw new IOException("Unable to delete source post-move");
                                }
                                ((OutputStream)os).write(b, 0, (int)var7_9);
                            }
                        }
                        catch (IOException e) {
                            if (!destFile.exists()) throw new IOException("Unable to move " + this.f + " to " + destFile + " : " + e.getMessage());
                            if (destFile.delete()) throw new IOException("Unable to move " + this.f + " to " + destFile + " : " + e.getMessage());
                            throw new IOException("Unable to delete destination after failed move : " + destFile + " : " + e.getMessage());
                        }
                        this.f = destFile;
                        break block11;
                    }
                    this.f = destFile;
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.raf = new RandomAccessFile(this.f, this.mode);
                    throw throwable;
                }
            }
            this.raf = new RandomAccessFile(this.f, this.mode);
            return;
        }
        Object var3_3 = null;
        this.raf = new RandomAccessFile(this.f, this.mode);
    }

    public synchronized String getMode() {
        return this.mode;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void setReadOnly() throws IOException {
        if (this.closed) {
            throw new IOException("File closed.");
        }
        this.mode = "r";
        this.raf.close();
        this.raf = new RandomAccessFile(this.f, this.mode);
    }

    public synchronized void deleteOnClose() {
        if (this.closed) {
            throw new IllegalStateException("File already closed");
        }
        this.deleteOnClose = true;
    }

    public synchronized void setLength(long len) throws IOException {
        this.raf.setLength(len);
    }

    public synchronized long length() throws IOException {
        return this.raf.length();
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.raf.close();
        if (this.deleteOnClose && !this.f.delete()) {
            throw new IOException("Unable to delete file on close");
        }
    }

    protected void finalize() throws IOException {
        if (!this.closed) {
            this.close();
        }
    }

    public String toString() {
        return "RAF[file=" + this.f.getAbsolutePath() + ",mode=" + this.mode + "]";
    }

    public RAF(File f, String mode) throws IOException {
        this.f = f;
        this.mode = mode;
        this.raf = new RandomAccessFile(f, mode);
    }

    protected RAF() {
    }
}

