/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.io;

import com.onionnetworks.io.FilterRAF;
import com.onionnetworks.io.RAF;
import com.onionnetworks.util.Buffer;
import com.onionnetworks.util.Range;
import com.onionnetworks.util.RangeSet;
import com.onionnetworks.util.Tuple;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Iterator;

public class BlockingRAF
extends FilterRAF {
    RangeSet written = new RangeSet();
    IOException e;
    HashMap buffers = new HashMap();

    public synchronized void seekAndWrite(long pos, byte[] b, int off, int len) throws IOException {
        if (this.e != null) {
            throw this.e;
        }
        this.raf.seekAndWrite(pos, b, off, len);
        if (len == 0) {
            return;
        }
        this.fillBlockedBuffers(pos, b, off, len);
        this.written.add(pos, pos + (long)len - 1L);
        this.notifyAll();
    }

    private final synchronized void fillBlockedBuffers(long pos, byte[] b, int off, int len) {
        if (this.buffers.isEmpty()) {
            return;
        }
        Range r = new Range(pos, pos + (long)len - 1L);
        Iterator it = this.buffers.keySet().iterator();
        while (it.hasNext()) {
            long max;
            Object key = it.next();
            Tuple t = (Tuple)this.buffers.get(key);
            Range r2 = (Range)t.getLeft();
            Buffer buf = (Buffer)t.getRight();
            long min = Math.max(r.getMin(), r2.getMin());
            if (min > (max = Math.min(r.getMax(), r2.getMax()))) continue;
            System.arraycopy(b, (int)((long)off + (min - r.getMin())), buf.b, (int)((long)buf.off + (min - r2.getMin())), (int)(max - min + 1L));
        }
    }

    public synchronized void seekAndReadFully(long pos, byte[] b, int off, int len) throws IOException {
        throw new IOException("unsupported operation");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int seekAndRead(long pos, byte[] b, int off, int len) throws IOException {
        boolean directWrite = false;
        Range r = null;
        Object key = new Object();
        while (true) {
            Object var13_11;
            if (this.isClosed() || this.e != null || this.getMode().equals("r") || len == 0) {
                if (this.e == null) break;
                throw this.e;
            }
            if (r == null) {
                r = new Range(pos, pos + (long)len - 1L);
            }
            RangeSet rs = new RangeSet();
            rs.add(r);
            RangeSet avail = this.written.intersect(rs);
            Range first = null;
            if (!avail.isEmpty()) {
                first = (Range)avail.iterator().next();
            }
            if (this.written.contains(pos)) {
                if (directWrite) {
                    return (int)first.size();
                }
                return this.raf.seekAndRead(pos, b, off, (int)first.size());
            }
            directWrite = true;
            if (first != null) {
                r = new Range(pos, first.getMin() - 1L);
            }
            this.buffers.put(key, new Tuple(r, new Buffer(b, off, len)));
            try {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
                var13_11 = null;
                this.buffers.remove(key);
            }
            catch (Throwable throwable) {
                var13_11 = null;
                this.buffers.remove(key);
                throw throwable;
            }
        }
        if (this.getMode().equals("r")) {
            return this.raf.seekAndRead(pos, b, off, len);
        }
        if (this.isClosed()) {
            throw new IOException("RAF closed");
        }
        if (len == 0) {
            return 0;
        }
        throw new IllegalStateException("Method should have already returned.");
    }

    public synchronized void setReadOnly() throws IOException {
        this.raf.setReadOnly();
        this.notifyAll();
    }

    public synchronized void setException(IOException e) {
        this.e = e;
        this.notifyAll();
    }

    public synchronized void close() throws IOException {
        this.raf.close();
        this.notifyAll();
    }

    public BlockingRAF(RAF raf) {
        super(raf);
    }
}

