/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.RareFileStrategy;
import org.limewire.core.settings.DHTSettings;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.util.RPNParser;

@Singleton
public class RareFileStrategyImpl
implements RareFileStrategy {
    private volatile RPNParser parser = new RPNParser(DHTSettings.RARE_FILE_DEFINITION.get());

    @Inject
    RareFileStrategyImpl() {
        DHTSettings.RARE_FILE_DEFINITION.addSettingListener(new SettingListener(){

            @Override
            public void settingChanged(SettingEvent evt) {
                RareFileStrategyImpl.this.parser = new RPNParser(DHTSettings.RARE_FILE_DEFINITION.get());
            }
        });
    }

    @Override
    public boolean isRareFile(FileDesc fd) {
        try {
            return this.parser.evaluate(fd);
        }
        catch (IllegalArgumentException badSimpp) {
            return false;
        }
    }
}

