/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.AbstractSourceRanker;
import com.limegroup.gnutella.downloader.RemoteFileDescContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.Visitor;

public class LegacyRanker
extends AbstractSourceRanker {
    private static final Log LOG = LogFactory.getLog(LegacyRanker.class);
    private final Set<RemoteFileDescContext> rfds = new HashSet<RemoteFileDescContext>();

    @Override
    public synchronized boolean addToPool(RemoteFileDescContext host) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding host " + host + " to be ranked", new Exception());
        }
        return this.rfds.add(host);
    }

    @Override
    public synchronized RemoteFileDescContext getBest() {
        if (!this.hasMore()) {
            return null;
        }
        RemoteFileDescContext ret = LegacyRanker.getBest(this.rfds.iterator(), this.getRfdVisitor());
        if (ret != null) {
            boolean removed = this.rfds.remove(ret);
            assert (removed) : "unable to remove RFD.";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("the best we came with is " + ret);
        }
        return ret;
    }

    static RemoteFileDescContext getBest(Iterator<RemoteFileDescContext> iter, final Visitor<RemoteFileDescContext> rfdVisitor) {
        if (rfdVisitor != null) {
            iter = Iterators.filter(iter, new Predicate<RemoteFileDescContext>(){

                @Override
                public boolean apply(RemoteFileDescContext input) {
                    return rfdVisitor.visit(input);
                }
            });
        }
        if (!iter.hasNext()) {
            return null;
        }
        RemoteFileDescContext currentRfdContext = iter.next();
        long now = System.currentTimeMillis();
        while (iter.hasNext()) {
            RemoteFileDesc currentRfd = currentRfdContext.getRemoteFileDesc();
            RemoteFileDescContext potentialRfdContext = iter.next();
            RemoteFileDesc potentialRfd = potentialRfdContext.getRemoteFileDesc();
            if (potentialRfdContext.isBusy(now)) continue;
            if (currentRfdContext.isBusy(now)) {
                currentRfdContext = potentialRfdContext;
                continue;
            }
            if (potentialRfd.getSHA1Urn() != null && currentRfd.getSHA1Urn() == null) {
                currentRfdContext = potentialRfdContext;
                continue;
            }
            if (potentialRfd.getSHA1Urn() == null != (currentRfd.getSHA1Urn() == null)) continue;
            if (potentialRfd.getQuality() > currentRfd.getQuality()) {
                currentRfdContext = potentialRfdContext;
                continue;
            }
            if (potentialRfd.getQuality() != currentRfd.getQuality() || potentialRfd.getSpeed() <= currentRfd.getSpeed()) continue;
            currentRfdContext = potentialRfdContext;
        }
        return currentRfdContext;
    }

    @Override
    public boolean hasMore() {
        return !this.rfds.isEmpty();
    }

    @Override
    public Collection<RemoteFileDescContext> getShareableHosts() {
        return this.rfds;
    }

    @Override
    protected boolean visitSources(Visitor<RemoteFileDescContext> contextVisitor) {
        for (RemoteFileDescContext context : this.rfds) {
            if (contextVisitor.visit(context)) continue;
            return false;
        }
        return true;
    }
}

