/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckSums {
    private static final String CHECK_SUMS_FILE = "checksums.properties";
    private static final String DEPRECATED = "DEPRECATED";
    private final Context context;
    private final Properties props = new Properties();
    private final MessageDigest md;

    public static CheckSums forContext(Context context) throws IOException, NoSuchAlgorithmException {
        return new CheckSums(context);
    }

    private CheckSums(Context context) throws IOException, NoSuchAlgorithmException {
        assert (context != null);
        this.context = context;
        this.md = MessageDigest.getInstance("MD5");
        this.load();
    }

    public boolean checkAndSet(URL uRL, Iterable<? extends TypeElement> iterable, Elements elements) {
        String string;
        String string2 = uRL.toExternalForm();
        String string3 = (String)this.props.setProperty(string2, string = this.computeCheckSum(iterable, elements));
        return string3 == null || string3.equals(string);
    }

    public void remove(URL uRL) {
        String string = uRL.toExternalForm();
        this.props.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException {
        FileObject fileObject = this.context.getIndexFolder();
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)CHECK_SUMS_FILE);
        assert (fileObject2 != null);
        OutputStream outputStream = fileObject2.getOutputStream();
        try {
            this.props.store(outputStream, "");
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        FileObject fileObject = this.context.getIndexFolder();
        FileObject fileObject2 = fileObject.getFileObject(CHECK_SUMS_FILE);
        if (fileObject2 != null) {
            InputStream inputStream = fileObject2.getInputStream();
            try {
                this.props.load(inputStream);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            {
            }
        }
    }

    private String computeCheckSum(Iterable<? extends TypeElement> iterable, Elements elements) {
        LinkedList<TypeElement> linkedList = new LinkedList<TypeElement>();
        for (TypeElement object2 : iterable) {
            linkedList.offer(object2);
        }
        ArrayList arrayList = new ArrayList();
        while (!linkedList.isEmpty()) {
            TypeElement typeElement = (TypeElement)linkedList.poll();
            if (typeElement == null) continue;
            arrayList.add(ClassFileUtil.encodeClassName(typeElement) + this.getExtendedModifiers(elements, typeElement));
            for (Element element : typeElement.getEnclosedElements()) {
                switch (element.getKind()) {
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        linkedList.offer((TypeElement)element);
                        break;
                    }
                    case CONSTRUCTOR: 
                    case METHOD: {
                        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) break;
                        arrayList.add(Arrays.toString(ClassFileUtil.createExecutableDescriptor((ExecutableElement)element)) + this.getExtendedModifiers(elements, element));
                        break;
                    }
                    case FIELD: 
                    case ENUM_CONSTANT: {
                        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) break;
                        arrayList.add(Arrays.toString(ClassFileUtil.createFieldDescriptor((VariableElement)element)) + this.getExtendedModifiers(elements, element));
                    }
                }
            }
        }
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<? extends Element> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuilder.append(string);
        }
        iterator = (Iterator<? extends Element>)this.md.digest(stringBuilder.toString().getBytes());
        return new String((byte[])iterator);
    }

    private String getExtendedModifiers(Elements elements, Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = element.getModifiers().iterator();
        while (object.hasNext()) {
            Modifier modifier = object.next();
            stringBuilder.append(modifier.name());
        }
        if (elements.isDeprecated(element)) {
            stringBuilder.append(DEPRECATED);
        }
        if (element.getKind() == ElementKind.FIELD && (object = ((VariableElement)element).getConstantValue()) != null) {
            stringBuilder.append(object.getClass().getName());
            stringBuilder.append(String.valueOf(object));
        }
        return stringBuilder.toString();
    }
}

