/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.ListenerVisualPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ListenerPanel
implements WizardDescriptor.Panel {
    private ListenerVisualPanel component;
    private transient TemplateWizard wizard;
    private static final String SERVLET_CONTEXT_LISTENER = "javax.servlet.ServletContextListener";
    private static final String SERVLET_CONTEXT_ATTRIBUTE_LISTENER = "javax.servlet.ServletContextAttributeListener";
    private static final String HTTP_SESSION_LISTENER = "javax.servlet.http.HttpSessionListener";
    private static final String HTTP_SESSION_ATTRIBUTE_LISTENER = "javax.servlet.http.HttpSessionAttributeListener";
    private static final String SERVLET_REQUEST_LISTENER = "javax.servlet.ServletRequestListener";
    private static final String SERVLET_REQUEST_ATTRIBUTE_LISTENER = "javax.servlet.ServletRequestAttributeListener";
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public ListenerPanel(TemplateWizard templateWizard) {
        this.wizard = templateWizard;
    }

    public Component getComponent() {
        if (this.component == null) {
            Project project = Templates.getProject((WizardDescriptor)this.wizard);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            WebModule webModule = null;
            Profile profile = Profile.J2EE_14;
            if (sourceGroupArray != null && sourceGroupArray.length > 0) {
                webModule = WebModule.getWebModule((FileObject)sourceGroupArray[0].getRootFolder());
            }
            if (webModule != null) {
                profile = webModule.getJ2eeProfile();
            }
            this.component = new ListenerVisualPanel(this, profile);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        if (!this.isListenerSelected()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ListenerPanel.class, (String)"MSG_noListenerSelected"));
            return false;
        }
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        ClassPath classPath = null;
        String string = null;
        if (sourceGroupArray != null && sourceGroupArray.length != 0) {
            classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
            if (this.isContextListener()) {
                string = SERVLET_CONTEXT_LISTENER;
            } else if (this.isContextAttrListener()) {
                string = SERVLET_CONTEXT_ATTRIBUTE_LISTENER;
            } else if (this.isSessionListener()) {
                string = HTTP_SESSION_LISTENER;
            } else if (this.isSessionAttrListener()) {
                string = HTTP_SESSION_ATTRIBUTE_LISTENER;
            } else if (this.isRequestListener()) {
                string = SERVLET_REQUEST_LISTENER;
            } else if (this.isRequestAttrListener()) {
                string = SERVLET_REQUEST_ATTRIBUTE_LISTENER;
            }
        }
        if (classPath != null && string != null && classPath.findResource(string.replace('.', '/') + ".class") == null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ListenerPanel.class, (String)"MSG_noResourceInClassPath", (Object)string));
            return false;
        }
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    public void readSettings(Object object) {
    }

    public void storeSettings(Object object) {
    }

    boolean createElementInDD() {
        return this.component.createElementInDD();
    }

    boolean isContextListener() {
        return this.component.isContextListener();
    }

    boolean isContextAttrListener() {
        return this.component.isContextAttrListener();
    }

    boolean isSessionListener() {
        return this.component.isSessionListener();
    }

    boolean isSessionAttrListener() {
        return this.component.isSessionAttrListener();
    }

    boolean isRequestListener() {
        return this.component.isRequestListener();
    }

    boolean isRequestAttrListener() {
        return this.component.isRequestAttrListener();
    }

    boolean isListenerSelected() {
        return this.isContextListener() || this.isContextAttrListener() || this.isSessionListener() || this.isSessionAttrListener() || this.isRequestListener() || this.isRequestAttrListener();
    }
}

