/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLBaseDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.olddeploy.WLOldDeploymentManager;
import org.openide.util.NbBundle;

public class WLDeploymentFactory
implements DeploymentFactory {
    public static final String URI_PREFIX = "deployer:WebLogic:http://";
    private static final Logger LOGGER = Logger.getLogger(WLDeploymentFactory.class.getName());
    private static boolean NEW_DEPLOYMENT = Boolean.getBoolean("org.netbeans.modules.j2ee.weblogic.WLDeploymentFactory.newDeployment");
    private static WLDeploymentFactory instance;
    private static final WeakHashMap<InstanceProperties, WLBaseDeploymentManager> managerCache;

    public static synchronized DeploymentFactory getInstance() {
        if (instance == null) {
            instance = new WLDeploymentFactory();
        }
        return instance;
    }

    public boolean handlesURI(String string) {
        return string != null && string.startsWith(URI_PREFIX);
    }

    public DeploymentManager getDeploymentManager(String string, String string2, String string3) throws DeploymentManagerCreationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "getDeploymentManager, uri:" + string + " username:" + string2 + " password:" + string3);
        }
        String[] stringArray = string.split(":");
        String string4 = stringArray[3].substring(2);
        String string5 = stringArray[4] != null ? stringArray[4].trim() : stringArray[4];
        WLOldDeploymentManager wLOldDeploymentManager = NEW_DEPLOYMENT ? null : new WLOldDeploymentManager(this, string, string2, string3, string4, string5);
        this.updateManagerCache(wLOldDeploymentManager, string);
        return wLOldDeploymentManager;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String string) throws DeploymentManagerCreationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "getDisconnectedDeploymentManager, uri:" + string);
        }
        String[] stringArray = string.split(":");
        String string2 = stringArray[3].substring(2);
        String string3 = stringArray[4] != null ? stringArray[4].trim() : stringArray[4];
        WLOldDeploymentManager wLOldDeploymentManager = NEW_DEPLOYMENT ? null : new WLOldDeploymentManager(this, string, string2, string3);
        this.updateManagerCache(wLOldDeploymentManager, string);
        return wLOldDeploymentManager;
    }

    private void updateManagerCache(WLBaseDeploymentManager wLBaseDeploymentManager, String string) {
        InstanceProperties instanceProperties = InstanceProperties.getInstanceProperties((String)string);
        if (managerCache.get(instanceProperties) != null) {
            wLBaseDeploymentManager.setServerProcess(managerCache.get(instanceProperties).getServerProcess());
            wLBaseDeploymentManager.setOutputManager(managerCache.get(instanceProperties).getOutputManager());
        }
        managerCache.put(instanceProperties, wLBaseDeploymentManager);
    }

    public String getProductVersion() {
        return NbBundle.getMessage(WLDeploymentFactory.class, (String)"TXT_productVersion");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(WLDeploymentFactory.class, (String)"TXT_displayName");
    }

    static {
        managerCache = new WeakHashMap();
    }
}

