/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JToolTip;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionUtils;
import org.netbeans.modules.cnd.completion.cplusplus.NbCsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CompletionSupport;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.modelutil.CsmPaintComponent;
import org.netbeans.modules.cnd.modelutil.MethodParamsTipPaintComponent;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.NbBundle;

public class CsmCompletionProvider
implements CompletionProvider {
    private static final boolean TRACE = false;
    private static final CompletionItem lastItem = new LastResultItem();

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        CompletionSupport completionSupport = CompletionSupport.get(jTextComponent);
        if (completionSupport == null) {
            return 0;
        }
        int n = jTextComponent.getCaret().getDot();
        if (CsmCompletionQuery.checkCondition(jTextComponent.getDocument(), n, false)) {
            try {
                if (CompletionSupport.needShowCompletionOnText(jTextComponent, string)) {
                    return 1;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return 0;
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        CompletionSupport completionSupport = CompletionSupport.get(jTextComponent);
        if (completionSupport == null) {
            return null;
        }
        int n2 = jTextComponent.getCaret().getDot();
        CsmResultItem.setEnableInstantSubstitution(false);
        if (CsmCompletionQuery.checkCondition(jTextComponent.getDocument(), n2, false)) {
            if ((n & 1) == 1) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new Query(n2, n), jTextComponent);
            }
            if (n == 2) {
                return null;
            }
            if (n == 4) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new ToolTipQuery(), jTextComponent);
            }
        }
        return null;
    }

    public static final CsmCompletionQuery getCompletionQuery() {
        return new NbCsmCompletionQuery(null, CsmCompletionQuery.QueryScope.GLOBAL_QUERY, null);
    }

    public static final CsmCompletionQuery getCompletionQuery(CsmFile csmFile, CsmCompletionQuery.QueryScope queryScope, FileReferencesContext fileReferencesContext) {
        return new NbCsmCompletionQuery(csmFile, queryScope, fileReferencesContext);
    }

    private static final class LastResultItem
    extends CsmResultItem {
        private final String str = "" + Query.access$100() + " " + NbBundle.getBundle(CsmCompletionProvider.class).getString("last-item-text");
        private static final CsmPaintComponent.StringPaintComponent stringComponent = new CsmPaintComponent.StringPaintComponent();

        public LastResultItem() {
            super(null, Integer.MAX_VALUE);
        }

        public Component getPaintComponent(boolean bl) {
            stringComponent.setString(this.str);
            return stringComponent;
        }

        public void defaultAction(JTextComponent jTextComponent) {
        }

        public String getItemText() {
            return this.str;
        }
    }

    static class ToolTipQuery
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private int queryCaretOffset;
        private int queryAnchorOffset;
        private JToolTip queryToolTip;
        private Position queryMethodParamsStartPos = null;
        private boolean otherMethodContext;

        ToolTipQuery() {
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            Position position = this.queryMethodParamsStartPos;
            this.queryMethodParamsStartPos = null;
            NbCsmCompletionQuery nbCsmCompletionQuery = (NbCsmCompletionQuery)CsmCompletionProvider.getCompletionQuery();
            BaseDocument baseDocument = (BaseDocument)document;
            CsmCompletionQuery.CsmCompletionResult csmCompletionResult = nbCsmCompletionQuery.query(this.component, n, true, false, true);
            if (csmCompletionResult != null) {
                this.queryCaretOffset = n;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n2 = -1;
                boolean bl = false;
                for (CompletionItem completionItem : csmCompletionResult.getItems()) {
                    Object object;
                    if (!(completionItem instanceof CsmResultItem.ConstructorResultItem)) continue;
                    CsmResultItem.ConstructorResultItem constructorResultItem = (CsmResultItem.ConstructorResultItem)completionItem;
                    if (!bl) {
                        object = constructorResultItem.getExpression();
                        int n3 = ((CsmCompletionExpression)object).getTokenCount() - 1;
                        if (n3 >= 0) {
                            if (((CsmCompletionExpression)object).getExpID() == 11 && ((CsmCompletionExpression)object).getTokenID(n3) == CppTokenId.RPAREN) {
                                if (((CsmCompletionExpression)object).getTokenOffset(n3) + ((CsmCompletionExpression)object).getTokenLength(n3) <= n) {
                                    completionResultSet.finish();
                                    return;
                                }
                            } else if (((CsmCompletionExpression)object).getExpID() == 1 && ((CsmCompletionExpression)object).getTokenOffset(0) + ((CsmCompletionExpression)object).getTokenLength(0) >= n) {
                                completionResultSet.finish();
                                return;
                            }
                            try {
                                this.queryMethodParamsStartPos = baseDocument.createPosition(((CsmCompletionExpression)object).getTokenOffset(0));
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        bl = true;
                    }
                    if ((object = constructorResultItem.createParamsList()).size() > 0) {
                        n2 = constructorResultItem.getCurrentParamIndex();
                    } else {
                        object.add(NbBundle.getMessage(CsmCompletionProvider.class, (String)"CC-no-parameters"));
                    }
                    arrayList.add(object);
                }
                this.queryAnchorOffset = csmCompletionResult.getSubstituteOffset();
                completionResultSet.setAnchorOffset(this.queryAnchorOffset);
                this.queryToolTip = new MethodParamsTipPaintComponent(arrayList, n2);
                completionResultSet.setToolTip(this.queryToolTip);
            }
            completionResultSet.finish();
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            String string = null;
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            try {
                string = n - this.queryCaretOffset > 0 ? document.getText(this.queryCaretOffset, n - this.queryCaretOffset) : (n - this.queryCaretOffset < 0 ? document.getText(n, this.queryCaretOffset - n) : "");
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (string == null) {
                return false;
            }
            boolean bl = true;
            int n2 = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case ',': {
                        bl = false;
                        break;
                    }
                    case '(': {
                        ++n2;
                        bl = false;
                        break;
                    }
                    case ')': {
                        --n2;
                        bl = false;
                    }
                }
                if (n2 >= 0) continue;
                this.otherMethodContext = true;
            }
            if (this.otherMethodContext && n2 < 0) {
                this.otherMethodContext = false;
            }
            if (this.queryMethodParamsStartPos == null || n <= this.queryMethodParamsStartPos.getOffset()) {
                bl = false;
            }
            return this.otherMethodContext || bl;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            if (!this.otherMethodContext) {
                completionResultSet.setAnchorOffset(this.queryAnchorOffset);
                completionResultSet.setToolTip(this.queryToolTip);
            }
            completionResultSet.finish();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Query
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private CsmCompletionQuery.CsmCompletionResult queryResult;
        private int creationCaretOffset;
        private int queryAnchorOffset;
        private String filterPrefix;
        private boolean caseSensitive = false;
        private CsmCompletionQuery.QueryScope queryScope;
        private static final int MAX_ITEMS_TO_DISPLAY;

        Query(int n, int n2) {
            this.creationCaretOffset = n;
            this.queryAnchorOffset = -1;
            this.queryScope = (n2 & 9) != 9 ? CsmCompletionQuery.QueryScope.SMART_QUERY : CsmCompletionQuery.QueryScope.GLOBAL_QUERY;
        }

        private String getTestState() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" creationCaretOffset = " + this.creationCaretOffset);
            stringBuilder.append(" queryAnchorOffset = " + this.queryAnchorOffset);
            stringBuilder.append(" queryScope = " + (Object)((Object)this.queryScope));
            stringBuilder.append(" filterPrefix = " + this.filterPrefix);
            if (this.queryResult == null) {
                stringBuilder.append(" no queryResult");
            } else if (this.queryResult.isSimpleVariableExpression()) {
                stringBuilder.append(" queryResult is simple");
            } else {
                stringBuilder.append(" queryResult is not simple");
            }
            return stringBuilder.toString();
        }

        protected void preQueryUpdate(JTextComponent jTextComponent) {
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            String string = CsmCompletionUtils.getMimeType(jTextComponent);
            boolean bl = this.caseSensitive = string != null ? CsmCompletionUtils.isCaseSensitive(string) : false;
            if (this.creationCaretOffset > 0 && n >= this.creationCaretOffset) {
                try {
                    if (this.isCppIdentifierPart(document.getText(this.creationCaretOffset, n - this.creationCaretOffset))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            Completion.get().hideCompletion();
        }

        private void addItems(CompletionResultSet completionResultSet, Collection<CompletionItem> collection) {
            boolean bl = false;
            if (collection.size() > MAX_ITEMS_TO_DISPLAY && this.queryResult.isSimpleVariableExpression()) {
                bl = true;
            }
            completionResultSet.setHasAdditionalItems(this.queryScope == CsmCompletionQuery.QueryScope.SMART_QUERY);
            if (!bl) {
                completionResultSet.estimateItems(collection.size(), -1);
                completionResultSet.addAllItems(collection);
            } else {
                completionResultSet.estimateItems(MAX_ITEMS_TO_DISPLAY + 1, -1);
                int n = 0;
                for (CompletionItem completionItem : collection) {
                    completionResultSet.addItem(completionItem);
                    if (++n <= MAX_ITEMS_TO_DISPLAY) continue;
                    break;
                }
                completionResultSet.addItem(lastItem);
            }
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            boolean bl;
            boolean bl2 = bl = n <= this.queryAnchorOffset && this.filterPrefix == null;
            if (!bl) {
                this.creationCaretOffset = n;
                NbCsmCompletionQuery nbCsmCompletionQuery = (NbCsmCompletionQuery)CsmCompletionProvider.getCompletionQuery(null, this.queryScope, null);
                CsmCompletionQuery.CsmCompletionResult csmCompletionResult = nbCsmCompletionQuery.query(this.component, n, true);
                if (csmCompletionResult == null || csmCompletionResult.getItems().isEmpty() && this.queryScope == CsmCompletionQuery.QueryScope.SMART_QUERY) {
                    this.queryScope = CsmCompletionQuery.QueryScope.GLOBAL_QUERY;
                    if (csmCompletionResult == null || csmCompletionResult.isSimpleVariableExpression()) {
                        nbCsmCompletionQuery = (NbCsmCompletionQuery)CsmCompletionProvider.getCompletionQuery(null, this.queryScope, null);
                        csmCompletionResult = nbCsmCompletionQuery.query(this.component, n, true);
                    }
                }
                if (csmCompletionResult != null) {
                    if (this.queryScope == CsmCompletionQuery.QueryScope.SMART_QUERY && !csmCompletionResult.isSimpleVariableExpression()) {
                        this.queryScope = CsmCompletionQuery.QueryScope.GLOBAL_QUERY;
                    }
                    this.queryAnchorOffset = csmCompletionResult.getSubstituteOffset();
                    List<CompletionItem> list = csmCompletionResult.getItems();
                    completionResultSet.setAnchorOffset(this.queryAnchorOffset);
                    this.queryResult = csmCompletionResult;
                    this.addItems(completionResultSet, list);
                }
            } else {
                Completion.get().hideCompletion();
            }
            completionResultSet.finish();
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            this.filterPrefix = null;
            if (this.queryAnchorOffset > -1 && n >= this.creationCaretOffset) {
                try {
                    this.filterPrefix = document.getText(this.queryAnchorOffset, n - this.queryAnchorOffset);
                    if (this.queryResult == null || !this.isCppIdentifierPart(this.filterPrefix)) {
                        this.filterPrefix = null;
                    } else {
                        Collection<CompletionItem> collection = this.getFilteredData(this.queryResult.getItems(), this.filterPrefix);
                        if (collection.isEmpty()) {
                            this.filterPrefix = null;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            if (this.filterPrefix != null && this.queryResult != null) {
                completionResultSet.setAnchorOffset(this.queryAnchorOffset);
                Collection<CompletionItem> collection = this.getFilteredData(this.queryResult.getItems(), this.filterPrefix);
                this.addItems(completionResultSet, collection);
            }
            completionResultSet.finish();
        }

        private boolean isCppIdentifierPart(String string) {
            for (int i = 0; i < string.length(); ++i) {
                if (CndLexerUtilities.isCppIdentifierPart((char)string.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection<CompletionItem> getFilteredData(Collection<CompletionItem> collection, String string) {
            ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(1024);
            for (CompletionItem completionItem : collection) {
                if (!this.matchPrefix(((Object)completionItem.getInsertPrefix()).toString(), string, this.caseSensitive)) continue;
                arrayList.add(completionItem);
            }
            return arrayList;
        }

        private boolean matchPrefix(String string, String string2, boolean bl) {
            return bl ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
        }

        private String getFilteredTitle(String string, String string2) {
            String string3;
            int n = string.lastIndexOf(46);
            String string4 = string3 = n == -1 ? string2 : string.substring(0, n + 1) + string2;
            if (string.endsWith("*")) {
                string3 = string3 + "*";
            }
            return string3;
        }

        static /* synthetic */ int access$100() {
            return MAX_ITEMS_TO_DISPLAY;
        }

        static {
            int n = 256;
            if (System.getProperty("cnd.completion.items") != null) {
                try {
                    n = Integer.parseInt(System.getProperty("cnd.completion.items"));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 256;
                }
            }
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
            MAX_ITEMS_TO_DISPLAY = n;
        }
    }
}

