/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.dialog.RenameSceneDialog;
import org.netbeans.modules.vmd.game.editor.scene.SceneEditor;
import org.netbeans.modules.vmd.game.editor.scene.SceneLayerNavigator;
import org.netbeans.modules.vmd.game.editor.scene.ScenePreviewPanel;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.Identifiable;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Previewable;
import org.netbeans.modules.vmd.game.model.SceneListener;
import org.netbeans.modules.vmd.game.model.SceneSelectionListener;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.nbdialog.SpriteDialog;
import org.netbeans.modules.vmd.game.nbdialog.TiledLayerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scene
implements GlobalRepositoryListener,
PropertyChangeListener,
Previewable,
Editable,
Identifiable {
    private long id = -1L;
    public static final boolean DEBUG = false;
    public static final String PROPERTY_LAYERS_BOUNDS = "prop.layers.bounds";
    EventListenerList listenerList = new EventListenerList();
    PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ArrayList<Layer> layers = new ArrayList();
    private HashMap<Layer, LayerInfo> layerInfos = new HashMap();
    private String name;
    private SceneLayerNavigator navigator;
    private ScenePreviewPanel preview;
    private Rectangle allLayersBounds = new Rectangle();
    private SceneEditor editor;
    private GlobalRepository gameDesign;

    Scene(GlobalRepository globalRepository, String string) {
        assert (globalRepository != null);
        this.gameDesign = globalRepository;
        this.editor = null;
        this.name = string;
        this.gameDesign.addGlobalRepositoryListener(this);
    }

    Scene(GlobalRepository globalRepository, String string, Scene scene) {
        this(globalRepository, string);
        for (Layer layer : scene.layers) {
            this.insert(layer, scene.indexOf(layer));
            this.setLayerPosition(layer, scene.getLayerPosition(layer), false);
            this.setLayerLocked(layer, scene.isLayerLocked(layer));
            this.setLayerVisible(layer, scene.isLayerVisible(layer));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            return;
        }
        if (this.getName().equals(string)) {
            return;
        }
        if (!this.gameDesign.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("Scene cannot be renamed because component name '" + string + "' already exists.");
        }
        String string2 = this.name;
        this.name = string;
        this.propertyChangeSupport.firePropertyChange("editable.prop.name", string2, this.name);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addSceneListener(SceneListener sceneListener) {
        this.listenerList.add(SceneListener.class, sceneListener);
    }

    public synchronized void removeSceneListener(SceneListener sceneListener) {
        this.listenerList.remove(SceneListener.class, sceneListener);
    }

    public synchronized void addSceneListener(SceneSelectionListener sceneSelectionListener) {
        this.listenerList.add(SceneSelectionListener.class, sceneSelectionListener);
    }

    public synchronized void removeSceneListener(SceneSelectionListener sceneSelectionListener) {
        this.listenerList.remove(SceneSelectionListener.class, sceneSelectionListener);
    }

    public Rectangle getAllLayersBounds() {
        return this.allLayersBounds;
    }

    private void updateLayersBounds() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (Layer object : this.getLayers()) {
            Point point = this.getLayerPosition(object);
            n = n < point.x ? n : point.x;
            n3 = n3 < point.y ? n3 : point.y;
            int n5 = point.x + object.getWidth();
            n2 = n2 > n5 ? n2 : n5;
            int n6 = point.y + object.getHeight();
            n4 = n4 > n6 ? n4 : n6;
        }
        Rectangle rectangle = new Rectangle(n, n3, n2 - n, n4 - n3);
        if (!this.allLayersBounds.equals(rectangle)) {
            Rectangle rectangle2 = this.allLayersBounds;
            this.allLayersBounds = rectangle;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_LAYERS_BOUNDS, rectangle2, rectangle);
        }
    }

    public TiledLayer createTiledLayer(String string, ImageResource imageResource, int n, int n2, int n3, int n4) {
        TiledLayer tiledLayer = this.gameDesign.createTiledLayer(string, imageResource, n, n2, n3, n4);
        this.append(tiledLayer);
        return tiledLayer;
    }

    public Sprite createSprite(String string, ImageResource imageResource, int n, int n2, int n3) {
        Sprite sprite = this.gameDesign.createSprite(string, imageResource, n, n2, n3);
        this.append(sprite);
        return sprite;
    }

    private LayerInfo getLayerInfo(Layer layer) {
        return this.layerInfos.get(layer);
    }

    public boolean contains(Layer layer) {
        return this.indexOf(layer) >= 0;
    }

    public void append(Layer layer) {
        if (this.layers.contains(layer)) {
            this.remove(layer);
        }
        this.layers.add(layer);
        LayerInfo layerInfo = new LayerInfo();
        this.layerInfos.put(layer, layerInfo);
        int n = this.layers.indexOf(layer);
        layer.addPropertyChangeListener(this);
        this.updateLayersBounds();
        this.fireLayerAdded(layer, n);
    }

    public void insert(Layer layer, int n) {
        if (this.layers.contains(layer)) {
            this.move(layer, n);
            return;
        }
        this.layers.add(n, layer);
        LayerInfo layerInfo = new LayerInfo();
        this.layerInfos.put(layer, layerInfo);
        layer.addPropertyChangeListener(this);
        this.updateLayersBounds();
        this.fireLayerAdded(layer, n);
    }

    public void remove(Layer layer) {
        int n = this.layers.indexOf(layer);
        if (this.layers.remove(layer)) {
            layer.removePropertyChangeListener(this);
            this.updateLayersBounds();
            this.fireLayerRemoved(layer, n);
        }
    }

    public void move(Layer layer, int n) {
        int n2 = this.layers.indexOf(layer);
        if (n2 == -1) {
            return;
        }
        if (n2 == n) {
            return;
        }
        this.layers.remove(layer);
        this.layers.ensureCapacity(n + 1);
        this.layers.add(n, layer);
        this.updateLayersBounds();
        this.fireLayerMoved(layer, n2, n);
    }

    private void fireLayerMoved(Layer layer, int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SceneListener.class) continue;
            ((SceneListener)objectArray[i + 1]).layerMoved(this, layer, n, n2);
        }
    }

    private void fireLayerAdded(Layer layer, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SceneListener.class) continue;
            ((SceneListener)objectArray[i + 1]).layerAdded(this, layer, n);
        }
    }

    private void fireLayerRemoved(Layer layer, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SceneListener.class) continue;
            ((SceneListener)objectArray[i + 1]).layerRemoved(this, layer, this.getLayerInfo(layer), n);
        }
    }

    private void fireLayerPositionModified(Layer layer, int n, Point point, Point point2, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SceneListener.class) continue;
            ((SceneListener)objectArray[i + 1]).layerPositionChanged(this, layer, point, point2, bl);
        }
    }

    private void fireLayerLockModified(Layer layer, int n, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SceneListener.class) continue;
            ((SceneListener)objectArray[i + 1]).layerLockChanged(this, layer, bl);
        }
    }

    private void fireLayerSelectionModified(Layer layer, int n, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SceneSelectionListener.class) continue;
            ((SceneSelectionListener)objectArray[i + 1]).layerSelectionChanged(this, layer, bl);
        }
    }

    private void fireLayerVisibilityModified(Layer layer, int n, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SceneListener.class) continue;
            ((SceneListener)objectArray[i + 1]).layerVisibilityChanged(this, layer, bl);
        }
    }

    public int indexOf(Layer layer) {
        return this.layers.indexOf(layer);
    }

    public Layer getLayerAt(int n) {
        return this.layers.get(n);
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public List<Layer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public List<Layer> getLayersAtPoint(Point point) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (Layer layer : this.layers) {
            LayerInfo layerInfo = this.getLayerInfo(layer);
            Point point2 = layerInfo.getPosition();
            if (point2.equals(point)) {
                arrayList.add(layer);
                continue;
            }
            if (point2.x > point.x || point2.y > point.y || !this.getLayerBounds(layer).contains(point)) continue;
            arrayList.add(layer);
        }
        Collections.sort(arrayList, new LayerIndexComparator());
        return arrayList;
    }

    public Rectangle getLayerBounds(Layer layer) {
        Point point = this.getLayerPosition(layer);
        return new Rectangle(point.x, point.y, layer.getWidth(), layer.getHeight());
    }

    public Point getLayerPosition(Layer layer) {
        Point point = this.getLayerInfo(layer).getPosition();
        return point;
    }

    public void setLayerPositionX(Layer layer, int n, boolean bl) {
        Point point = this.getLayerPosition(layer);
        point.x = n;
        this.setLayerPosition(layer, point, bl);
    }

    public void setLayerPositionY(Layer layer, int n, boolean bl) {
        Point point = this.getLayerPosition(layer);
        point.y = n;
        this.setLayerPosition(layer, point, bl);
    }

    public void setLayerPosition(Layer layer, int n, int n2, boolean bl) {
        Point point = this.getLayerPosition(layer);
        point.x = n;
        point.y = n2;
        this.setLayerPosition(layer, point, bl);
    }

    public void setLayerPosition(Layer layer, Point point, boolean bl) {
        if (this.isLayerLocked(layer)) {
            throw new IllegalArgumentException("Layer: " + layer + " is locked");
        }
        LayerInfo layerInfo = this.getLayerInfo(layer);
        Point point2 = layerInfo.getPosition();
        layerInfo.setPosition(point);
        this.updateLayersBounds();
        this.fireLayerPositionModified(layer, this.layers.indexOf(layer), point2, layerInfo.getPosition(), bl);
    }

    public boolean isLayerVisible(Layer layer) {
        return this.getLayerInfo(layer).isVisible();
    }

    public void setLayerVisible(Layer layer, boolean bl) {
        boolean bl2 = this.getLayerInfo(layer).isVisible();
        if (bl2 == bl) {
            return;
        }
        this.getLayerInfo(layer).setVisible(bl);
        this.fireLayerVisibilityModified(layer, this.layers.indexOf(layer), bl);
    }

    public boolean isLayerLocked(Layer layer) {
        return this.getLayerInfo(layer).isLocked();
    }

    public void setLayerLocked(Layer layer, boolean bl) {
        boolean bl2 = this.getLayerInfo(layer).isLocked();
        if (bl2 == bl) {
            return;
        }
        this.getLayerInfo(layer).setLocked(bl);
        this.fireLayerLockModified(layer, this.layers.indexOf(layer), bl);
    }

    public boolean isLayerSelected(Layer layer) {
        return this.getLayerInfo(layer).isSelected();
    }

    public void setLayerSelected(Layer layer, boolean bl) {
        boolean bl2 = this.getLayerInfo(layer).isSelected();
        if (bl2 == bl) {
            return;
        }
        this.getLayerInfo(layer).setSelected(bl);
        this.fireLayerSelectionModified(layer, this.layers.indexOf(layer), bl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public JComponent getEditor() {
        if (null == this.editor) {
            this.editor = new SceneEditor(this);
        }
        return this.editor.getJComponent();
    }

    @Override
    public Editable.ImageResourceInfo getImageResourceInfo() {
        return null;
    }

    public GlobalRepository getGameDesign() {
        return this.gameDesign;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public List<Action> getActions() {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        arrayList.add(new EditSceneAction());
        arrayList.add(new RemoveSceneAction());
        arrayList.add(new RenameSceneAction());
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public void sceneAdded(Scene scene, int n) {
    }

    @Override
    public void sceneRemoved(Scene scene, int n) {
    }

    @Override
    public void tiledLayerAdded(TiledLayer tiledLayer, int n) {
    }

    @Override
    public void tiledLayerRemoved(TiledLayer tiledLayer, int n) {
        this.remove(tiledLayer);
    }

    @Override
    public void spriteAdded(Sprite sprite, int n) {
    }

    @Override
    public void spriteRemoved(Sprite sprite, int n) {
        this.remove(sprite);
    }

    @Override
    public void imageResourceAdded(ImageResource imageResource) {
    }

    @Override
    public JComponent getPreview() {
        if (this.preview == null) {
            this.preview = new ScenePreviewPanel(this);
            return this.preview;
        }
        return this.preview;
    }

    @Override
    public JComponent getNavigator() {
        if (this.navigator == null) {
            this.navigator = new SceneLayerNavigator(this);
            return this.navigator;
        }
        return this.navigator;
    }

    @Override
    public void paint(Graphics2D graphics2D, int n, int n2) {
    }

    @Override
    public int getWidth() {
        return 0;
    }

    @Override
    public int getHeight() {
        return 0;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l) {
        this.id = l;
    }

    public class RemoveSceneAction
    extends AbstractAction {
        public RemoveSceneAction() {
            this.putValue("Name", NbBundle.getMessage(Scene.class, (String)"Scene.RemoveSceneAction.text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(Scene.class, (String)"Scene.RemoveDialog.text", (Object)Scene.this.getName()), NbBundle.getMessage(Scene.class, (String)"Scene.RemoveSceneAction.text"), 0, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.YES_OPTION));
            if (object == NotifyDescriptor.YES_OPTION) {
                Scene.this.gameDesign.removeScene(Scene.this);
            }
        }
    }

    public class CreateTiledLayerAction
    extends AbstractAction {
        public CreateTiledLayerAction() {
            this.putValue("Name", NbBundle.getMessage(Scene.class, (String)"Scene.CreateTiledLayerAction.text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TiledLayerDialog tiledLayerDialog = new TiledLayerDialog(Scene.this);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)tiledLayerDialog, NbBundle.getMessage(Scene.class, (String)"Scene.CreateTiledLayerAction.text"));
            dialogDescriptor.setButtonListener((ActionListener)tiledLayerDialog);
            dialogDescriptor.setValid(false);
            tiledLayerDialog.setDialogDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
    }

    public class CreateSpriteAction
    extends AbstractAction {
        public CreateSpriteAction() {
            this.putValue("Name", NbBundle.getMessage(Scene.class, (String)"Scene.CreateSpriteAction.text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpriteDialog spriteDialog = new SpriteDialog(Scene.this);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)spriteDialog, NbBundle.getMessage(Scene.class, (String)"Scene.CreateSpriteAction.text"));
            dialogDescriptor.setButtonListener((ActionListener)spriteDialog);
            dialogDescriptor.setValid(false);
            spriteDialog.setDialogDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
    }

    public class EditSceneAction
    extends AbstractAction {
        public EditSceneAction() {
            this.putValue("Name", NbBundle.getMessage(Scene.class, (String)"Scene.EditSceneAction.text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Scene.this.gameDesign.getMainView().requestEditing(Scene.this);
        }
    }

    public class RenameSceneAction
    extends AbstractAction {
        public RenameSceneAction() {
            this.putValue("Name", NbBundle.getMessage(Scene.class, (String)"Scene.RenameSceneAction.text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RenameSceneDialog renameSceneDialog = new RenameSceneDialog(Scene.this);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)renameSceneDialog, NbBundle.getMessage(Scene.class, (String)"Scene.RenameSceneAction.text"));
            dialogDescriptor.setButtonListener((ActionListener)renameSceneDialog);
            dialogDescriptor.setValid(false);
            renameSceneDialog.setDialogDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
    }

    static class NameComparator
    implements Comparator {
        NameComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof Scene) || !(object2 instanceof Scene)) {
                throw new ClassCastException("Compared object not instance of Scene");
            }
            Scene scene = (Scene)object;
            Scene scene2 = (Scene)object2;
            return scene.getName().compareTo(scene2.getName());
        }
    }

    public static class LayerInfo {
        private Point position = new Point();
        private boolean visible = true;
        private boolean locked;
        private boolean selected;

        public String toString() {
            return "Position: " + this.position + ", visible: " + this.visible + ", locked: " + this.locked;
        }

        public Point getPosition() {
            return new Point(this.position);
        }

        public void setPosition(Point point) {
            this.position = point;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean bl) {
            this.locked = bl;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LayerIndexComparator
    implements Comparator<Layer> {
        private LayerIndexComparator() {
        }

        @Override
        public int compare(Layer layer, Layer layer2) {
            return Scene.this.layers.indexOf(layer) - Scene.this.layers.indexOf(layer2);
        }
    }
}

