/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.impl;

import java.io.InterruptedIOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilter;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Range;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLDataStorage
implements DataStorage {
    public static final String SQL_DATA_STORAGE_TYPE = "db:sql";
    private static final DataStorageType storageType = DataStorageTypeFactory.getInstance().getDataStorageType("db:sql");
    private LinkedBlockingQueue<Request> requestQueue;
    private final Object insertPreparedStatmentsLock = new Object();
    private final Map<String, PreparedStatement> insertPreparedStatments;
    private static final int WAIT_INTERVALS = 100;
    private static final int MAX_BULK_SIZE = 10000;
    private static final int BUFFER_COUNT = 6;
    private static final Logger logger = DLightLogger.getLogger(SQLDataStorage.class);
    protected Connection connection;
    protected HashMap<String, DataTableMetadata> tables = new HashMap();
    protected static final HashMap<Class<?>, String> classToType = new HashMap();
    private boolean enabled = false;
    private AsyncThread asyncThread = null;
    private ServiceInfoDataStorage serviceInfoDataStorage;

    public static final DataStorageType getStorageType() {
        return storageType;
    }

    protected SQLDataStorage() {
        this.insertPreparedStatments = new HashMap<String, PreparedStatement>();
    }

    protected SQLDataStorage(String string) throws SQLException {
        this();
        this.connect(string);
        if (!this.enabled) {
            this.enable();
        }
    }

    @Override
    public final void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoDataStorage = serviceInfoDataStorage;
    }

    protected final ServiceInfoDataStorage getServiceInfoDataStorage() {
        return this.serviceInfoDataStorage;
    }

    @Override
    public boolean shutdown() {
        this.disable();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                Exceptions.printStackTrace((Throwable)sQLException);
                return false;
            }
        }
        return true;
    }

    protected abstract String getSQLQueriesDelimeter();

    protected void finalize() throws Throwable {
        this.disable();
    }

    private synchronized void disable() {
        this.asyncThread.shutdown();
        this.enabled = false;
        this.asyncThread = null;
    }

    protected abstract void connect(String var1) throws SQLException;

    protected String classToType(Class<?> clazz) {
        return classToType.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String createView(Collection<DataTableMetadataFilter> collection, String string, List<DataTableMetadata.Column> list) {
        Object object;
        if (collection == null || collection.isEmpty()) {
            return string;
        }
        String string2 = string + "_DLIGHT_VIEW";
        try {
            object = this.connection.createStatement();
            try {
                object.execute("DROP VIEW IF EXISTS " + string2);
            }
            finally {
                object.close();
            }
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, null, sQLException);
        }
        object = new StringBuilder("CREATE  VIEW " + string2 + " AS ");
        ((StringBuilder)object).append("SELECT ");
        ((StringBuilder)object).append(new EnumStringConstructor<DataTableMetadata.Column>().constructEnumString(list, new Convertor<DataTableMetadata.Column>(){

            @Override
            public String toString(DataTableMetadata.Column column) {
                return column.getExpression() == null ? column.getColumnName() : column.getExpression();
            }
        }));
        ((StringBuilder)object).append(" FROM " + string);
        String string3 = null;
        for (DataTableMetadataFilter dataTableMetadataFilter : collection) {
            Range<?> range;
            DataTableMetadata.Column column = dataTableMetadataFilter.getFilteredColumn();
            if (!list.contains(column) || (range = dataTableMetadataFilter.getNumericDataFilter().getInterval()).getStart() == null && range.getEnd() == null) continue;
            string3 = range.toString(" WHERE ", "%d <= " + column.getColumnName(), " AND ", column.getColumnName() + " <= %d", null);
            break;
        }
        if (string3 == null) {
            return string;
        }
        ((StringBuilder)object).append(string3);
        try {
            Statement statement = this.connection.createStatement();
            try {
                statement.execute(((StringBuilder)object).toString());
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, null, sQLException);
            return string;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean createTable(final DataTableMetadata dataTableMetadata) {
        if (this.tables.containsKey(dataTableMetadata.getName())) {
            return true;
        }
        String string = dataTableMetadata.getName();
        StringBuilder stringBuilder = new StringBuilder("create table " + string + "(");
        stringBuilder.append(new EnumStringConstructor<DataTableMetadata.Column>().constructEnumString(dataTableMetadata.getColumns(), new Convertor<DataTableMetadata.Column>(){

            @Override
            public String toString(DataTableMetadata.Column column) {
                return column.getColumnName() + " " + SQLDataStorage.this.classToType(column.getColumnClass());
            }
        }));
        stringBuilder.append(")" + this.getSQLQueriesDelimeter());
        logger.fine("About to execute query: " + stringBuilder.toString());
        try {
            Statement statement = this.connection.createStatement();
            try {
                statement.execute(stringBuilder.toString());
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, null, sQLException);
            return false;
        }
        logger.fine("Table " + string + " created");
        this.tables.put(string, dataTableMetadata);
        for (DataTableMetadata.Column column : dataTableMetadata.getIndexedColumns()) {
            try {
                Statement statement = this.connection.createStatement();
                try {
                    statement.execute("create index " + string + "_" + column.getColumnName() + "_index on " + string + "(" + column.getColumnName() + ")");
                }
                finally {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                logger.log(Level.SEVERE, null, sQLException);
            }
        }
        DLightExecutorService.submit((Runnable)new Runnable(){

            public void run() {
                SQLDataStorage.this.getPreparedInsertStatement(dataTableMetadata);
            }
        }, (String)("SQL: Prepare Insert Statement for " + dataTableMetadata.getName()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getPreparedInsertStatement(DataTableMetadata dataTableMetadata) {
        Object object = this.insertPreparedStatmentsLock;
        synchronized (object) {
            PreparedStatement preparedStatement = this.insertPreparedStatments.get(dataTableMetadata.getName());
            if (preparedStatement != null) {
                return preparedStatement;
            }
            String string = dataTableMetadata.getName();
            StringBuilder stringBuilder = new StringBuilder("insert into " + string + " (");
            stringBuilder.append(new EnumStringConstructor<String>().constructEnumString(dataTableMetadata.getColumnNames(), new Convertor<String>(){

                @Override
                public String toString(String string) {
                    return string;
                }
            }));
            stringBuilder.append(") values (");
            int n = dataTableMetadata.getColumnsCount();
            for (int i = 0; i < n - 1; ++i) {
                stringBuilder.append("?, ");
            }
            stringBuilder.append("? ) " + this.getSQLQueriesDelimeter());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SQL: dispatching " + stringBuilder.toString());
            }
            PreparedStatement preparedStatement2 = null;
            try {
                preparedStatement2 = this.connection.prepareStatement(stringBuilder.toString());
            }
            catch (SQLException sQLException) {
                logger.log(Level.SEVERE, null, sQLException);
            }
            if (preparedStatement2 != null) {
                Map<String, PreparedStatement> map = this.insertPreparedStatments;
                synchronized (map) {
                    this.insertPreparedStatments.put(string, preparedStatement2);
                }
            }
            return preparedStatement;
        }
    }

    public ResultSet select(String string, List<DataTableMetadata.Column> list) {
        return this.select(string, list, null);
    }

    @Override
    public Collection<DataStorageType> getStorageTypes() {
        return Arrays.asList(DataStorageTypeFactory.getInstance().getDataStorageType(SQL_DATA_STORAGE_TYPE));
    }

    public final synchronized ResultSet select(DataTableMetadata dataTableMetadata, Collection<DataTableMetadataFilter> collection) {
        Object object;
        String string = dataTableMetadata.getName();
        String string2 = dataTableMetadata.getViewStatement();
        List<DataTableMetadata.Column> list = dataTableMetadata.getColumns();
        List<DataTableMetadata> list2 = dataTableMetadata.getSourceTables();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (list2 != null) {
            for (DataTableMetadata object2 : list2) {
                String string3 = this.createView(collection, object2.getName(), object2.getColumns());
                if (string3 == null || string3.equals(object2.getName())) continue;
                hashtable.put(object2.getName(), string3);
            }
        } else {
            object = this.createView(collection, string, list);
            if (object != null && ((String)object).equals(string)) {
                return this.select(string, list, string2);
            }
            if (string2 == null) {
                return this.select((String)object, list, null);
            }
        }
        object = string2;
        for (Map.Entry entry : hashtable.entrySet()) {
            object = ((String)object).replaceAll((String)entry.getKey(), (String)entry.getValue());
        }
        return this.select(string, list, (String)object);
    }

    public final ResultSet select(String string, List<DataTableMetadata.Column> list, String string2) {
        Object object;
        block3: {
            if (string2 == null) {
                object = new StringBuilder("select ");
                ((StringBuilder)object).append(new EnumStringConstructor<DataTableMetadata.Column>().constructEnumString(list, new Convertor<DataTableMetadata.Column>(){

                    @Override
                    public String toString(DataTableMetadata.Column column) {
                        return column.getExpression() == null ? column.getColumnName() : column.getExpression();
                    }
                }));
                ((StringBuilder)object).append(" from ").append(string);
                string2 = ((StringBuilder)object).toString();
            }
            object = null;
            try {
                object = this.connection.createStatement().executeQuery(string2);
            }
            catch (SQLException sQLException) {
                Throwable throwable = sQLException.getCause();
                if (throwable != null && (throwable instanceof InterruptedIOException || throwable instanceof InterruptedException)) break block3;
                logger.log(Level.SEVERE, null, sQLException);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String string) throws SQLException {
        Statement statement = this.connection.createStatement();
        try {
            statement.executeUpdate(string);
        }
        finally {
            statement.close();
        }
    }

    protected final Connection getConnection() {
        return this.connection;
    }

    protected final void execute(String string) throws SQLException {
        this.requestQueue.add(new CustomRequest(this.connection.prepareStatement(string)));
    }

    protected void addInsertInQueue(PreparedStatement preparedStatement) {
        this.requestQueue.add(new CustomRequest(preparedStatement));
    }

    @Override
    public final void addData(String string, List<DataRow> list) {
        for (DataRow dataRow : list) {
            this.requestQueue.add(new DataRowInsertRequest(string, dataRow));
        }
    }

    private PreparedStatement createRowInsertStatement(String string, DataRow dataRow) {
        if (logger.isLoggable(Level.INFO)) {
            logger.fine("Will add to the queue with using prepared statement");
        }
        StringBuilder stringBuilder = new StringBuilder("insert into " + string + " (");
        stringBuilder.append(new EnumStringConstructor<String>().constructEnumString(dataRow.getColumnNames(), new Convertor<String>(){

            @Override
            public String toString(String string) {
                return string;
            }
        }));
        stringBuilder.append(") values (");
        stringBuilder.append(new EnumStringConstructor<Object>().constructEnumString(dataRow.getData(), new Convertor<Object>(){

            @Override
            public String toString(Object object) {
                return String.valueOf(object);
            }
        }));
        stringBuilder.append(")" + this.getSQLQueriesDelimeter());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("----------SQL: dispatching " + stringBuilder.toString());
        }
        try {
            return this.connection.prepareStatement(stringBuilder.toString());
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, null, sQLException);
            return null;
        }
    }

    private synchronized void enable() {
        if (!this.enabled) {
            this.requestQueue = new LinkedBlockingQueue();
            this.enabled = true;
            if (this.asyncThread == null) {
                this.asyncThread = new AsyncThread();
            }
            this.asyncThread.start();
        }
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        String string2;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SQL: prepare statement " + string);
        }
        PreparedStatement preparedStatement = (string2 = string.toUpperCase()).startsWith("INSERT INTO ") ? this.connection.prepareStatement(string, 1) : (string2.endsWith(" FOR UPDATE") ? this.connection.prepareStatement(string, 1003, 1008) : this.connection.prepareStatement(string));
        return preparedStatement;
    }

    static {
        classToType.put(Byte.class, "tinyint");
        classToType.put(Short.class, "smallint");
        classToType.put(Integer.class, "int");
        classToType.put(Long.class, "bigint");
        classToType.put(Double.class, "double");
        classToType.put(Float.class, "real");
        classToType.put(String.class, "varchar");
        classToType.put(Time.class, "bigint");
    }

    private class AsyncReadThread
    extends Thread {
        private boolean shutdown;
        private int emptyBufferCount;
        List<Request> requestList = new ArrayList<Request>();

        public AsyncReadThread() {
            this.setDaemon(true);
            this.setName("DLIGHT: SQL Storage AsyncFillModelThread");
        }

        public void run() {
            while (this.emptyBufferCount < 6) {
                for (int i = 0; i < 10000; ++i) {
                    try {
                        Request request = (Request)SQLDataStorage.this.requestQueue.poll(100L, TimeUnit.MILLISECONDS);
                        if (request == null) break;
                        this.requestList.add(request);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    if (this.requestList.isEmpty()) {
                        if (this.shutdown) {
                            ++this.emptyBufferCount;
                        }
                    } else {
                        for (Request request : this.requestList) {
                            request.execute();
                        }
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "SQLDataStorage_db_write_failed", exception);
                }
                this.requestList.clear();
            }
        }

        private void shutdown() {
            this.shutdown = true;
            while (this.emptyBufferCount < 6) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class AsyncThread
    extends Thread {
        private boolean shutdown;
        private int emptyBufferCount;
        List<Request> requestList = new ArrayList<Request>();

        public AsyncThread() {
            this.setDaemon(true);
            this.setName("DLIGHT: SQL Storage AsyncThread");
        }

        public void run() {
            while (this.emptyBufferCount < 6) {
                for (int i = 0; i < 10000; ++i) {
                    try {
                        Request request = (Request)SQLDataStorage.this.requestQueue.poll(100L, TimeUnit.MILLISECONDS);
                        if (request == null) break;
                        this.requestList.add(request);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    if (this.requestList.isEmpty()) {
                        if (this.shutdown) {
                            ++this.emptyBufferCount;
                        }
                    } else {
                        for (Request request : this.requestList) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("EXECUTEEEEEEEEEEEEEEE !!!SQL: dispatching request  " + request.toString());
                            }
                            request.execute();
                        }
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "SQLDataStorage.async_db_write_failed", exception);
                }
                this.requestList.clear();
            }
        }

        private void shutdown() {
            this.shutdown = true;
            while (this.emptyBufferCount < 6) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Convertor<T> {
        public String toString(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumStringConstructor<T> {
        public String constructEnumString(Collection<? extends T> collection, Convertor<T> convertor) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext()) {
                T t = iterator.next();
                stringBuilder.append(convertor.toString(t));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }
    }

    private class DataRowInsertRequest
    extends BaseRequest {
        final String tableName;
        final DataRow dataRow;

        public DataRowInsertRequest(String string, DataRow dataRow) {
            this.tableName = string;
            this.dataRow = dataRow;
        }

        PreparedStatement getPreparedStatement() throws SQLException {
            DataTableMetadata dataTableMetadata = SQLDataStorage.this.tables.get(this.tableName);
            PreparedStatement preparedStatement = SQLDataStorage.this.getPreparedInsertStatement(dataTableMetadata);
            if (preparedStatement == null) {
                return SQLDataStorage.this.createRowInsertStatement(this.tableName, this.dataRow);
            }
            List<DataTableMetadata.Column> list = dataTableMetadata.getColumns();
            List<String> list2 = this.dataRow.getColumnNames();
            if (list2.size() != list.size()) {
                return SQLDataStorage.this.createRowInsertStatement(this.tableName, this.dataRow);
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                DataTableMetadata.Column column = list.get(i);
                preparedStatement.setObject(i + 1, this.dataRow.getData(column.getColumnName()));
            }
            return preparedStatement;
        }

        public String toString() {
            return "insert into " + this.tableName + ": " + this.dataRow.toString();
        }
    }

    private static class CustomRequest
    extends BaseRequest {
        PreparedStatement preparedStatement;

        public CustomRequest(PreparedStatement preparedStatement) {
            this.preparedStatement = preparedStatement;
        }

        PreparedStatement getPreparedStatement() throws SQLException {
            return this.preparedStatement;
        }
    }

    private static abstract class BaseRequest
    implements Request {
        private BaseRequest() {
        }

        abstract PreparedStatement getPreparedStatement() throws SQLException;

        public void execute() throws SQLException {
            PreparedStatement preparedStatement = this.getPreparedStatement();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SQL: dispatching insert  " + preparedStatement.toString());
            }
            preparedStatement.execute();
        }
    }

    private static interface Request {
        public void execute() throws SQLException;
    }
}

