/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.reformat.ExtendedTokenSequence;

class StackEntry {
    private int index;
    private CppTokenId kind;
    private CppTokenId importantKind;
    private boolean likeToFunction = false;
    private boolean likeToArrayInitialization = false;
    private String text;
    private int indent;
    private int selfIndent;

    StackEntry(ExtendedTokenSequence extendedTokenSequence) {
        this.index = extendedTokenSequence.index();
        this.kind = (CppTokenId)extendedTokenSequence.token().id();
        this.text = ((Object)extendedTokenSequence.token().text()).toString();
        switch (this.kind) {
            case IF: 
            case ELSE: 
            case TRY: 
            case CATCH: 
            case WHILE: 
            case FOR: 
            case DO: 
            case ASM: 
            case SWITCH: {
                this.importantKind = this.kind;
                break;
            }
            default: {
                this.initImportant(extendedTokenSequence);
            }
        }
    }

    private void initImportant(ExtendedTokenSequence extendedTokenSequence) {
        int n = extendedTokenSequence.index();
        try {
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            block27: while (true) {
                if (!extendedTokenSequence.movePrevious()) {
                    return;
                }
                Token<CppTokenId> token = extendedTokenSequence.token();
                switch ((CppTokenId)token.id()) {
                    case RPAREN: {
                        if (n2 == 0 && !bl && n3 == 0) {
                            this.likeToFunction = true;
                        }
                        ++n2;
                        break;
                    }
                    case LPAREN: {
                        Token<CppTokenId> token2;
                        if (n2 == 0) {
                            token2 = extendedTokenSequence.lookPreviousImportant();
                            if (token2 != null && token2.id() == CppTokenId.OPERATOR) {
                                this.likeToArrayInitialization = false;
                                this.likeToFunction = true;
                                return;
                            }
                            this.likeToArrayInitialization = true;
                            return;
                        }
                        --n2;
                        break;
                    }
                    case RBRACE: 
                    case LBRACE: 
                    case SEMICOLON: {
                        if (n2 != 0 || bl || n3 != 0) continue block27;
                        return;
                    }
                    case EQ: {
                        if (n2 != 0) break;
                        Token<CppTokenId> token2 = extendedTokenSequence.lookPreviousImportant();
                        if (token2 != null && token2.id() == CppTokenId.OPERATOR) {
                            this.likeToArrayInitialization = false;
                            this.likeToFunction = true;
                            return;
                        }
                        this.likeToArrayInitialization = true;
                        this.likeToFunction = false;
                        return;
                    }
                    case GT: {
                        if (n2 != 0 || bl) continue block27;
                        Token<CppTokenId> token2 = extendedTokenSequence.lookPreviousImportant();
                        if (token2 != null && token2.id() == CppTokenId.OPERATOR) {
                            this.likeToArrayInitialization = false;
                            this.likeToFunction = true;
                            return;
                        }
                        ++n3;
                        break;
                    }
                    case LT: {
                        Token<CppTokenId> token2;
                        if (n2 != 0 || bl) continue block27;
                        if (n3 == 0) {
                            token2 = extendedTokenSequence.lookPreviousImportant();
                            if (token2 != null && token2.id() == CppTokenId.OPERATOR) {
                                this.likeToArrayInitialization = false;
                                this.likeToFunction = true;
                                return;
                            }
                            return;
                        }
                        --n3;
                        break;
                    }
                    case NAMESPACE: 
                    case CLASS: {
                        if (n2 != 0 || bl || n3 != 0) continue block27;
                        this.importantKind = (CppTokenId)token.id();
                        this.likeToFunction = false;
                        return;
                    }
                    case STRUCT: 
                    case ENUM: 
                    case UNION: {
                        if (n2 != 0 || bl || n3 != 0 || this.likeToFunction) continue block27;
                        this.importantKind = (CppTokenId)token.id();
                        return;
                    }
                    case EXTERN: {
                        if (n2 != 0 || bl || n3 != 0 || this.likeToFunction) continue block27;
                        this.importantKind = CppTokenId.NAMESPACE;
                        return;
                    }
                    case IF: 
                    case ELSE: 
                    case TRY: 
                    case CATCH: 
                    case WHILE: 
                    case FOR: 
                    case DO: 
                    case SWITCH: {
                        if (n2 != 0 || bl || n3 != 0) continue block27;
                        this.importantKind = (CppTokenId)token.id();
                        this.likeToFunction = false;
                        return;
                    }
                }
            }
        }
        finally {
            extendedTokenSequence.moveIndex(n);
            extendedTokenSequence.moveNext();
        }
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public int getSelfIndent() {
        return this.selfIndent;
    }

    public void setSelfIndent(int n) {
        this.selfIndent = n;
    }

    public int getIndex() {
        return this.index;
    }

    public String getText() {
        return this.text;
    }

    public CppTokenId getKind() {
        return this.kind;
    }

    public CppTokenId getImportantKind() {
        return this.importantKind;
    }

    public boolean isLikeToFunction() {
        return this.likeToFunction;
    }

    public void setLikeToFunction(boolean bl) {
        this.likeToFunction = bl;
    }

    public boolean isLikeToArrayInitialization() {
        return this.likeToArrayInitialization;
    }

    public void setLikeToArrayInitialization(boolean bl) {
        this.likeToArrayInitialization = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.kind.name());
        if (this.importantKind != null && this.kind != this.importantKind) {
            stringBuilder.append("(" + this.importantKind.name() + ")");
        } else if (this.likeToFunction) {
            stringBuilder.append("(FUNCTION)");
        } else if (this.likeToArrayInitialization) {
            stringBuilder.append("(ARRAY_INITIALIZATION)");
        }
        return stringBuilder.toString();
    }
}

