/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hyperlink;

import javax.swing.text.Document;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.hibernate.editor.ContextUtilities;
import org.netbeans.modules.hibernate.editor.DocumentContext;
import org.netbeans.modules.hibernate.editor.EditorContextFactory;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.filesystems.FileObject;

public final class HyperlinkEnv {
    private Document document;
    private SyntaxElement currentTag;
    private String attribName;
    private String valueString;
    private int offset;
    private TokenItem token;
    private DocumentContext documentContext;
    private Type type = Type.NONE;

    public HyperlinkEnv(Document document, int n) {
        this.document = document;
        this.offset = n;
        this.documentContext = EditorContextFactory.getDocumentContext(document, n);
        if (this.documentContext.isValid()) {
            this.currentTag = this.documentContext.getCurrentElement();
            this.attribName = ContextUtilities.getAttributeTokenImage(this.documentContext);
            this.token = this.documentContext.getCurrentToken();
            if (ContextUtilities.isValueToken(this.documentContext.getCurrentToken())) {
                this.type = Type.ATTRIB_VALUE;
                this.currentTag = this.documentContext.getCurrentElement();
                this.attribName = ContextUtilities.getAttributeTokenImage(this.documentContext);
                this.token = this.documentContext.getCurrentToken();
                this.valueString = this.token.getImage();
                this.valueString = this.valueString.substring(1, this.valueString.length() - 1);
            } else if (ContextUtilities.isAttributeToken(this.documentContext.getCurrentToken())) {
                this.type = Type.ATTRIB;
                this.currentTag = this.documentContext.getCurrentElement();
                this.token = this.documentContext.getCurrentToken();
                this.attribName = this.token.getImage();
            }
        }
    }

    public String getAttribName() {
        return this.attribName;
    }

    public Tag getCurrentTag() {
        return this.currentTag instanceof Tag ? (Tag)this.currentTag : null;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getTagName() {
        return this.getCurrentTag() != null ? this.getCurrentTag().getTagName() : null;
    }

    public String getValueString() {
        return this.valueString;
    }

    public Type getType() {
        return this.type;
    }

    public TokenItem getToken() {
        return this.token;
    }

    public int getOffset() {
        return this.offset;
    }

    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    public FileObject getFile() {
        return NbEditorUtilities.getFileObject((Document)this.document);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ATTRIB_VALUE,
        ATTRIB,
        TEXT,
        NONE;


        public boolean isValueHyperlink() {
            return this == ATTRIB_VALUE;
        }

        public boolean isAttributeHyperlink() {
            return this == ATTRIB;
        }
    }
}

