/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.core.actions.HTMLViewAction;
import org.netbeans.core.startup.Splash;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ProductInformationPanel
extends JPanel
implements HyperlinkListener {
    URL url = null;
    Icon about = new ImageIcon(Splash.loadContent((boolean)true));
    private JTextPane copyright;
    private JTextPane description;
    private JButton jButton2;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;

    public ProductInformationPanel() {
        this.initComponents();
        this.jLabel1.setCursor(Cursor.getPredefinedCursor(12));
        this.description.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_Description", (Object[])new Object[]{ProductInformationPanel.getProductVersionValue(), ProductInformationPanel.getJavaValue(), ProductInformationPanel.getVMValue(), ProductInformationPanel.getOperatingSystemValue(), ProductInformationPanel.getEncodingValue(), ProductInformationPanel.getSystemLocaleValue(), this.getUserDirValue()}));
        this.description.setCaretPosition(0);
        this.description.addHyperlinkListener(this);
        this.copyright.addHyperlinkListener(this);
        this.copyright.setBackground(this.getBackground());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButton2 = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.copyright = new JTextPane();
        this.jScrollPane2 = new JScrollPane();
        this.description = new JTextPane();
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(this.about);
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ProductInformationPanel.this.jLabel1MouseClicked(mouseEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButton2.setMnemonic(NbBundle.getMessage(ProductInformationPanel.class, (String)"MNE_Close").charAt(0));
        this.jButton2.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_Close"));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProductInformationPanel.this.jButton2ActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        this.jScrollPane3.setBorder(null);
        this.copyright.setBorder(null);
        this.copyright.setContentType("text/html");
        this.copyright.setEditable(false);
        this.copyright.setText(ProductInformationPanel.getCopyrightText());
        this.copyright.setCaretPosition(0);
        this.copyright.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ProductInformationPanel.this.copyrightMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane3.setViewportView(this.copyright);
        this.description.setContentType("text/html");
        this.description.setEditable(false);
        this.description.setText("<div style=\"font-size: 12pt; font-family: Verdana, 'Verdana CE',  Arial, 'Arial CE', 'Lucida Grande CE', lucida, 'Helvetica CE', sans-serif;\">\n    <b>Product Version:</b> {0}<br> <b>Java:</b> {1}; {2}<br> <b>System:</b> {3}; {4}; {5}<br><b>Userdir:</b> {6}</div>");
        this.jScrollPane2.setViewportView(this.description);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane2, -1, 190, Short.MAX_VALUE).add((Component)this.jScrollPane3, -1, 190, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, 190, Short.MAX_VALUE).add(1, (Component)this.jLabel1, -1, 190, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(1).add((Component)this.jScrollPane3, -1, 120, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jScrollPane2, -1, 98, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2).addContainerGap()));
    }

    private void copyrightMouseClicked(MouseEvent mouseEvent) {
        this.showUrl();
    }

    private void jButton2ActionPerformed(ActionEvent actionEvent) {
        this.closeDialog();
    }

    private void jLabel1MouseClicked(MouseEvent mouseEvent) {
        try {
            this.url = new URL(NbBundle.getMessage(ProductInformationPanel.class, (String)"URL_ON_IMG"));
            this.showUrl();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.url = null;
    }

    private void closeDialog() {
        Window window = SwingUtilities.getWindowAncestor(this);
        window.setVisible(false);
        window.dispose();
    }

    private void showUrl() {
        if (this.url != null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getBundle(HTMLViewAction.class).getString("CTL_OpeningBrowser"));
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.url);
        }
    }

    public static String getProductVersionValue() {
        return MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
    }

    public static String getOperatingSystemValue() {
        return NbBundle.getMessage(ProductInformationPanel.class, (String)"Format_OperatingSystem_Value", (Object)System.getProperty("os.name", "unknown"), (Object)System.getProperty("os.version", "unknown"), (Object)System.getProperty("os.arch", "unknown"));
    }

    public static String getJavaValue() {
        return System.getProperty("java.version", "unknown");
    }

    public static String getVMValue() {
        return System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "");
    }

    public static String getSystemLocaleValue() {
        String string;
        return Locale.getDefault().toString() + ((string = NbBundle.getBranding()) == null ? "" : " (" + string + ")");
    }

    private String getUserDirValue() {
        return System.getProperty("netbeans.user");
    }

    public static String getEncodingValue() {
        return System.getProperty("file.encoding", "unknown");
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (HyperlinkEvent.EventType.ENTERED == hyperlinkEvent.getEventType()) {
            this.url = hyperlinkEvent.getURL();
        } else if (HyperlinkEvent.EventType.EXITED == hyperlinkEvent.getEventType()) {
            this.url = null;
        }
    }

    private static String getCopyrightText() {
        FileObject[] fileObjectArray;
        String string = NbBundle.getBundle(ProductInformationPanel.class).getString("LBL_Copyright");
        FileObject fileObject = FileUtil.getConfigFile((String)"About/Licenses");
        if (fileObject != null && (fileObjectArray = fileObject.getChildren()).length > 0) {
            boolean bl = false;
            StringWriter stringWriter = new StringWriter();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                String string2 = ProductInformationPanel.loadLicenseText(fileObjectArray[i]);
                if (string2 == null) continue;
                stringWriter.write("<br>" + MessageFormat.format(NbBundle.getBundle(ProductInformationPanel.class).getString("LBL_AddOnCopyright"), string2));
                bl = true;
            }
            if (bl) {
                string = string + stringWriter.toString();
            }
        }
        return string;
    }

    private static String loadLicenseText(FileObject fileObject) {
        InputStream inputStream = null;
        try {
            inputStream = fileObject.getInputStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringWriter stringWriter = new StringWriter();
        try {
            int n;
            while ((n = bufferedReader.read()) != -1) {
                stringWriter.write(n);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return stringWriter.toString();
    }
}

