/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.utils.CppUtils;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.compilers.SunFortranCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationBase;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class FortranCompilerConfiguration
extends BasicCompilerConfiguration
implements AllOptionsProvider,
ConfigurationBase {
    public FortranCompilerConfiguration(String string, FortranCompilerConfiguration fortranCompilerConfiguration) {
        super(string, fortranCompilerConfiguration);
    }

    public void assign(FortranCompilerConfiguration fortranCompilerConfiguration) {
        super.assign(fortranCompilerConfiguration);
    }

    public FortranCompilerConfiguration clone() {
        FortranCompilerConfiguration fortranCompilerConfiguration = new FortranCompilerConfiguration(this.getBaseDir(), (FortranCompilerConfiguration)this.getMaster());
        fortranCompilerConfiguration.setDevelopmentMode(this.getDevelopmentMode().clone());
        fortranCompilerConfiguration.setWarningLevel(this.getWarningLevel().clone());
        fortranCompilerConfiguration.setSixtyfourBits(this.getSixtyfourBits().clone());
        fortranCompilerConfiguration.setStrip(this.getStrip().clone());
        fortranCompilerConfiguration.setMTLevel(this.getMTLevel().clone());
        fortranCompilerConfiguration.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        fortranCompilerConfiguration.setTool(this.getTool().clone());
        fortranCompilerConfiguration.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        return fortranCompilerConfiguration;
    }

    public String getOptions(BasicCompiler basicCompiler) {
        String string = "$(COMPILE.f) ";
        string = string + this.getAllOptions2(basicCompiler) + " ";
        string = string + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getFFlagsBasic(BasicCompiler basicCompiler) {
        String string = "";
        string = string + basicCompiler.getStripOption(this.getStrip().getValue()) + " ";
        if (basicCompiler instanceof SunFortranCompiler) {
            string = string + ((SunFortranCompiler)basicCompiler).getMTLevelOptions(this.getMTLevel().getValue()) + " ";
        }
        string = string + basicCompiler.getSixtyfourBitsOption(this.getSixtyfourBits().getValue()) + " ";
        if (this.getDevelopmentMode().getValue() == 3) {
            string = string + basicCompiler.getDevelopmentModeOptions(3);
        }
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getFFlags(BasicCompiler basicCompiler) {
        String string = this.getFFlagsBasic(basicCompiler) + " ";
        string = string + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getAllOptions(BasicCompiler basicCompiler) {
        CCompilerConfiguration cCompilerConfiguration = (CCompilerConfiguration)this.getMaster();
        String string = "";
        string = string + this.getFFlagsBasic(basicCompiler) + " ";
        if (cCompilerConfiguration != null) {
            string = string + cCompilerConfiguration.getCommandLineConfiguration().getValue() + " ";
        }
        string = string + this.getAllOptions2(basicCompiler) + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getAllOptions2(BasicCompiler basicCompiler) {
        FortranCompilerConfiguration fortranCompilerConfiguration = (FortranCompilerConfiguration)this.getMaster();
        String string = "";
        if (this.getDevelopmentMode().getValue() != 3) {
            string = string + basicCompiler.getDevelopmentModeOptions(this.getDevelopmentMode().getValue()) + " ";
        }
        string = string + basicCompiler.getWarningLevelOptions(this.getWarningLevel().getValue()) + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public Sheet getGeneralSheet(MakeConfiguration makeConfiguration) {
        Sheet.Set set;
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        BasicCompiler basicCompiler = compilerSet == null ? null : (BasicCompiler)compilerSet.getTool(2);
        sheet.put(this.getBasicSet());
        if (this.getMaster() != null) {
            sheet.put(this.getInputSet());
        }
        if (compilerSet != null && compilerSet.isSunCompiler()) {
            set = new Sheet.Set();
            set.setName("OtherOptions");
            set.setDisplayName(FortranCompilerConfiguration.getString("OtherOptionsTxt"));
            set.setShortDescription(FortranCompilerConfiguration.getString("OtherOptionsHint"));
            set.put((Node.Property)new IntNodeProp(this.getMTLevel(), this.getMaster() == null, "MultithreadingLevel", FortranCompilerConfiguration.getString("MultithreadingLevelTxt"), FortranCompilerConfiguration.getString("MultithreadingLevelHint")));
            sheet.put(set);
        }
        set = new Sheet.Set();
        set.setName("Tool");
        set.setDisplayName(FortranCompilerConfiguration.getString("ToolTxt1"));
        set.setShortDescription(FortranCompilerConfiguration.getString("ToolHint1"));
        if (basicCompiler != null) {
            set.put((Node.Property)new StringNodeProp(this.getTool(), basicCompiler.getName(), false, "Tool", FortranCompilerConfiguration.getString("ToolTxt2"), FortranCompilerConfiguration.getString("ToolHint2")));
        }
        sheet.put(set);
        String[] stringArray = new String[]{FortranCompilerConfiguration.getString("AdditionalOptionsTxt1"), FortranCompilerConfiguration.getString("AdditionalOptionsHint"), FortranCompilerConfiguration.getString("AdditionalOptionsTxt2"), FortranCompilerConfiguration.getString("AllOptionsTxt")};
        Sheet.Set set2 = new Sheet.Set();
        set2.setName("CommandLine");
        set2.setDisplayName(FortranCompilerConfiguration.getString("CommandLineTxt"));
        set2.setShortDescription(FortranCompilerConfiguration.getString("CommandLineHint"));
        if (basicCompiler != null) {
            set2.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, basicCompiler, null, stringArray));
        }
        sheet.put(set2);
        return sheet;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(FortranCompilerConfiguration.class, (String)string);
    }
}

