/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.GroupTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;
import org.openide.util.NbBundle;

public class SecurityEditGroupPanel
extends JPanel {
    private final ResourceBundle customizerBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.Bundle");
    private final GroupTableModel groupModel;
    private final String originalGroupName;
    private String groupName;
    private JLabel jLblGroupName;
    private JTextField jTxtGroupName;

    public SecurityEditGroupPanel(String string, GroupTableModel groupTableModel) {
        this.groupModel = groupTableModel;
        this.originalGroupName = this.groupName = string;
        this.initComponents();
        this.initUserComponents();
        this.initFields();
    }

    protected String getGroupName() {
        return this.groupName;
    }

    protected String getOriginalGroupName() {
        return this.originalGroupName;
    }

    private void initComponents() {
        this.jLblGroupName = new JLabel();
        this.jTxtGroupName = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jLblGroupName.setLabelFor(this.jTxtGroupName);
        this.jLblGroupName.setText(this.customizerBundle.getString("LBL_GroupName_1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 11, 0, 0);
        this.add((Component)this.jLblGroupName, gridBagConstraints);
        this.jTxtGroupName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SecurityEditGroupPanel.this.jTxtGroupNameKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 11);
        this.add((Component)this.jTxtGroupName, gridBagConstraints);
        this.jTxtGroupName.getAccessibleContext().setAccessibleName(this.customizerBundle.getString("ACSN_GroupName"));
        this.jTxtGroupName.getAccessibleContext().setAccessibleDescription(this.customizerBundle.getString("ACSD_GroupName"));
    }

    private void jTxtGroupNameKeyReleased(KeyEvent keyEvent) {
        this.groupName = this.jTxtGroupName.getText();
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void initUserComponents() {
        this.getAccessibleContext().setAccessibleName(this.customizerBundle.getString("ACSN_EditGroupName"));
        this.getAccessibleContext().setAccessibleDescription(this.customizerBundle.getString("ACSD_EditGroupName"));
    }

    private void initFields() {
        this.jTxtGroupName.setText(this.groupName);
    }

    Collection getErrors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getGroupName();
        if (!Utils.notEmpty(string)) {
            arrayList.add(this.customizerBundle.getString("ERR_BlankGroupName"));
        }
        if (string != null && !string.equals(this.getOriginalGroupName()) && this.groupModel.contains(string)) {
            arrayList.add(MessageFormat.format(this.customizerBundle.getString("ERR_GroupExists"), string));
        }
        return arrayList;
    }

    static void editGroupName(JPanel jPanel, String string, GroupTableModel groupTableModel) {
        SecurityEditGroupPanel securityEditGroupPanel = new SecurityEditGroupPanel(string, groupTableModel);
        securityEditGroupPanel.displayDialog(jPanel, NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.Bundle").getString("TITLE_EditGroup"), "AS_CFG_SecurityRoleEditGroup");
    }

    private void displayDialog(JPanel jPanel, String string, String string2) {
        BetterInputDialog betterInputDialog = new BetterInputDialog(jPanel, string, string2, this);
        do {
            int n = betterInputDialog.display();
            if (n == 0) break;
            if (n != 1) continue;
            Collection collection = this.getErrors();
            String string3 = this.getGroupName();
            String string4 = this.getOriginalGroupName();
            if (betterInputDialog.hasErrors()) {
                betterInputDialog.showErrors();
                continue;
            }
            if (Utils.strEquals(string3, string4)) continue;
            this.groupModel.replaceElement(string4, string3);
        } while (betterInputDialog.hasErrors());
    }

    private static class BetterInputDialog
    extends InputDialog {
        private final SecurityEditGroupPanel dialogPanel;
        private final String panelHelpId;

        public BetterInputDialog(JPanel jPanel, String string, String string2, SecurityEditGroupPanel securityEditGroupPanel) {
            super(jPanel, string);
            this.dialogPanel = securityEditGroupPanel;
            this.panelHelpId = string2;
            this.dialogPanel.setPreferredSize(new Dimension(jPanel.getWidth() * 3 / 4, this.dialogPanel.getPreferredSize().height));
            this.getAccessibleContext().setAccessibleName(this.dialogPanel.getAccessibleContext().getAccessibleName());
            this.getAccessibleContext().setAccessibleDescription(this.dialogPanel.getAccessibleContext().getAccessibleDescription());
            this.getContentPane().add((Component)securityEditGroupPanel, "Center");
            this.addListeners();
            this.pack();
            this.setLocationInside(jPanel);
            this.handleErrorDisplay();
        }

        private void addListeners() {
            this.dialogPanel.addPropertyChangeListener("UserDataChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BetterInputDialog.this.handleErrorDisplay();
                }
            });
        }

        private void handleErrorDisplay() {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.dialogPanel.getErrors());
            this.setErrors(arrayList);
        }

        protected String getHelpId() {
            return this.panelHelpId;
        }
    }
}

