/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;
import org.netbeans.modules.form.layoutdesign.VisualMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LayoutOperations
implements LayoutConstants {
    private LayoutModel layoutModel;
    private VisualMapper visualMapper;

    LayoutOperations(LayoutModel layoutModel, VisualMapper visualMapper) {
        this.layoutModel = layoutModel;
        this.visualMapper = visualMapper;
    }

    LayoutModel getModel() {
        return this.layoutModel;
    }

    VisualMapper getMapper() {
        return this.visualMapper;
    }

    int extract(LayoutInterval layoutInterval, int n, boolean bl, List<List> list, List<List> list2) {
        return this.extract(layoutInterval, layoutInterval, n, bl, list, list2);
    }

    int extract(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n, boolean bl, List<List> list, List<List> list2) {
        int n2;
        LayoutInterval layoutInterval3 = layoutInterval.getParent();
        assert (layoutInterval3.isSequential());
        int n3 = layoutInterval3.indexOf(layoutInterval);
        int n4 = layoutInterval3.indexOf(layoutInterval2);
        int n5 = layoutInterval3.getSubIntervalCount();
        if (bl) {
            n2 = n4 - n3 + 1;
        } else if (n != 0 && n != 1) {
            n2 = 1;
        } else {
            int n6 = n2 = n == 0 ? n5 - n3 : n3 + 1;
        }
        if (n2 < layoutInterval3.getSubIntervalCount()) {
            LinkedList<LayoutInterval> linkedList = null;
            LinkedList<LayoutInterval> linkedList2 = null;
            int n7 = n == 0 ? n3 : n3 - n2 + 1;
            int n8 = n == 0 ? n4 + n2 - 1 : n4;
            Iterator<LayoutInterval> iterator = layoutInterval3.getSubIntervals();
            int n9 = 0;
            while (iterator.hasNext()) {
                LayoutInterval layoutInterval4 = iterator.next();
                if (n9 < n7) {
                    if (linkedList == null) {
                        linkedList = new LinkedList<LayoutInterval>();
                        linkedList.add((LayoutInterval)((Object)new Integer(LayoutInterval.getEffectiveAlignment(layoutInterval4))));
                    }
                    linkedList.add(layoutInterval4);
                } else if (n9 > n8) {
                    if (linkedList2 == null) {
                        linkedList2 = new LinkedList<LayoutInterval>();
                        linkedList2.add((LayoutInterval)((Object)new Integer(LayoutInterval.getEffectiveAlignment(layoutInterval4))));
                    }
                    linkedList2.add(layoutInterval4);
                }
                ++n9;
            }
            if (linkedList != null) {
                iterator = linkedList.iterator();
                iterator.next();
                do {
                    this.layoutModel.removeInterval(iterator.next());
                } while (iterator.hasNext());
                list.add(linkedList);
            }
            if (linkedList2 != null) {
                iterator = linkedList2.iterator();
                iterator.next();
                do {
                    this.layoutModel.removeInterval(iterator.next());
                } while (iterator.hasNext());
                list2.add(linkedList2);
            }
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    LayoutInterval addGroupContent(List<List> list, LayoutInterval layoutInterval, int n, int n2, int n3) {
        assert (layoutInterval.isSequential() && (n3 == 0 || n3 == 1));
        boolean bl = false;
        LayoutInterval object = null;
        boolean bl2 = true;
        for (int i = list.size() - 1; i >= 0; --i) {
            List list2 = list.get(i);
            assert (list2.size() >= 2);
            if (list2.size() == 2) {
                LayoutInterval object2 = (LayoutInterval)list2.get(1);
                if (object2.isEmptySpace()) {
                    if (object == null || object2.getPreferredSize() > object.getPreferredSize()) {
                        object = object2;
                    }
                    if (LayoutInterval.canResize(object2)) {
                        bl = true;
                    }
                    list.remove(i);
                    continue;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        if (bl2) {
            if (bl && !LayoutInterval.canResize(object)) {
                this.layoutModel.setIntervalSize(object, -1, object.getPreferredSize(), Short.MAX_VALUE);
            }
            this.insertGapIntoSequence(object, layoutInterval, n, n2);
            return null;
        }
        if (list.size() == 1) {
            void var11_16;
            List list3 = list.get(0);
            int n4 = list3.size();
            int i = n4 - 1;
            while (var11_16 > 0) {
                LayoutInterval layoutInterval2 = (LayoutInterval)list3.get((int)var11_16);
                if (bl && layoutInterval2.isEmptySpace() && !LayoutInterval.canResize(layoutInterval2) && (var11_16 == true && n3 == 1 || var11_16 == n4 - 1 && n3 == 0)) {
                    this.layoutModel.setIntervalSize(layoutInterval2, -1, layoutInterval2.getPreferredSize(), Short.MAX_VALUE);
                }
                if (var11_16 == true && layoutInterval2.isEmptySpace()) {
                    this.insertGapIntoSequence(layoutInterval2, layoutInterval, n, n2);
                } else {
                    this.layoutModel.addInterval(layoutInterval2, layoutInterval, n);
                }
                --var11_16;
            }
            return null;
        }
        LayoutInterval layoutInterval3 = new LayoutInterval(103);
        for (List list2 : list) {
            LayoutInterval layoutInterval4;
            int n4;
            if (list2.size() == 2) {
                n4 = (Integer)list2.get(0);
                layoutInterval4 = (LayoutInterval)list2.get(1);
                if (n4 == 0 || n4 == 1) {
                    this.layoutModel.setIntervalAlignment(layoutInterval4, n4);
                }
            } else {
                layoutInterval4 = new LayoutInterval(102);
                n4 = (Integer)list2.get(0);
                if (n4 == 0 || n4 == 1) {
                    layoutInterval4.setAlignment(n4);
                }
                int n5 = list2.size();
                for (int i = 1; i < n5; ++i) {
                    LayoutInterval layoutInterval5 = (LayoutInterval)list2.get(i);
                    if (bl && layoutInterval5.isEmptySpace() && !LayoutInterval.canResize(layoutInterval5) && (i == 1 && n3 == 1 || i == n5 - 1 && n3 == 0)) {
                        this.layoutModel.setIntervalSize(layoutInterval5, -1, layoutInterval5.getPreferredSize(), Short.MAX_VALUE);
                    }
                    this.layoutModel.addInterval(layoutInterval5, layoutInterval4, -1);
                }
            }
            this.layoutModel.addInterval(layoutInterval4, layoutInterval3, -1);
        }
        this.layoutModel.addInterval(layoutInterval3, layoutInterval, n);
        return layoutInterval3;
    }

    boolean addContent(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        if (layoutInterval.isGroup() && layoutInterval.getSubIntervalCount() == 1) {
            return this.addContent(this.layoutModel.removeInterval(layoutInterval, 0), layoutInterval2, n);
        }
        if (layoutInterval.isSequential() && layoutInterval2.isSequential()) {
            if (n < 0) {
                n = layoutInterval2.getSubIntervalCount();
            }
            while (layoutInterval.getSubIntervalCount() > 0) {
                LayoutInterval layoutInterval3 = this.layoutModel.removeInterval(layoutInterval, 0);
                this.layoutModel.addInterval(layoutInterval3, layoutInterval2, n++);
            }
            return true;
        }
        if (layoutInterval.isParallel() && layoutInterval2.isParallel()) {
            LayoutInterval layoutInterval4;
            int n2 = layoutInterval.getAlignment();
            if (n2 == -1) {
                n2 = layoutInterval2.getGroupAlignment();
            }
            boolean bl = true;
            Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
            while (iterator.hasNext()) {
                layoutInterval4 = iterator.next();
                if (LayoutInterval.wantResize(layoutInterval4)) {
                    bl = true;
                    break;
                }
                if (layoutInterval4.getAlignment() == n2) continue;
                bl = false;
            }
            if (bl && (LayoutInterval.canResize(layoutInterval) || !LayoutInterval.canResize(layoutInterval2) || !LayoutInterval.wantResize(layoutInterval2))) {
                assert (layoutInterval.getParent() == null);
                while (layoutInterval.getSubIntervalCount() > 0) {
                    layoutInterval4 = layoutInterval.getSubInterval(0);
                    if (layoutInterval4.getRawAlignment() == -1 && layoutInterval.getGroupAlignment() != layoutInterval2.getGroupAlignment()) {
                        this.layoutModel.setIntervalAlignment(layoutInterval4, layoutInterval4.getAlignment());
                    }
                    this.layoutModel.removeInterval(layoutInterval4);
                    this.layoutModel.addInterval(layoutInterval4, layoutInterval2, n);
                    if (n < 0) continue;
                    ++n;
                }
                if (!LayoutInterval.canResize(layoutInterval) && LayoutInterval.canResize(layoutInterval2)) {
                    this.suppressGroupResizing(layoutInterval2);
                }
                return true;
            }
            this.layoutModel.addInterval(layoutInterval, layoutInterval2, n);
        } else {
            if (layoutInterval2.isSequential() && layoutInterval.getRawAlignment() != -1) {
                this.layoutModel.setIntervalAlignment(layoutInterval, -1);
            }
            this.layoutModel.addInterval(layoutInterval, layoutInterval2, n);
        }
        return false;
    }

    void resizeInterval(LayoutInterval layoutInterval, int n) {
        int n2;
        assert (n >= 0 || n == -1);
        int n3 = n2 = layoutInterval.getMinimumSize() == layoutInterval.getPreferredSize() && layoutInterval.getMaximumSize() < Short.MAX_VALUE ? n : layoutInterval.getMinimumSize();
        int n4 = layoutInterval.getMaximumSize() == layoutInterval.getPreferredSize() ? (n == -1 ? -2 : n) : layoutInterval.getMaximumSize();
        this.layoutModel.setIntervalSize(layoutInterval, n2, n, n4);
    }

    void suppressGroupResizing(LayoutInterval layoutInterval) {
        if (layoutInterval.getParent() != null) {
            this.layoutModel.setIntervalSize(layoutInterval, layoutInterval.getMinimumSize(), layoutInterval.getPreferredSize(), -2);
        }
    }

    void enableGroupResizing(LayoutInterval layoutInterval) {
        this.layoutModel.setIntervalSize(layoutInterval, layoutInterval.getMinimumSize(), layoutInterval.getPreferredSize(), -1);
    }

    void mergeParallelGroups(LayoutInterval layoutInterval) {
        assert (layoutInterval.isParallel());
        if (!layoutInterval.isParallel()) {
            return;
        }
        for (int i = layoutInterval.getSubIntervalCount() - 1; i >= 0; --i) {
            LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(i);
            if (!layoutInterval2.isParallel()) continue;
            this.mergeParallelGroups(layoutInterval2);
            this.dissolveRedundantGroup(layoutInterval2);
        }
    }

    boolean dissolveRedundantGroup(LayoutInterval layoutInterval) {
        int n;
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        if (layoutInterval2 == null) {
            return false;
        }
        boolean bl = false;
        if (layoutInterval.getSubIntervalCount() == 1) {
            bl = true;
        } else if (layoutInterval.isSequential() && layoutInterval2.isSequential()) {
            bl = true;
        } else if (layoutInterval.isParallel() && layoutInterval2.isParallel()) {
            boolean bl2;
            n = layoutInterval.getAlignment();
            boolean bl3 = true;
            boolean bl4 = false;
            Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
            while (iterator.hasNext()) {
                LayoutInterval layoutInterval3 = iterator.next();
                if (!bl4 && LayoutInterval.wantResize(layoutInterval3)) {
                    bl4 = true;
                }
                if (layoutInterval3.getAlignment() == n || layoutInterval.getSubIntervalCount() <= 1) continue;
                bl3 = false;
            }
            if (bl4 && (bl3 || layoutInterval.getGroupAlignment() != 3)) {
                bl2 = false;
                if (LayoutInterval.canResize(layoutInterval) || !LayoutInterval.canResize(layoutInterval2)) {
                    LayoutInterval layoutInterval4;
                    iterator = layoutInterval2.getSubIntervals();
                    while (iterator.hasNext()) {
                        layoutInterval4 = iterator.next();
                        if (layoutInterval4 == layoutInterval || !LayoutInterval.wantResize(layoutInterval4)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2 && (n == 0 || n == 1) && (layoutInterval4 = LayoutInterval.getNeighbor(layoutInterval2, layoutInterval.getAlignment() ^ 1, false, true, true)) != null && layoutInterval4.isEmptySpace() && layoutInterval4.getPreferredSize() == -1) {
                        bl2 = true;
                    }
                }
            } else {
                bl2 = bl3;
            }
            bl = bl2;
        }
        if (bl) {
            n = this.layoutModel.removeInterval(layoutInterval);
            while (layoutInterval.getSubIntervalCount() > 0) {
                LayoutInterval layoutInterval5 = layoutInterval.getSubInterval(0);
                if (layoutInterval2.isParallel()) {
                    if (layoutInterval.isParallel()) {
                        if (layoutInterval5.getRawAlignment() == -1 && layoutInterval.getGroupAlignment() != layoutInterval2.getGroupAlignment()) {
                            this.layoutModel.setIntervalAlignment(layoutInterval5, layoutInterval5.getAlignment());
                        }
                    } else {
                        this.layoutModel.setIntervalAlignment(layoutInterval5, layoutInterval.getRawAlignment());
                    }
                } else if (layoutInterval5.getRawAlignment() != -1) {
                    this.layoutModel.setIntervalAlignment(layoutInterval5, -1);
                }
                this.layoutModel.removeInterval(layoutInterval5);
                this.layoutModel.addInterval(layoutInterval5, layoutInterval2, n++);
            }
            return true;
        }
        return false;
    }

    void moveInsideSequential(LayoutInterval layoutInterval, int n) {
        block18: {
            LayoutInterval layoutInterval2;
            LayoutInterval layoutInterval3;
            assert (layoutInterval.isSequential());
            if (!layoutInterval.isSequential()) {
                return;
            }
            int n2 = 0;
            block0: do {
                int n3;
                int n4;
                int n5;
                int n6;
                LayoutInterval layoutInterval4;
                LayoutInterval layoutInterval5;
                if ((layoutInterval5 = this.findIntervalToExtend(layoutInterval, n, n2)) == null) {
                    if (n2 == 0) {
                        n2 = 1;
                        layoutInterval5 = this.findIntervalToExtend(layoutInterval, n, n2);
                    }
                    if (layoutInterval5 == null) break block18;
                }
                layoutInterval3 = layoutInterval4 = layoutInterval5.getParent();
                while (layoutInterval3.getParent() != layoutInterval) {
                    layoutInterval3 = layoutInterval3.getParent();
                }
                int n7 = layoutInterval.indexOf(layoutInterval3);
                int n8 = n2 == 0 ? -1 : 1;
                boolean bl = true;
                int n9 = layoutInterval.getSubIntervalCount();
                for (n6 = n7 - n8; n6 >= 0 && n6 < n9; n6 -= n8) {
                    LayoutInterval layoutInterval6;
                    LayoutInterval layoutInterval7 = layoutInterval.getSubInterval(n6);
                    if (layoutInterval7.isEmptySpace() && (n6 - n8 < 0 || n6 - n8 >= n9) || !LayoutInterval.wantResize(layoutInterval7)) continue;
                    LayoutInterval layoutInterval8 = layoutInterval.getSubInterval(n2 == 0 ? n9 - 1 : 0);
                    if (layoutInterval8 != null && layoutInterval8.getPreferredSize() == -1) break;
                    bl = false;
                    layoutInterval2 = layoutInterval5;
                    n5 = layoutInterval.getCurrentSpace().positions[n][n2 ^ 1];
                    do {
                        if (!(layoutInterval6 = layoutInterval2.getParent()).isParallel()) continue;
                        this.separateGroupContent(layoutInterval2, n5, n, n2 ^ 1);
                    } while ((layoutInterval2 = layoutInterval6) != layoutInterval3);
                    break;
                }
                n6 = layoutInterval5.getCurrentSpace().positions[n][n2 ^ 1];
                if (!layoutInterval5.isSequential()) {
                    LayoutInterval layoutInterval9 = new LayoutInterval(102);
                    layoutInterval9.setAlignment(layoutInterval5.getAlignment());
                    this.layoutModel.addInterval(layoutInterval9, layoutInterval4, this.layoutModel.removeInterval(layoutInterval5));
                    this.layoutModel.setIntervalAlignment(layoutInterval5, -1);
                    this.layoutModel.addInterval(layoutInterval5, layoutInterval9, 0);
                    layoutInterval5 = layoutInterval9;
                }
                LayoutInterval layoutInterval10 = null;
                if (n2 == 0) {
                    n4 = n7 + 1;
                    n3 = layoutInterval5.getSubIntervalCount();
                } else {
                    n4 = n7 - 1;
                    n3 = 0;
                }
                while (n4 >= 0 && n4 < layoutInterval.getSubIntervalCount()) {
                    layoutInterval2 = layoutInterval.getSubInterval(n4);
                    if (layoutInterval2.isEmptySpace()) {
                        if (layoutInterval10 == null) {
                            int n10;
                            if (n6 != layoutInterval3.getCurrentSpace().positions[n][n2 ^ 1] && (n10 = n8 * (n6 - (n5 = layoutInterval.getSubInterval((int)(n4 - n8)).getCurrentSpace().positions[n][n2]))) > 0) {
                                this.resizeInterval(layoutInterval2, n10);
                            }
                            layoutInterval10 = layoutInterval2;
                        } else if ((n4 == 0 || n4 == layoutInterval.getSubIntervalCount() - 1) && bl) continue block0;
                    }
                    this.layoutModel.removeInterval(layoutInterval2);
                    this.layoutModel.addInterval(layoutInterval2, layoutInterval5, n3);
                    if (n2 == 0) {
                        ++n3;
                        continue;
                    }
                    --n4;
                }
            } while (layoutInterval.getSubIntervalCount() != 1);
            assert (layoutInterval3 == layoutInterval.getSubInterval(0));
            this.layoutModel.removeInterval(layoutInterval3);
            layoutInterval2 = layoutInterval.getParent();
            this.addContent(layoutInterval3, layoutInterval2, this.layoutModel.removeInterval(layoutInterval));
        }
    }

    private LayoutInterval findIntervalToExtend(LayoutInterval layoutInterval, int n, int n2) {
        int n3 = n2 == 0 ? -1 : 1;
        int n4 = layoutInterval.getSubIntervalCount();
        boolean bl = true;
        boolean bl2 = false;
        for (int i = n2 == 0 ? n4 - 1 : 0; i >= 0 && i < layoutInterval.getSubIntervalCount(); i += n3) {
            LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(i);
            if (layoutInterval2.isEmptySpace()) {
                bl2 = true;
                continue;
            }
            if (!bl && bl2 && layoutInterval2.isParallel() && !LayoutInterval.isClosedGroup(layoutInterval2, n2 ^ 1)) {
                int n5;
                int n6;
                if (n2 == 0) {
                    n6 = i + 1;
                    n5 = layoutInterval.getSubIntervalCount() - 1;
                } else {
                    n6 = 0;
                    n5 = i - 1;
                }
                LayoutInterval layoutInterval3 = this.prepareGroupExtension(layoutInterval2, layoutInterval, n6, n5, n, n2 ^ 1);
                if (layoutInterval3 != null) {
                    return layoutInterval3;
                }
            }
            bl2 = false;
            bl = false;
        }
        return null;
    }

    private LayoutInterval prepareGroupExtension(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n, int n2, int n3, int n4) {
        LayoutInterval layoutInterval3;
        boolean bl = true;
        LayoutInterval layoutInterval4 = null;
        LinkedList<LayoutInterval> linkedList = null;
        Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            layoutInterval3 = iterator.next();
            if (layoutInterval3.isEmptySpace()) continue;
            if (LayoutUtils.contentOverlap(layoutInterval3, layoutInterval2, n, n2, n3 ^ 1)) {
                if (layoutInterval4 == null) {
                    layoutInterval4 = layoutInterval3;
                    continue;
                }
                if (linkedList == null) {
                    linkedList = new LinkedList<LayoutInterval>();
                    linkedList.add(layoutInterval4);
                }
                linkedList.add(layoutInterval3);
                continue;
            }
            bl = false;
        }
        if (bl || layoutInterval4 == null) {
            return null;
        }
        if (linkedList != null) {
            layoutInterval3 = new LayoutInterval(103);
            layoutInterval3.setGroupAlignment(n4 ^ 1);
            layoutInterval3.setAlignment(n4 ^ 1);
            int n5 = -1;
            do {
                LayoutInterval layoutInterval5 = (LayoutInterval)linkedList.remove(0);
                int n6 = this.layoutModel.removeInterval(layoutInterval5);
                if (n5 < 0) {
                    n5 = n6;
                }
                this.layoutModel.addInterval(layoutInterval5, layoutInterval3, -1);
                layoutInterval3.getCurrentSpace().expand(layoutInterval5.getCurrentSpace());
            } while (linkedList.size() > 0);
            this.layoutModel.addInterval(layoutInterval3, layoutInterval, n5);
            layoutInterval4 = layoutInterval3;
        } else {
            LayoutInterval layoutInterval6;
            if (layoutInterval4.isSequential()) {
                layoutInterval3 = layoutInterval4.getSubInterval(n4 == 0 ? 0 : layoutInterval4.getSubIntervalCount() - 1);
                if (!layoutInterval3.isParallel()) {
                    layoutInterval3 = null;
                }
            } else {
                layoutInterval3 = layoutInterval4.isParallel() ? layoutInterval4 : null;
            }
            if (layoutInterval3 != null && !LayoutInterval.isClosedGroup(layoutInterval3, n4) && (layoutInterval6 = this.prepareGroupExtension(layoutInterval3, layoutInterval2, n, n2, n3, n4)) != null) {
                layoutInterval4 = layoutInterval6;
            }
        }
        return layoutInterval4;
    }

    private void separateGroupContent(LayoutInterval layoutInterval, int n, int n2, int n3) {
        LayoutInterval layoutInterval2;
        LayoutInterval layoutInterval3 = layoutInterval.getParent();
        assert (layoutInterval3.isParallel());
        LayoutInterval layoutInterval4 = null;
        LayoutInterval layoutInterval5 = null;
        LayoutRegion layoutRegion = null;
        int n4 = 0;
        while (n4 < layoutInterval3.getSubIntervalCount()) {
            LayoutInterval layoutInterval6 = layoutInterval3.getSubInterval(n4);
            if (layoutInterval6 != layoutInterval) {
                assert (layoutInterval6.getAlignment() == (n3 ^ 1));
                this.layoutModel.removeInterval(layoutInterval6);
                if (layoutInterval4 == null) {
                    layoutInterval4 = layoutInterval6;
                } else {
                    if (layoutInterval5 == null) {
                        layoutInterval5 = new LayoutInterval(103);
                        layoutInterval5.setAlignment(n3 ^ 1);
                        layoutInterval5.setGroupAlignment(n3 ^ 1);
                        this.layoutModel.addInterval(layoutInterval4, layoutInterval5, 0);
                        layoutInterval4 = layoutInterval5;
                    }
                    this.layoutModel.addInterval(layoutInterval6, layoutInterval5, -1);
                }
                if (layoutInterval6.isEmptySpace()) continue;
                if (layoutRegion == null) {
                    layoutRegion = new LayoutRegion();
                }
                layoutRegion.expand(layoutInterval6.getCurrentSpace());
                continue;
            }
            ++n4;
        }
        layoutInterval4.setCurrentSpace(layoutRegion);
        int n5 = layoutRegion.positions[n2][n3];
        if (LayoutRegion.isValidCoordinate(n)) {
            int n6 = n3 == 0 ? n5 - n : n - n5;
            layoutInterval2 = new LayoutInterval(101);
            layoutInterval2.setSizes(-1, n6, Short.MAX_VALUE);
        } else {
            layoutInterval2 = LayoutInterval.getDirectNeighbor(layoutInterval3, n3, false);
            if (layoutInterval2 != null && layoutInterval2.isEmptySpace()) {
                this.layoutModel.removeInterval(layoutInterval2);
                LayoutInterval layoutInterval7 = LayoutInterval.getDirectNeighbor(layoutInterval3, n3, true);
                n = layoutInterval7 != null ? layoutInterval7.getCurrentSpace().positions[n2][n3 ^ 1] : layoutInterval3.getParent().getCurrentSpace().positions[n2][n3];
                int n7 = n3 == 0 ? n5 - n : n - n5;
                this.resizeInterval(layoutInterval2, n7);
            } else {
                layoutInterval2 = null;
            }
        }
        if (layoutInterval2 != null) {
            LayoutInterval layoutInterval8;
            if (layoutInterval4.isSequential()) {
                layoutInterval8 = layoutInterval4;
            } else {
                layoutInterval8 = new LayoutInterval(102);
                this.layoutModel.setIntervalAlignment(layoutInterval4, -1);
                this.layoutModel.addInterval(layoutInterval4, layoutInterval8, 0);
            }
            this.layoutModel.addInterval(layoutInterval2, layoutInterval8, n3 == 0 ? 0 : -1);
            this.layoutModel.addInterval(layoutInterval8, layoutInterval3, -1);
            layoutInterval3.getCurrentSpace().positions[n2][n3] = n;
        } else {
            this.layoutModel.addInterval(layoutInterval4, layoutInterval3, -1);
        }
    }

    void parallelizeWithParentSequence(LayoutInterval layoutInterval, int n, int n2) {
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        assert (layoutInterval2.isParallel());
        LayoutInterval layoutInterval3 = layoutInterval2;
        while (!layoutInterval3.getParent().isSequential()) {
            layoutInterval3 = layoutInterval3.getParent();
        }
        LayoutInterval layoutInterval4 = layoutInterval3.getParent();
        int n3 = layoutInterval4.indexOf(layoutInterval3);
        if (n < 0) {
            n = layoutInterval4.getSubIntervalCount() - 1;
        } else if (n3 > n) {
            int n4 = n3;
            n3 = n;
            n = n4;
        }
        this.layoutModel.removeInterval(layoutInterval);
        if (layoutInterval.getAlignment() == -1) {
            this.layoutModel.setIntervalAlignment(layoutInterval, layoutInterval2.getGroupAlignment());
        }
        this.addParallelWithSequence(layoutInterval, layoutInterval4, n3, n, n2);
        if (layoutInterval2.getSubIntervalCount() == 1) {
            this.addContent(this.layoutModel.removeInterval(layoutInterval2, 0), layoutInterval2.getParent(), this.layoutModel.removeInterval(layoutInterval2));
        } else if (layoutInterval2.getSubIntervalCount() == 0) {
            this.layoutModel.removeInterval(layoutInterval2);
        }
    }

    void addParallelWithSequence(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n, int n2, int n3) {
        LayoutInterval layoutInterval3;
        if (n > 0 || n2 < layoutInterval2.getSubIntervalCount() - 1) {
            layoutInterval3 = new LayoutInterval(103);
            if (layoutInterval.getAlignment() != -1) {
                layoutInterval3.setGroupAlignment(layoutInterval.getAlignment());
            }
            int n4 = LayoutUtils.getVisualPosition(layoutInterval2.getSubInterval(n), n3, 0);
            int n5 = LayoutUtils.getVisualPosition(layoutInterval2.getSubInterval(n2), n3, 1);
            layoutInterval3.getCurrentSpace().set(n3, n4, n5);
            if (n != n2) {
                LayoutInterval layoutInterval4 = new LayoutInterval(102);
                layoutInterval4.setAlignment(layoutInterval2.getAlignment());
                for (int i = n2 - n + 1; i > 0; --i) {
                    this.layoutModel.addInterval(this.layoutModel.removeInterval(layoutInterval2, n), layoutInterval4, -1);
                }
                this.layoutModel.addInterval(layoutInterval4, layoutInterval3, 0);
            } else {
                this.layoutModel.addInterval(this.layoutModel.removeInterval(layoutInterval2, n), layoutInterval3, 0);
            }
            this.layoutModel.addInterval(layoutInterval3, layoutInterval2, n);
        } else {
            layoutInterval3 = layoutInterval2.getParent();
        }
        this.layoutModel.addInterval(layoutInterval, layoutInterval3, -1);
    }

    int optimizeGaps(LayoutInterval layoutInterval, int n) {
        int n2;
        boolean bl;
        Object object;
        int n3;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = true;
        boolean bl8 = true;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        for (int i = 0; i < layoutInterval.getSubIntervalCount(); ++i) {
            int n6;
            LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(i);
            if (layoutInterval2.isEmptySpace() && layoutInterval.getSubIntervalCount() > 1) {
                this.layoutModel.removeInterval(layoutInterval, i);
                --i;
                continue;
            }
            n3 = 0;
            int n7 = 0;
            object = null;
            LayoutInterval layoutInterval3 = null;
            bl = false;
            n2 = 0;
            if (layoutInterval2.isSequential()) {
                n6 = 0;
                boolean bl9 = false;
                for (int j = 0; j < layoutInterval2.getSubIntervalCount(); ++j) {
                    LayoutInterval layoutInterval4 = layoutInterval2.getSubInterval(j);
                    if (j == 0 && layoutInterval4.isEmptySpace()) {
                        object = layoutInterval4;
                        n6 = LayoutInterval.wantResize(layoutInterval4) ? 1 : 0;
                        continue;
                    }
                    if (j + 1 == layoutInterval2.getSubIntervalCount() && layoutInterval4.isEmptySpace()) {
                        layoutInterval3 = layoutInterval4;
                        bl9 = LayoutInterval.wantResize(layoutInterval4);
                        continue;
                    }
                    if (bl || !LayoutInterval.wantResize(layoutInterval4)) continue;
                    bl = true;
                }
                if (!bl) {
                    if (n6 != 0 || bl9) {
                        n3 = bl9 && n6 == 0 ? 1 : 0;
                        n7 = n6 != 0 && !bl9 ? 1 : 0;
                    } else {
                        n2 = 1;
                    }
                }
            } else if (LayoutInterval.wantResize(layoutInterval2)) {
                bl = true;
            } else {
                n2 = 1;
            }
            if (bl) {
                n7 = 1;
                n3 = 1;
            } else if (n2 != 0) {
                n6 = layoutInterval2.getAlignment();
                n3 = n6 == 0 ? 1 : 0;
                int n8 = n7 = n6 == 1 ? 1 : 0;
            }
            if (n3 != 0) {
                bl2 = true;
                if (n7 != 0) {
                    bl4 = true;
                }
            }
            if (n7 != 0) {
                bl3 = true;
            }
            if (object != null) {
                bl5 = true;
                if (bl7) {
                    int n9 = n6 = n3 != 0 || object.getMinimumSize() == -2 ? object.getPreferredSize() : object.getMinimumSize();
                    if (n4 != Integer.MIN_VALUE) {
                        if (n6 != n4) {
                            bl7 = false;
                        }
                    } else {
                        n4 = n6;
                    }
                }
            } else {
                bl7 = false;
            }
            if (layoutInterval3 != null) {
                bl6 = true;
                if (!bl8) continue;
                int n10 = n6 = n7 != 0 || layoutInterval3.getMinimumSize() == -2 ? layoutInterval3.getPreferredSize() : layoutInterval3.getMinimumSize();
                if (n5 != Integer.MIN_VALUE) {
                    if (n6 == n5) continue;
                    bl8 = false;
                    continue;
                }
                n5 = n6;
                continue;
            }
            bl8 = false;
        }
        if (layoutInterval.getSubIntervalCount() <= 1 || !bl5 && !bl6) {
            return -1;
        }
        if (!bl4) {
            if (bl3) {
                bl7 = false;
            }
            if (bl2) {
                bl8 = false;
            }
        }
        int[] nArray = layoutInterval.getCurrentSpace().positions[n];
        assert (nArray[0] > Short.MIN_VALUE && nArray[1] > Short.MIN_VALUE);
        int n11 = LayoutUtils.getOutermostComponent((LayoutInterval)layoutInterval, (int)n, (int)0).getCurrentSpace().positions[n][0];
        n3 = LayoutUtils.getOutermostComponent((LayoutInterval)layoutInterval, (int)n, (int)1).getCurrentSpace().positions[n][1];
        LayoutConstants.PaddingType paddingType = null;
        object = null;
        boolean bl10 = false;
        bl = false;
        for (n2 = 0; n2 < layoutInterval.getSubIntervalCount(); ++n2) {
            LayoutInterval layoutInterval5;
            LayoutInterval layoutInterval6;
            LayoutInterval layoutInterval7 = layoutInterval.getSubInterval(n2);
            if (!layoutInterval7.isSequential()) continue;
            if (bl5 && (layoutInterval6 = layoutInterval7.getSubInterval(0)).isEmptySpace()) {
                if (layoutInterval6.getPreferredSize() == -1 && (layoutInterval5 = LayoutInterval.getNeighbor(layoutInterval6, 0, false, true, false)) != null && layoutInterval5.isEmptySpace()) {
                    this.layoutModel.removeInterval(layoutInterval6);
                    layoutInterval6 = null;
                }
                if (layoutInterval6 != null && (!bl2 || bl7)) {
                    if (layoutInterval6.getPreferredSize() == -1 && this.isEndingDefaultGapEffective(layoutInterval7, n, 0) && (paddingType = layoutInterval6.getPaddingType()) == null) {
                        paddingType = LayoutConstants.PaddingType.RELATED;
                    }
                    if (layoutInterval6.getMaximumSize() >= Short.MAX_VALUE) {
                        if (layoutInterval7.getAlignment() == 0) {
                            this.layoutModel.setIntervalAlignment(layoutInterval7, 1);
                        }
                        if (!bl2) {
                            bl10 = true;
                        }
                    }
                    this.layoutModel.removeInterval(layoutInterval6);
                }
            }
            if (bl6 && (layoutInterval6 = layoutInterval7.getSubInterval(layoutInterval7.getSubIntervalCount() - 1)).isEmptySpace()) {
                if (layoutInterval6.getPreferredSize() == -1 && (layoutInterval5 = LayoutInterval.getNeighbor(layoutInterval6, 1, false, true, false)) != null && layoutInterval5.isEmptySpace()) {
                    this.layoutModel.removeInterval(layoutInterval6);
                    layoutInterval6 = null;
                }
                if (layoutInterval6 != null && (!bl3 || bl8)) {
                    if (layoutInterval6.getPreferredSize() == -1 && this.isEndingDefaultGapEffective(layoutInterval7, n, 1) && (object = layoutInterval6.getPaddingType()) == null) {
                        object = LayoutConstants.PaddingType.RELATED;
                    }
                    if (layoutInterval6.getMaximumSize() >= Short.MAX_VALUE) {
                        if (layoutInterval7.getAlignment() == 1) {
                            this.layoutModel.setIntervalAlignment(layoutInterval7, 0);
                        }
                        if (!bl3) {
                            bl = true;
                        }
                    }
                    this.layoutModel.removeInterval(layoutInterval6);
                }
            }
            if (layoutInterval7.getSubIntervalCount() != 1) continue;
            this.layoutModel.removeInterval(layoutInterval, n2);
            layoutInterval6 = this.layoutModel.removeInterval(layoutInterval7, 0);
            this.layoutModel.setIntervalAlignment(layoutInterval6, layoutInterval7.getRawAlignment());
            this.layoutModel.addInterval(layoutInterval6, layoutInterval, n2);
        }
        LayoutInterval layoutInterval8 = null;
        LayoutInterval layoutInterval9 = null;
        if (bl5) {
            if (!bl2) {
                int n12 = n11 - nArray[0];
                if (n12 > 0 || paddingType != null) {
                    layoutInterval8 = new LayoutInterval(101);
                    if (paddingType != null) {
                        layoutInterval8.setPaddingType(paddingType);
                    } else {
                        layoutInterval8.setPreferredSize(n12);
                        if (!bl10) {
                            layoutInterval8.setMinimumSize(-2);
                        }
                    }
                    if (bl10) {
                        layoutInterval8.setMaximumSize(Short.MAX_VALUE);
                    }
                }
            } else if (bl7) {
                layoutInterval8 = new LayoutInterval(101);
                layoutInterval8.setSizes(n4, n4, -2);
                if (n4 == -1) {
                    layoutInterval8.setPaddingType(paddingType);
                }
            }
        }
        if (bl6) {
            if (!bl3) {
                int n13 = nArray[1] - n3;
                if (n13 > 0 || object != null) {
                    layoutInterval9 = new LayoutInterval(101);
                    if (object != null) {
                        layoutInterval9.setPaddingType((LayoutConstants.PaddingType)((Object)object));
                    } else {
                        layoutInterval9.setPreferredSize(n13);
                        if (!bl) {
                            layoutInterval9.setMinimumSize(-2);
                        }
                    }
                    if (bl) {
                        layoutInterval9.setMaximumSize(Short.MAX_VALUE);
                    }
                }
            } else if (bl8) {
                layoutInterval9 = new LayoutInterval(101);
                layoutInterval9.setSizes(n5, n5, -2);
                if (n5 == -1) {
                    layoutInterval9.setPaddingType((LayoutConstants.PaddingType)((Object)object));
                }
            }
        }
        if (layoutInterval8 != null || layoutInterval9 != null) {
            LayoutInterval layoutInterval10;
            if (layoutInterval8 != null || !LayoutRegion.isValidCoordinate(nArray[0])) {
                nArray[0] = n11;
            }
            if (layoutInterval9 != null || !LayoutRegion.isValidCoordinate(nArray[1])) {
                nArray[1] = n3;
            }
            nArray[2] = (n11 + n3) / 2;
            if (layoutInterval8 != null) {
                layoutInterval = this.insertGap(layoutInterval8, layoutInterval, n11, n, 0);
            }
            if (layoutInterval9 != null) {
                layoutInterval = this.insertGap(layoutInterval9, layoutInterval, n3, n, 1);
            }
            return (layoutInterval10 = layoutInterval.getParent()) != null ? layoutInterval10.indexOf(layoutInterval) : -1;
        }
        return -1;
    }

    private boolean isEndingDefaultGapEffective(LayoutInterval layoutInterval, int n, int n2) {
        assert (layoutInterval.isSequential() && (n2 == 0 || n2 == 1));
        int n3 = n2 == 0 ? 0 : layoutInterval.getSubIntervalCount() - 1;
        int n4 = n2 == 0 ? 1 : -1;
        LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(n3);
        LayoutInterval layoutInterval3 = layoutInterval.getSubInterval(n3 + n4);
        if (LayoutInterval.getEffectiveAlignment(layoutInterval3, n2) == n2) {
            return true;
        }
        int n5 = LayoutUtils.getSizeOfDefaultGap(layoutInterval2, this.visualMapper);
        int n6 = layoutInterval3.getCurrentSpace().positions[n][n2];
        LayoutInterval layoutInterval4 = LayoutInterval.getNeighbor(layoutInterval2, n2, true, true, false);
        int n7 = layoutInterval4 != null ? layoutInterval4.getCurrentSpace().positions[n][n2 ^ 1] : LayoutInterval.getRoot((LayoutInterval)layoutInterval).getCurrentSpace().positions[n][n2];
        int n8 = (n6 - n7) * n4;
        return n8 <= n5;
    }

    boolean cutStartingGap(LayoutInterval layoutInterval, int n, int n2, int n3) {
        LayoutInterval layoutInterval2;
        assert (layoutInterval.isGroup() && n > 0 && (n3 == 0 || n3 == 1));
        LayoutInterval layoutInterval3 = null;
        if (layoutInterval.isSequential()) {
            layoutInterval3 = layoutInterval;
        } else if (layoutInterval.getSubIntervalCount() == 1 && (layoutInterval2 = layoutInterval.getSubInterval(0)).isSequential() && LayoutInterval.isAlignedAtBorder(layoutInterval2, n3)) {
            layoutInterval3 = layoutInterval2;
        }
        if (layoutInterval3 != null && layoutInterval3.getSubIntervalCount() > 1) {
            layoutInterval2 = layoutInterval3.getSubInterval(n3 == 0 ? 0 : layoutInterval3.getSubIntervalCount() - 1);
            LayoutInterval layoutInterval4 = LayoutInterval.getDirectNeighbor(layoutInterval2, n3 ^ 1, true);
            if (layoutInterval2 != null && layoutInterval2.isEmptySpace() && layoutInterval4 != null) {
                int n4 = layoutInterval2.getPreferredSize();
                if (n4 == -1) {
                    n4 = LayoutRegion.distance(layoutInterval.getCurrentSpace(), layoutInterval4.getCurrentSpace(), n2, n3, n3) * (n3 == 1 ? -1 : 1);
                }
                if (n4 >= n) {
                    if (n4 > n) {
                        this.resizeInterval(layoutInterval2, n4 - n);
                    } else {
                        this.layoutModel.removeInterval(layoutInterval2);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    LayoutInterval insertGap(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n, int n2, int n3) {
        LayoutInterval layoutInterval3;
        assert (n3 == 0 || n3 == 1);
        assert (!layoutInterval2.isSequential());
        assert (layoutInterval.isEmptySpace());
        LayoutInterval layoutInterval4 = layoutInterval2.getParent();
        if (layoutInterval4 == null) {
            assert (layoutInterval2.isParallel());
            layoutInterval4 = layoutInterval2;
            if (layoutInterval4.getSubIntervalCount() > 1) {
                layoutInterval3 = new LayoutInterval(102);
                layoutInterval3.getCurrentSpace().set(n2, n3 == 0 ? n : layoutInterval2.getCurrentSpace().positions[n2][0], n3 == 0 ? layoutInterval2.getCurrentSpace().positions[n2][1] : n);
                this.layoutModel.addInterval(layoutInterval3, layoutInterval4, -1);
                layoutInterval2 = new LayoutInterval(103);
                layoutInterval2.getCurrentSpace().set(n2, layoutInterval4.getCurrentSpace());
                this.layoutModel.addInterval(layoutInterval2, layoutInterval3, 0);
                while (layoutInterval4.getSubIntervalCount() > 1) {
                    this.layoutModel.addInterval(this.layoutModel.removeInterval(layoutInterval4, 0), layoutInterval2, -1);
                }
                layoutInterval4 = layoutInterval3;
            } else {
                layoutInterval2 = layoutInterval4.getSubInterval(0);
                if (layoutInterval2.isSequential()) {
                    layoutInterval4 = layoutInterval2;
                    int n4 = n3 == 0 ? 0 : layoutInterval4.getSubIntervalCount() - 1;
                    if ((layoutInterval2 = layoutInterval4.getSubInterval(n4)).isEmptySpace()) {
                        LayoutInterval layoutInterval5 = (n4 += n3 == 0 ? 1 : -1) >= 0 && n4 < layoutInterval4.getSubIntervalCount() ? layoutInterval4.getSubInterval(n4) : null;
                        int[] nArray = layoutInterval4.getParent().getCurrentSpace().positions[n2];
                        int n5 = layoutInterval5 != null ? layoutInterval5.getCurrentSpace().positions[n2][n3] : nArray[n3 ^ 1];
                        int n6 = (nArray[n3] - n5) * (n3 == 0 ? -1 : 1);
                        this.eatGap(layoutInterval2, layoutInterval, n6);
                        return layoutInterval5 != null ? layoutInterval5 : layoutInterval2;
                    }
                } else {
                    layoutInterval3 = new LayoutInterval(102);
                    layoutInterval3.getCurrentSpace().set(n2, n3 == 0 ? n : layoutInterval2.getCurrentSpace().positions[n2][0], n3 == 0 ? layoutInterval2.getCurrentSpace().positions[n2][1] : n);
                    this.layoutModel.addInterval(layoutInterval3, layoutInterval4, -1);
                    this.layoutModel.removeInterval(layoutInterval2);
                    this.layoutModel.addInterval(layoutInterval2, layoutInterval3, -1);
                    layoutInterval4 = layoutInterval3;
                }
            }
        }
        if (layoutInterval4.isSequential()) {
            layoutInterval3 = LayoutInterval.getDirectNeighbor(layoutInterval2, n3, false);
            if (layoutInterval3 != null && layoutInterval3.isEmptySpace()) {
                LayoutInterval layoutInterval6 = LayoutInterval.getDirectNeighbor(layoutInterval3, n3, false);
                int n7 = layoutInterval6 != null ? layoutInterval6.getCurrentSpace().positions[n2][n3 ^ 1] : layoutInterval4.getCurrentSpace().positions[n2][n3];
                int n8 = (n - n7) * (n3 == 0 ? 1 : -1);
                this.eatGap(layoutInterval3, layoutInterval, n8);
            } else {
                int n9 = layoutInterval4.indexOf(layoutInterval2) + (n3 == 0 ? 0 : 1);
                this.layoutModel.addInterval(layoutInterval, layoutInterval4, n9);
            }
        } else {
            layoutInterval3 = new LayoutInterval(102);
            int n10 = this.layoutModel.removeInterval(layoutInterval2);
            layoutInterval3.setAlignment(layoutInterval2.getAlignment());
            layoutInterval3.getCurrentSpace().set(n2, n3 == 0 ? n : layoutInterval2.getCurrentSpace().positions[n2][0], n3 == 0 ? layoutInterval2.getCurrentSpace().positions[n2][1] : n);
            this.layoutModel.addInterval(layoutInterval3, layoutInterval4, n10);
            this.layoutModel.setIntervalAlignment(layoutInterval2, -1);
            this.layoutModel.addInterval(layoutInterval2, layoutInterval3, 0);
            this.layoutModel.addInterval(layoutInterval, layoutInterval3, n3 == 0 ? 0 : 1);
        }
        return layoutInterval2;
    }

    int insertGapIntoSequence(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n, int n2) {
        assert (layoutInterval.isEmptySpace());
        LayoutInterval layoutInterval3 = null;
        int n3 = -1;
        if (n >= 0 && n < layoutInterval2.getSubIntervalCount() && (layoutInterval3 = layoutInterval2.getSubInterval(n)).isEmptySpace()) {
            n3 = 1;
        }
        if (n3 == -1 && n > 0 && (layoutInterval3 = layoutInterval2.getSubInterval(n - 1)).isEmptySpace()) {
            n3 = 0;
        }
        if (n3 == -1) {
            this.layoutModel.addInterval(layoutInterval, layoutInterval2, n);
            return n;
        }
        LayoutInterval layoutInterval4 = LayoutInterval.getDirectNeighbor(layoutInterval3, n3, true);
        int n4 = layoutInterval4 != null ? layoutInterval4.getCurrentSpace().positions[n2][n3 ^ 1] : layoutInterval2.getCurrentSpace().positions[n2][n3];
        layoutInterval4 = LayoutInterval.getDirectNeighbor(layoutInterval3, n3 ^ 1, true);
        int n5 = layoutInterval4 != null ? layoutInterval4.getCurrentSpace().positions[n2][n3] : layoutInterval2.getCurrentSpace().positions[n2][n3 ^ 1];
        this.eatGap(layoutInterval3, layoutInterval, Math.abs(n5 - n4));
        return n3 == 0 ? n - 1 : n;
    }

    void eatGap(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        int n2;
        int n3 = layoutInterval.getMinimumSize();
        if (n3 == -2) {
            n3 = layoutInterval.getPreferredSize();
        }
        if ((n2 = layoutInterval2.getMinimumSize()) == -2) {
            n2 = layoutInterval2.getPreferredSize();
        }
        int n4 = n3 == 0 ? n2 : (n2 == 0 ? n3 : (!LayoutInterval.canResize(layoutInterval) && !LayoutInterval.canResize(layoutInterval2) ? -2 : (n3 == -1 || n2 == -1 ? -1 : n3 + n2)));
        int n5 = layoutInterval.getPreferredSize();
        int n6 = layoutInterval2.getPreferredSize();
        int n7 = n5 == 0 ? n6 : (n6 == 0 ? n5 : (n5 == -1 || n6 == -1 ? n : n5 + n6));
        int n8 = layoutInterval.getMaximumSize() >= Short.MAX_VALUE || layoutInterval2.getMaximumSize() >= Short.MAX_VALUE ? Short.MAX_VALUE : -2;
        this.layoutModel.setIntervalSize(layoutInterval, n4, n7, n8);
        if (layoutInterval2.getParent() != null) {
            this.layoutModel.removeInterval(layoutInterval2);
        }
    }

    void mergeAdjacentGaps(Set<LayoutComponent> set) {
        Iterator iterator = this.layoutModel.getAllComponents();
        while (iterator.hasNext()) {
            LayoutComponent layoutComponent = (LayoutComponent)iterator.next();
            if (!layoutComponent.isLayoutContainer()) continue;
            boolean bl = false;
            for (LayoutInterval[] layoutIntervalArray : layoutComponent.getLayoutRoots()) {
                for (int i = 0; i < 2; ++i) {
                    bl = this.mergeAdjacentGaps(layoutIntervalArray[i], i) || bl;
                }
            }
            if (!bl) continue;
            set.add(layoutComponent);
        }
    }

    boolean mergeAdjacentGaps(LayoutInterval layoutInterval, int n) {
        LayoutInterval layoutInterval2;
        assert (layoutInterval.isGroup());
        boolean bl = false;
        if (layoutInterval.isSequential()) {
            for (int i = 0; i < layoutInterval.getSubIntervalCount(); ++i) {
                LayoutInterval layoutInterval3;
                LayoutInterval layoutInterval4;
                layoutInterval2 = layoutInterval.getSubInterval(i);
                if (!layoutInterval2.isEmptySpace() || i + 1 >= layoutInterval.getSubIntervalCount() || !(layoutInterval4 = layoutInterval.getSubInterval(i + 1)).isEmptySpace()) continue;
                if (i + 2 < layoutInterval.getSubIntervalCount() && (layoutInterval3 = layoutInterval.getSubInterval(i + 2)).isEmptySpace()) {
                    --i;
                }
                bl = true;
                this.eatGap(layoutInterval2, layoutInterval4, -1);
            }
        }
        Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            layoutInterval2 = iterator.next();
            if (!layoutInterval2.isGroup()) continue;
            bl = bl || this.mergeAdjacentGaps(layoutInterval2, n);
        }
        return bl;
    }

    void suppressResizingOfSurroundingGaps(LayoutInterval layoutInterval) {
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        while (layoutInterval2 != null) {
            if (layoutInterval2.isSequential()) {
                Iterator<LayoutInterval> iterator = layoutInterval2.getSubIntervals();
                while (iterator.hasNext()) {
                    LayoutInterval layoutInterval3 = iterator.next();
                    if (layoutInterval3 == layoutInterval || !layoutInterval3.isEmptySpace() || !LayoutInterval.canResize(layoutInterval3)) continue;
                    int n = layoutInterval3.getPreferredSize();
                    int n2 = layoutInterval3.getMinimumSize() != n ? -2 : n;
                    int n3 = -2;
                    this.layoutModel.setIntervalSize(layoutInterval3, n2, n, n3);
                }
            } else if (!LayoutInterval.canResize(layoutInterval2)) break;
            layoutInterval = layoutInterval2;
            layoutInterval2 = layoutInterval.getParent();
        }
    }
}

