/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class J2SELibrarySourceLevelQueryImpl
implements SourceLevelQueryImplementation {
    private static final String JDK_12 = "1.2";
    private static final String JDK_13 = "1.3";
    private static final String JDK_14 = "1.4";
    private static final String JDK_15 = "1.5";
    private static final String JDK_UNKNOWN = "";
    private static final String CLASS = "class";
    private static final int CF_MAGIC = -889275714;
    private static final int CF_INVALID = -1;
    private static final int CF_11 = 45;
    private static final int CF_12 = 46;
    private static final int CF_13 = 47;
    private static final int CF_14 = 48;
    private static final int CF_15 = 49;
    private Map<Library, String> sourceLevelCache = new WeakHashMap<Library, String>();
    private Reference<FileObject> lastUsedRoot;
    private Reference<Library> lastUsedLibrary;

    public String getSourceLevel(FileObject fileObject) {
        Library library = this.isLastUsed(fileObject);
        if (library != null) {
            return this.getSourceLevel(library);
        }
        for (LibraryManager libraryManager : LibraryManager.getOpenManagers()) {
            for (Library library2 : libraryManager.getLibraries()) {
                ClassPath classPath;
                FileObject fileObject2;
                List list;
                if (!library2.getType().equals("j2se") || (list = library2.getContent("src")).isEmpty() || (fileObject2 = (classPath = ClassPathSupport.createClassPath((URL[])list.toArray(new URL[list.size()]))).findOwnerRoot(fileObject)) == null) continue;
                this.setLastUsedRoot(fileObject2, library2);
                return this.getSourceLevel(library2);
            }
        }
        return null;
    }

    private String getSourceLevel(Library library) {
        String string = this.sourceLevelCache.get(library);
        if (string == null) {
            string = this.getSourceLevel(library.getContent("classpath"));
            this.sourceLevelCache.put(library, string);
        }
        return string == JDK_UNKNOWN ? null : string;
    }

    private String getSourceLevel(List list) {
        FileObject fileObject = this.getClassFile(list);
        if (fileObject == null) {
            return JDK_UNKNOWN;
        }
        int n = this.getClassFileMajorVersion(fileObject);
        if (n == 45 || n == 46) {
            return JDK_12;
        }
        if (n == 47) {
            return JDK_13;
        }
        if (n == 48) {
            return JDK_14;
        }
        if (n >= 49) {
            return JDK_15;
        }
        return JDK_UNKNOWN;
    }

    private FileObject getClassFile(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject;
            FileObject fileObject2 = URLMapper.findFileObject((URL)((URL)iterator.next()));
            if (fileObject2 == null || (fileObject = this.findClassFile(fileObject2)) == null) continue;
            return fileObject;
        }
        return null;
    }

    private FileObject findClassFile(FileObject fileObject) {
        if (fileObject.isData()) {
            if (CLASS.equals(fileObject.getExt())) {
                return fileObject;
            }
            return null;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = this.findClassFile(fileObjectArray[i]);
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getClassFileMajorVersion(FileObject fileObject) {
        short s;
        DataInputStream dataInputStream = null;
        try {
            short s2;
            dataInputStream = new DataInputStream(fileObject.getInputStream());
            int n = dataInputStream.readInt();
            if (-889275714 != n) {
                int n2 = -1;
                return n2;
            }
            short s3 = dataInputStream.readShort();
            s = s2 = dataInputStream.readShort();
        }
        catch (IOException iOException) {
            int n = -1;
            return n;
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return s;
    }

    private synchronized void setLastUsedRoot(FileObject fileObject, Library library) {
        this.lastUsedRoot = new SoftReference<FileObject>(fileObject);
        this.lastUsedLibrary = new WeakReference<Library>(library);
    }

    private synchronized Library isLastUsed(FileObject fileObject) {
        if (this.lastUsedRoot == null) {
            return null;
        }
        FileObject fileObject2 = this.lastUsedRoot.get();
        if (fileObject2 == null) {
            return null;
        }
        if (fileObject2.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
            return this.lastUsedLibrary.get();
        }
        return null;
    }
}

