/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.io.CharConversionException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.openide.awt.HtmlRenderer;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomizerComponentFactory {
    public static final String WAIT_VALUE = NbBundle.getMessage(CustomizerComponentFactory.class, (String)"ComponentFactory_please_wait");
    public static final String EMPTY_VALUE = NbBundle.getMessage(CustomizerComponentFactory.class, (String)"LBL_Empty");
    static DependencyListModel INVALID_DEP_LIST_MODEL;
    private static final String INVALID_PLATFORM;

    private CustomizerComponentFactory() {
    }

    public static ComboBoxModel createComboWaitModel() {
        return new DefaultComboBoxModel<Object>(new Object[]{WAIT_VALUE});
    }

    public static ComboBoxModel createComboEmptyModel() {
        return new DefaultComboBoxModel<Object>(new Object[]{EMPTY_VALUE});
    }

    public static boolean isWaitModel(ListModel listModel) {
        if (listModel instanceof DependencyListModel) {
            return ((DependencyListModel)listModel).isWaiting();
        }
        return CustomizerComponentFactory.hasOnlyValue(listModel, WAIT_VALUE);
    }

    public static boolean hasOnlyValue(ListModel listModel, Object object) {
        return listModel != null && listModel.getSize() == 1 && listModel.getElementAt(0) == object;
    }

    public static ListModel createListWaitModel() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(WAIT_VALUE);
        return defaultListModel;
    }

    static DependencyListModel createSortedDependencyListModel(Set<ModuleDependency> set) {
        assert (set != null);
        return new DependencyListModel(set, true);
    }

    static DependencyListModel createDependencyListModel(Set<ModuleDependency> set) {
        assert (set != null);
        return new DependencyListModel(set, false);
    }

    static synchronized DependencyListModel getInvalidDependencyListModel() {
        if (INVALID_DEP_LIST_MODEL == null) {
            INVALID_DEP_LIST_MODEL = new DependencyListModel(DependencyListModel.State.INVALID, true);
        }
        return INVALID_DEP_LIST_MODEL;
    }

    static ListCellRenderer getDependencyCellRenderer(boolean bl) {
        return new DependencyListCellRenderer(bl);
    }

    static ListCellRenderer getModuleCellRenderer() {
        return new ProjectListCellRenderer();
    }

    static ListCellRenderer getModuleEntryCellRenderer() {
        return new ModuleEntryListCellRenderer();
    }

    static {
        INVALID_PLATFORM = "<html><font color=\"!nb.errorForeground\">&lt;" + NbBundle.getMessage(CustomizerComponentFactory.class, (String)"MSG_InvalidPlatform") + "&gt;</font></html>";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SuiteSubModulesListModel
    extends AbstractListModel {
        private final SortedSet<NbModuleProject> subModules = new TreeSet<Project>(Util.projectDisplayNameComparator());
        private boolean changed;

        SuiteSubModulesListModel(Set<NbModuleProject> set) {
            this.subModules.addAll(set);
        }

        @Override
        public int getSize() {
            return this.subModules.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.subModules.toArray()[n];
        }

        boolean contains(Project project) {
            return this.subModules.contains(project);
        }

        void removeModules(Collection collection) {
            int n = this.subModules.size();
            this.subModules.removeAll(collection);
            this.changed = true;
            this.fireContentsChanged(this, 0, n);
        }

        boolean addModule(NbModuleProject nbModuleProject) {
            int n = this.subModules.size();
            boolean bl = this.subModules.add(nbModuleProject);
            this.changed = true;
            this.fireContentsChanged(this, 0, n + 1);
            return bl;
        }

        public Set<NbModuleProject> getSubModules() {
            return Collections.unmodifiableSortedSet(this.subModules);
        }

        public boolean isChanged() {
            return this.changed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RequiredTokenListModel
    extends AbstractListModel {
        private final SortedSet<String> tokens;
        private boolean changed;

        RequiredTokenListModel(SortedSet<String> sortedSet) {
            this.tokens = new TreeSet<String>(sortedSet);
        }

        @Override
        public Object getElementAt(int n) {
            return n >= this.tokens.size() ? null : this.tokens.toArray()[n];
        }

        @Override
        public int getSize() {
            return this.tokens.size();
        }

        void addToken(String string) {
            this.tokens.add(string);
            this.changed = true;
            super.fireIntervalAdded(this, 0, this.tokens.size());
        }

        void removeToken(String string) {
            this.tokens.remove(string);
            this.changed = true;
            super.fireIntervalRemoved(this, 0, this.tokens.size());
        }

        String[] getTokens() {
            String[] stringArray = new String[this.tokens.size()];
            return this.tokens.toArray(stringArray);
        }

        boolean isChanged() {
            return this.changed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FriendListModel
    extends AbstractListModel {
        private final Set<String> friends = new TreeSet<String>();
        private boolean changed;

        FriendListModel(String[] stringArray) {
            if (stringArray != null) {
                this.friends.addAll(Arrays.asList(stringArray));
            }
        }

        @Override
        public Object getElementAt(int n) {
            if (n >= this.friends.size()) {
                return null;
            }
            return this.friends.toArray()[n];
        }

        @Override
        public int getSize() {
            return this.friends.size();
        }

        void addFriend(String string) {
            this.friends.add(string);
            this.changed = true;
            super.fireIntervalAdded(this, 0, this.friends.size());
        }

        void removeFriend(String string) {
            this.friends.remove(string);
            this.changed = true;
            super.fireIntervalRemoved(this, 0, this.friends.size());
        }

        Set<String> getFriends() {
            return Collections.unmodifiableSet(this.friends);
        }

        boolean isChanged() {
            return this.changed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PublicPackagesTableModel
    extends AbstractTableModel {
        private Boolean[] selected;
        private Boolean[] originalSelected;
        private String[] pkgNames;

        PublicPackagesTableModel(Map<String, Boolean> map) {
            this.reloadData(map);
        }

        void reloadData(Map<String, Boolean> map) {
            this.selected = new Boolean[map.size()];
            map.values().toArray(this.selected);
            if (this.originalSelected == null) {
                this.originalSelected = new Boolean[map.size()];
                System.arraycopy(this.selected, 0, this.originalSelected, 0, this.selected.length);
            }
            this.pkgNames = new String[map.size()];
            map.keySet().toArray(this.pkgNames);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.pkgNames.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.selected[n];
            }
            return this.pkgNames[n];
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            assert (n2 == 0) : "Who is trying to modify second column?";
            this.selected[n] = (Boolean)object;
            this.fireTableCellUpdated(n, 0);
        }

        Set<String> getSelectedPackages() {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (int i = 0; i < this.pkgNames.length; ++i) {
                if (!this.selected[i].booleanValue()) continue;
                treeSet.add(this.pkgNames[i]);
            }
            return treeSet;
        }

        public boolean isChanged() {
            return !((Object)Arrays.asList(this.selected)).equals(Arrays.asList(this.originalSelected));
        }
    }

    private static class ModuleEntryListCellRenderer
    extends DefaultListCellRenderer {
        private ModuleEntryListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ModuleEntry moduleEntry = (ModuleEntry)object;
            Component component = super.getListCellRendererComponent((JList<?>)jList, moduleEntry.getLocalizedName(), n, bl, bl2);
            return component;
        }
    }

    private static class ProjectListCellRenderer
    extends DefaultListCellRenderer {
        private ProjectListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, ProjectUtils.getInformation((Project)((Project)object)).getDisplayName(), n, bl, bl2);
            return component;
        }
    }

    private static final class DependencyListCellRenderer
    implements ListCellRenderer {
        private final HtmlRenderer.Renderer renderer = HtmlRenderer.createRenderer();
        private final boolean boldfaceApiModules;

        public DependencyListCellRenderer(boolean bl) {
            this.boldfaceApiModules = bl;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            if (object == WAIT_VALUE) {
                string = WAIT_VALUE;
            } else if (object == INVALID_PLATFORM) {
                string = INVALID_PLATFORM;
                this.renderer.setHtml(true);
            } else {
                String string2;
                ModuleDependency moduleDependency = (ModuleDependency)object;
                boolean bl3 = this.boldfaceApiModules && moduleDependency.getModuleEntry().getPublicPackages().length > 0;
                boolean bl4 = moduleDependency.getModuleEntry().isDeprecated();
                this.renderer.setHtml(bl3 || bl4);
                string = string2 = moduleDependency.getModuleEntry().getLocalizedName();
                if (bl3 || bl4) {
                    try {
                        string = "<html>" + (bl3 ? "<b>" : "") + (bl4 ? "<s>" : "") + XMLUtil.toElementContent((String)string2);
                    }
                    catch (CharConversionException charConversionException) {
                        // empty catch block
                    }
                }
            }
            return this.renderer.getListCellRendererComponent(jList, (Object)string, n, bl, bl2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DependencyListModel
    extends AbstractListModel {
        private final Set<ModuleDependency> currentDeps;
        private boolean changed;
        private State state;

        DependencyListModel(Set<ModuleDependency> set, boolean bl) {
            if (bl) {
                this.currentDeps = new TreeSet<ModuleDependency>(ModuleDependency.LOCALIZED_NAME_COMPARATOR);
                this.currentDeps.addAll(set);
            } else {
                this.currentDeps = set;
            }
            this.state = State.OK;
        }

        private DependencyListModel(State state, boolean bl) {
            this.currentDeps = state == State.INVALID ? Collections.emptySet() : (bl ? new TreeSet<ModuleDependency>(ModuleDependency.LOCALIZED_NAME_COMPARATOR) : new HashSet<ModuleDependency>());
            this.state = state;
        }

        @Override
        public int getSize() {
            return this.state != State.OK ? 1 : this.currentDeps.size();
        }

        @Override
        public Object getElementAt(int n) {
            switch (this.state) {
                case OK: {
                    return this.currentDeps.toArray()[n];
                }
                case INVALID: {
                    return INVALID_PLATFORM;
                }
            }
            return WAIT_VALUE;
        }

        public static DependencyListModel createBgWaitModel(boolean bl) {
            return new DependencyListModel(State.WAITING, bl);
        }

        void setDependencies(SortedSet<ModuleDependency> sortedSet) {
            if (this.state != State.WAITING) {
                throw new IllegalStateException("Method can be called only on model waiting for bg thread to populate it.");
            }
            this.currentDeps.addAll(sortedSet);
            this.state = State.OK;
            int n = this.currentDeps.size();
            this.fireContentsChanged(this, 0, n);
        }

        void setInvalid() {
            if (this.state == State.INVALID) {
                throw new IllegalStateException("DependencyListModel already marked 'invalid'.");
            }
            this.state = State.INVALID;
            int n = this.currentDeps.size();
            this.fireContentsChanged(this, 0, n);
        }

        boolean isWaiting() {
            return this.state == State.WAITING;
        }

        ModuleDependency getDependency(int n) {
            return (ModuleDependency)this.getElementAt(n);
        }

        void addDependency(ModuleDependency moduleDependency) {
            if (!this.currentDeps.contains(moduleDependency)) {
                int n = this.currentDeps.size();
                this.currentDeps.add(moduleDependency);
                this.changed = true;
                this.fireContentsChanged(this, 0, n);
            }
        }

        void removeDependencies(Collection<ModuleDependency> collection) {
            int n = this.currentDeps.size();
            this.currentDeps.removeAll(collection);
            this.changed = true;
            this.fireContentsChanged(this, 0, n);
        }

        void editDependency(ModuleDependency moduleDependency, ModuleDependency moduleDependency2) {
            this.currentDeps.remove(moduleDependency);
            this.currentDeps.add(moduleDependency2);
            this.changed = true;
            this.fireContentsChanged(this, 0, this.currentDeps.size());
        }

        Set<ModuleDependency> getDependencies() {
            return Collections.unmodifiableSet(this.currentDeps);
        }

        boolean isChanged() {
            return this.changed;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            INVALID,
            WAITING,
            OK;

        }
    }
}

