/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.mozilla.nb.javascript.Node;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.javascript.hints.MoreInfoFix;
import org.netbeans.modules.javascript.hints.infrastructure.JsAstRule;
import org.netbeans.modules.javascript.hints.infrastructure.JsRuleContext;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicodeConvert
extends JsAstRule {
    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    @Override
    public Set<Integer> getKinds() {
        return Collections.singleton(41);
    }

    @Override
    public void run(JsRuleContext jsRuleContext, List<Hint> list) {
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)jsRuleContext.parserResult);
        Node node = jsRuleContext.node;
        String string = node.getString();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            BaseDocument baseDocument;
            char c = string.charAt(i);
            if (c < '\u0100') continue;
            OffsetRange offsetRange = AstUtilities.getRange((Node)node);
            int n2 = LexUtilities.getLexerOffset((JsParseResult)jsParseResult, (int)offsetRange.getStart());
            if (n2 == -1) {
                return;
            }
            try {
                char c2;
                baseDocument = jsRuleContext.doc;
                ++n2;
                if ((n2 += i) < baseDocument.getLength() && (c2 = baseDocument.getText(n2, 1).charAt(0)) != c) {
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            baseDocument = new OffsetRange(n2, n2 + 1);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(new ConvertFix(jsRuleContext, n2, c));
            arrayList.add(new MoreInfoFix("unicodeconvert"));
            String string2 = this.getDisplayName();
            Hint hint = new Hint((Rule)this, string2, jsParseResult.getSnapshot().getSource().getFileObject(), (OffsetRange)baseDocument, arrayList, 1500);
            list.add(hint);
        }
    }

    public String getId() {
        return "UnicodeConvert";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UnicodeConvert.class, (String)"UnicodeConvert");
    }

    public String getDescription() {
        return NbBundle.getMessage(UnicodeConvert.class, (String)"UnicodeConvertDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private static class ConvertFix
    implements PreviewableFix {
        private final JsRuleContext context;
        private final int lexOffset;
        private final char c;

        ConvertFix(JsRuleContext jsRuleContext, int n, char c) {
            this.context = jsRuleContext;
            this.lexOffset = n;
            this.c = c;
        }

        private String getConverted() {
            StringBuilder stringBuilder = new StringBuilder();
            Formatter formatter = new Formatter(stringBuilder);
            formatter.format("\\u%04x", this.c);
            return stringBuilder.toString();
        }

        public String getDescription() {
            String string = this.getConverted();
            return NbBundle.getMessage(UnicodeConvert.class, (String)"UnicodeConvertFix", (Object)Character.valueOf(this.c), (Object)string);
        }

        public boolean canPreview() {
            return true;
        }

        public EditList getEditList() throws Exception {
            BaseDocument baseDocument = this.context.doc;
            EditList editList = new EditList(baseDocument);
            editList.replace(this.lexOffset, 1, this.getConverted(), false, 0);
            return editList;
        }

        public void implement() throws Exception {
            EditList editList = this.getEditList();
            editList.apply();
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

