/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.impl.SchemaImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.schema.model.impl.Util;
import org.netbeans.modules.xml.schema.model.impl.resolver.MultivalueMap;
import org.netbeans.modules.xml.schema.model.impl.resolver.ResolveSession;
import org.netbeans.modules.xml.xam.NamedReferenceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeResolver {
    public static <T extends NamedReferenceable> T resolve(SchemaModelImpl schemaModelImpl, String string, String string2, Class<T> clazz) {
        ResolveSession resolveSession = new ResolveSession(schemaModelImpl, string);
        T t = null;
        t = IncludeResolver.resolveRecursiveDown(schemaModelImpl, string2, clazz, resolveSession);
        if (t != null) {
            return t;
        }
        t = IncludeResolver.resolveUpwards(schemaModelImpl, string, string2, clazz, resolveSession);
        if (t != null) {
            return t;
        }
        return null;
    }

    static <T extends NamedReferenceable> T resolveRecursiveDown(SchemaModelImpl schemaModelImpl, String string, Class<T> clazz, ResolveSession resolveSession) {
        T t = null;
        ResolveSession.Checked checked = resolveSession.getChecked(schemaModelImpl);
        if (!checked.itself) {
            t = schemaModelImpl.findByNameAndType(string, clazz);
            if (t != null) {
                return t;
            }
            checked.itself = true;
        }
        if (!checked.included) {
            checked.included = true;
            Collection<SchemaModelReference> collection = schemaModelImpl.getNotImportRefrences();
            for (SchemaModelReference schemaModelReference : collection) {
                assert (!(schemaModelReference instanceof Import));
                SchemaModelImpl schemaModelImpl2 = schemaModelImpl.resolve(schemaModelReference);
                if (schemaModelImpl2 == null || (t = (T)IncludeResolver.resolveRecursiveDown(schemaModelImpl2, string, clazz, resolveSession)) == null) continue;
                return t;
            }
        }
        return null;
    }

    static <T extends NamedReferenceable> T resolveUpwards(SchemaModelImpl schemaModelImpl, String string, String string2, Class<T> clazz, ResolveSession resolveSession) {
        Set<SchemaModelImpl> set = IncludeResolver.getMegaIncludedModels(schemaModelImpl, string, resolveSession);
        for (SchemaModelImpl schemaModelImpl2 : set) {
            ResolveSession.Checked checked = resolveSession.getChecked(schemaModelImpl2);
            if (schemaModelImpl2 == null || checked.itself) continue;
            T t = schemaModelImpl2.findByNameAndType(string2, clazz);
            if (t != null) {
                return t;
            }
            checked.itself = true;
        }
        return null;
    }

    static Set<SchemaModelImpl> getMegaIncludedModels(SchemaModelImpl schemaModelImpl, String string, ResolveSession resolveSession) {
        SchemaImpl schemaImpl = schemaModelImpl.getSchema();
        if (schemaImpl == null) {
            return Collections.EMPTY_SET;
        }
        String string2 = schemaImpl.getTargetNamespace();
        if (string2 != null && !Util.equal(string, string2)) {
            return Collections.EMPTY_SET;
        }
        MultivalueMap.BidirectionalGraph<SchemaModelImpl> bidirectionalGraph = resolveSession.getInclusionGraph(schemaModelImpl, string);
        if (bidirectionalGraph.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Set<SchemaModelImpl> set = bidirectionalGraph.getRoots(schemaModelImpl, false);
        HashSet<SchemaModelImpl> hashSet = new HashSet<SchemaModelImpl>();
        for (SchemaModelImpl schemaModelImpl2 : set) {
            if (!Util.equal(schemaModelImpl2.getSchema().getTargetNamespace(), string)) continue;
            MultivalueMap.Utils.populateAllSubItems(bidirectionalGraph, schemaModelImpl2, schemaModelImpl, hashSet);
        }
        hashSet.remove(schemaModelImpl);
        return hashSet;
    }
}

