/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.editor.Registry;
import org.netbeans.lib.profiler.ui.components.ThinBevelBorder;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsWindow;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ToggleProfilingPointAction
extends AbstractAction
implements AWTEventListener {
    private static final String ACTION_NAME = NbBundle.getMessage(ToggleProfilingPointAction.class, (String)"ToggleProfilingPointAction_ActionName");
    private static final String ACTION_DESCR = NbBundle.getMessage(ToggleProfilingPointAction.class, (String)"ToggleProfilingPointAction_ActionDescr");
    private static final String PROFILING_PROGRESS_MSG = NbBundle.getMessage(ToggleProfilingPointAction.class, (String)"ToggleProfilingPointAction_ProfilingProgressMsg");
    private static final String BAD_SOURCE_MSG = NbBundle.getMessage(ToggleProfilingPointAction.class, (String)"ToggleProfilingPointAction_BadSourceMsg");
    private static final String CANCEL_STRING = NbBundle.getMessage(ToggleProfilingPointAction.class, (String)"ToggleProfilingPointAction_CancelString");
    private static final String SWITCHER_WINDOW_CAPTION = NbBundle.getMessage(ToggleProfilingPointAction.class, (String)"ToggleProfilingPointAction_SwitcherWindowCaption");
    private static final String INVALID_SHORTCUT_MSG = NbBundle.getMessage(ToggleProfilingPointAction.class, (String)"ToggleProfilingPointAction_InvalidShortcutMsg");
    private static ToggleProfilingPointAction instance;
    private ProfilingPointsSwitcher ppSwitcher;
    private ProfilingPointFactory[] ppFactories;
    private boolean warningDialogOpened = false;
    private int currentFactory;
    private KeyStroke acceleratorKeyStroke;

    public ToggleProfilingPointAction() {
        this.putValue("Name", ACTION_NAME);
        this.putValue("ShortDescription", ACTION_DESCR);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public static synchronized ToggleProfilingPointAction getInstance() {
        if (instance == null) {
            instance = new ToggleProfilingPointAction();
        }
        return instance;
    }

    public boolean isEnabled() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.acceleratorKeyStroke = Utilities.stringToKey((String)actionEvent.getActionCommand());
        if (this.acceleratorKeyStroke == null || this.acceleratorKeyStroke.getModifiers() == 0) {
            NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(INVALID_SHORTCUT_MSG, ACTION_NAME));
            return;
        }
        if (this.warningDialogOpened) {
            return;
        }
        if (ProfilingPointsManager.getDefault().isProfilingSessionInProgress()) {
            this.warningDialogOpened = true;
            NetBeansProfiler.getDefaultNB().displayWarning(PROFILING_PROGRESS_MSG);
            this.warningDialogOpened = false;
            return;
        }
        if (Utils.getCurrentLocation(0).equals(CodeProfilingPoint.Location.EMPTY)) {
            this.warningDialogOpened = true;
            NetBeansProfiler.getDefaultNB().displayWarning(BAD_SOURCE_MSG);
            this.warningDialogOpened = false;
            return;
        }
        ProfilingPointsSwitcher profilingPointsSwitcher = this.getChooserFrame();
        if (profilingPointsSwitcher.isVisible()) {
            this.nextFactory();
            profilingPointsSwitcher.setProfilingPointFactory(this.currentFactory == this.ppFactories.length ? null : this.ppFactories[this.currentFactory], this.currentFactory);
        } else if (this.currentlyInEditor()) {
            this.resetFactories();
            profilingPointsSwitcher.setProfilingPointFactory(this.currentFactory == this.ppFactories.length ? null : this.ppFactories[this.currentFactory], this.currentFactory);
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
            profilingPointsSwitcher.setVisible(true);
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof KeyEvent)) {
            return;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent((KeyEvent)aWTEvent);
        if (this.acceleratorKeyStroke == null || keyStroke == null) {
            return;
        }
        int n = this.acceleratorKeyStroke.getModifiers();
        if (n == 0) {
            return;
        }
        if (n != keyStroke.getModifiers()) {
            this.modifierKeyStateChanged();
        }
    }

    private boolean currentlyInEditor() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        if (topComponent == null) {
            return false;
        }
        JTextComponent jTextComponent = Registry.getMostActiveComponent();
        if (jTextComponent == null) {
            return false;
        }
        Document document = jTextComponent.getDocument();
        if (document == null) {
            return false;
        }
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject == null || !fileObject.getExt().equalsIgnoreCase("java")) {
            return false;
        }
        TopComponent topComponent2 = NbEditorUtilities.getOuterTopComponent((JTextComponent)jTextComponent);
        if (topComponent2 == null) {
            return false;
        }
        return topComponent == topComponent2;
    }

    private synchronized ProfilingPointsSwitcher getChooserFrame() {
        if (this.ppSwitcher == null) {
            this.ppSwitcher = new ProfilingPointsSwitcher();
            this.ppSwitcher.addWindowListener(new WindowAdapter(){

                public void windowDeactivated(WindowEvent windowEvent) {
                    ToggleProfilingPointAction.this.ppSwitcher.setVisible(false);
                }
            });
        }
        return this.ppSwitcher;
    }

    private synchronized void modifierKeyStateChanged() {
        if (ProfilingPointsManager.getDefault().isProfilingSessionInProgress()) {
            return;
        }
        ProfilingPointsSwitcher profilingPointsSwitcher = this.getChooserFrame();
        if (profilingPointsSwitcher.isVisible()) {
            ProfilingPoint profilingPoint;
            ProfilingPointFactory profilingPointFactory = profilingPointsSwitcher.getProfilingPointFactory();
            Project project = Utils.getCurrentProject();
            if (profilingPointFactory != null && project != null && (profilingPoint = profilingPointFactory.create(project)) != null) {
                ProfilingPointsManager.getDefault().addProfilingPoint(profilingPoint);
                if (profilingPoint instanceof GlobalProfilingPoint) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (!ProfilingPointsWindow.getDefault().isOpened()) {
                                ProfilingPointsWindow.getDefault().open();
                                ProfilingPointsWindow.getDefault().requestVisible();
                            }
                        }
                    });
                }
                profilingPoint.customize();
            }
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        profilingPointsSwitcher.setVisible(false);
    }

    private void nextFactory() {
        ++this.currentFactory;
        if (this.currentFactory > this.ppFactories.length) {
            this.currentFactory = 0;
        }
    }

    private void resetFactories() {
        if (this.ppFactories == null) {
            this.ppFactories = ProfilingPointsManager.getDefault().getProfilingPointFactories();
            this.getChooserFrame().initPanel(this.ppFactories);
        }
        this.currentFactory = 0;
    }

    static /* synthetic */ String access$000() {
        return CANCEL_STRING;
    }

    private static class ProfilingPointsSwitcher
    extends JFrame {
        private static final String NO_ACTION_NAME = ToggleProfilingPointAction.access$000();
        private static final Icon NO_ACTION_ICON = null;
        private Dimension size;
        private JLabel label;
        private JPanel previewPanel;
        private ProfilingPointFactory ppFactory;

        public ProfilingPointsSwitcher() {
            super(SWITCHER_WINDOW_CAPTION);
            this.initProperties();
            this.initComponents();
            this.setProfilingPointFactory(null, -1);
        }

        public void setProfilingPointFactory(ProfilingPointFactory profilingPointFactory, int n) {
            this.ppFactory = profilingPointFactory;
            if (profilingPointFactory != null) {
                this.label.setText(profilingPointFactory.getType());
                this.label.setIcon(profilingPointFactory.getIcon());
            } else {
                this.label.setText(NO_ACTION_NAME);
                this.label.setIcon(NO_ACTION_ICON);
            }
            Component component = null;
            if (n >= 0 && n < this.previewPanel.getComponentCount()) {
                component = this.previewPanel.getComponent(n);
            }
            for (Component component2 : this.previewPanel.getComponents()) {
                if (component2 == component) {
                    Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
                    MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, SystemColor.textHighlight);
                    Border border2 = BorderFactory.createEmptyBorder(0, 2, 0, 2);
                    CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, matteBorder);
                    CompoundBorder compoundBorder2 = BorderFactory.createCompoundBorder(compoundBorder, border);
                    ((JComponent)component2).setBorder(compoundBorder2);
                    continue;
                }
                ((JComponent)component2).setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            }
        }

        public ProfilingPointFactory getProfilingPointFactory() {
            return this.ppFactory;
        }

        public void setVisible(boolean bl) {
            if (bl) {
                if (this.size == null) {
                    this.size = this.getSize();
                }
                TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
                Rectangle rectangle = topComponent.getBounds();
                Point point = new Point(rectangle.x + rectangle.width / 2 - this.size.width / 2, rectangle.y + rectangle.height / 2 - this.size.height / 2);
                SwingUtilities.convertPointToScreen(point, (Component)topComponent);
                this.setLocation(point);
            }
            super.setVisible(bl);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.previewPanel = new JPanel(new FlowLayout(0, 0, 3));
            this.previewPanel.setBorder(BorderFactory.createEmptyBorder(4, 7, 2, 7));
            this.label = new JLabel();
            this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 7, 7, 7), (Border)new ThinBevelBorder(1)));
            this.label.setBorder(BorderFactory.createCompoundBorder(this.label.getBorder(), BorderFactory.createEmptyBorder(4, 3, 4, 3)));
            this.label.setFont(this.label.getFont().deriveFont(1));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
            jPanel.add((Component)this.previewPanel, "North");
            jPanel.add((Component)this.label, "Center");
            this.add((Component)jPanel, "Center");
        }

        private void initPanel(ProfilingPointFactory[] profilingPointFactoryArray) {
            Dimension dimension = new Dimension(230, 0);
            for (int i = 0; i < profilingPointFactoryArray.length; ++i) {
                JLabel jLabel = new JLabel(profilingPointFactoryArray[i].getIcon());
                jLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
                this.previewPanel.add(jLabel);
                this.setProfilingPointFactory(profilingPointFactoryArray[i], i);
                this.pack();
                Dimension dimension2 = this.getPreferredSize();
                dimension = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
            }
            this.setProfilingPointFactory(null, profilingPointFactoryArray.length);
            this.setSize(dimension);
        }

        private void initProperties() {
            this.setAlwaysOnTop(true);
            this.setUndecorated(true);
            this.setResizable(false);
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                public void run() {
                    ProfilingPointsSwitcher.this.setIconImage(WindowManager.getDefault().getMainWindow().getIconImage());
                }
            });
        }
    }
}

