/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.StringWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.ThreadObjectGCRoot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.OverviewController;
import org.netbeans.modules.profiler.utils.GoToSourceHelper;
import org.netbeans.modules.profiler.utils.JavaSourceLocation;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import sun.misc.VM;

public class OverviewControllerUI
extends JTitledPanel {
    private static final String SHOW_SYSPROPS_URL = "file:/sysprops";
    private static final String SHOW_THREADS_URL = "file:/threads";
    private static final String OPEN_THREADS_URL = "file:/stackframe/";
    private static ImageIcon ICON_INFO = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/infoTab.png", (boolean)false);
    private static final String VIEW_TITLE = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_ViewTitle");
    private static final String VIEW_DESCR = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_ViewDescr");
    private static final String IN_PROGRESS_MSG = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_InProgressMsg");
    private static final String NOT_AVAILABLE_MSG = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_NotAvailableMsg");
    private static final String SYSTEM_PROPERTIES_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_SystemPropertiesString");
    private static final String SUMMARY_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_SummaryString");
    private static final String ENVIRONMENT_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_EnvironmentString");
    private static final String FILE_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_FileItemString");
    private static final String FILE_SIZE_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_FileSizeItemString");
    private static final String DATE_TAKEN_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_DateTakenItemString");
    private static final String TOTAL_BYTES_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_TotalBytesItemString");
    private static final String TOTAL_CLASSES_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_TotalClassesItemString");
    private static final String TOTAL_INSTANCES_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_TotalInstancesItemString");
    private static final String CLASSLOADERS_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_ClassloadersItemString");
    private static final String GCROOTS_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_GcRootsItemString");
    private static final String FINALIZERS_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_FinalizersItemString");
    private static final String OS_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_OsItemString");
    private static final String ARCHITECTURE_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_ArchitectureItemString");
    private static final String JAVA_HOME_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_JavaHomeItemString");
    private static final String JVM_ITEM_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_JvmItemString");
    private static final String SHOW_SYSPROPS_LINK_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_ShowSysPropsLinkString");
    private static final String THREADS_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_ThreadsString");
    private static final String SHOW_THREADS_LINK_STRING = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_ShowThreadsLinkString");
    private AbstractButton presenter;
    private HTMLTextArea dataArea;
    private Properties systemProperties;
    private HeapFragmentWalker heapFragmentWalker;
    private boolean systemPropertiesComputed = false;
    private boolean showSysprops = false;
    private boolean showThreads = false;
    private String stackTrace;

    public OverviewControllerUI(OverviewController overviewController) {
        super(VIEW_TITLE, (Icon)ICON_INFO, true);
        this.heapFragmentWalker = overviewController.getSummaryController().getHeapFragmentWalker();
        this.initComponents();
        this.refreshSummary();
    }

    private Properties getSystemProperties() {
        if (!this.systemPropertiesComputed) {
            this.systemProperties = this.heapFragmentWalker.getHeapFragment().getSystemProperties();
            this.systemPropertiesComputed = true;
        }
        return this.systemProperties;
    }

    private String computeEnvironment() {
        Properties properties = this.getSystemProperties();
        if (properties == null) {
            return NOT_AVAILABLE_MSG;
        }
        String string = properties.getProperty("sun.os.patch.level", "");
        String string2 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(OS_ITEM_STRING, properties.getProperty("os.name", NOT_AVAILABLE_MSG), properties.getProperty("os.version", ""), "unknown".equals(string) ? "" : string);
        String string3 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(ARCHITECTURE_ITEM_STRING, properties.getProperty("os.arch", NOT_AVAILABLE_MSG), properties.getProperty("sun.arch.data.model", "?") + "bit");
        String string4 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(JAVA_HOME_ITEM_STRING, properties.getProperty("java.home", NOT_AVAILABLE_MSG));
        String string5 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(JVM_ITEM_STRING, properties.getProperty("java.vm.name", NOT_AVAILABLE_MSG), properties.getProperty("java.vm.version", ""), properties.getProperty("java.vm.info", ""));
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/sysinfo.png'>&nbsp;&nbsp;" + ENVIRONMENT_STRING + "</b><br><hr>" + string2 + "<br>" + string3 + "<br>" + string4 + "<br>" + string5;
    }

    private String computeSummary() {
        Object object;
        Object object2;
        Object object3;
        File file = this.heapFragmentWalker.getHeapDumpFile();
        Heap heap = this.heapFragmentWalker.getHeapFragment();
        HeapSummary heapSummary = heap.getSummary();
        long l = this.computeFinalizers(heap);
        int n = 0;
        JavaClass javaClass = heap.getJavaClassByName("java.lang.ClassLoader");
        if (javaClass != null) {
            n = javaClass.getInstancesCount();
            object3 = javaClass.getSubClasses();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (JavaClass)object2.next();
                n += object.getInstancesCount();
            }
        }
        object3 = (NumberFormat)NumberFormat.getInstance().clone();
        ((NumberFormat)object3).setMaximumFractionDigits(1);
        object2 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FILE_ITEM_STRING, file != null && file.exists() ? file.getAbsolutePath() : NOT_AVAILABLE_MSG);
        object = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FILE_SIZE_ITEM_STRING, file != null && file.exists() ? ((NumberFormat)object3).format((double)file.length() / 1048576.0) + " MB" : NOT_AVAILABLE_MSG);
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(DATE_TAKEN_ITEM_STRING, new Date(heapSummary.getTime()).toString());
        String string2 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_BYTES_ITEM_STRING, ((NumberFormat)object3).format(heapSummary.getTotalLiveBytes()));
        String string3 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_CLASSES_ITEM_STRING, ((NumberFormat)object3).format(heap.getAllClasses().size()));
        String string4 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_INSTANCES_ITEM_STRING, ((NumberFormat)object3).format(heapSummary.getTotalLiveInstances()));
        String string5 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(CLASSLOADERS_ITEM_STRING, ((NumberFormat)object3).format(n));
        String string6 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(GCROOTS_ITEM_STRING, ((NumberFormat)object3).format(heap.getGCRoots().size()));
        String string7 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FINALIZERS_ITEM_STRING, ((NumberFormat)object3).format(l));
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/resources/memory.png'>&nbsp;&nbsp;" + SUMMARY_STRING + "</b><br><hr>" + string + "<br>" + (String)object2 + "<br>" + (String)object + "<br><br>" + string2 + "<br>" + string3 + "<br>" + string4 + "<br>" + string5 + "<br>" + string6 + "<br>" + string7;
    }

    private long computeFinalizers(Heap heap) {
        Long l;
        Instance instance;
        JavaClass javaClass = heap.getJavaClassByName("java.lang.ref.Finalizer");
        if (javaClass != null && (instance = (Instance)javaClass.getValueOfStaticField("queue")) != null && (l = (Long)instance.getValueOfField("queueLength")) != null) {
            return l;
        }
        return -1L;
    }

    private String computeSystemProperties(boolean bl) {
        Properties properties = this.getSystemProperties();
        if (properties == null) {
            return NOT_AVAILABLE_MSG;
        }
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/properties.png'>&nbsp;&nbsp;" + SYSTEM_PROPERTIES_STRING + "</b><br><hr>" + (bl ? this.formatSystemProperties(properties) : "&nbsp;&nbsp;&nbsp;&nbsp;<a href='file:/sysprops'>" + SHOW_SYSPROPS_LINK_STRING + "</a>");
    }

    private String computeThreads(boolean bl) {
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/resources/threadsWindow.png'>&nbsp;&nbsp;" + THREADS_STRING + "</b><br><hr>" + (bl ? this.getStackTrace() : "&nbsp;&nbsp;&nbsp;&nbsp;<a href='file:/threads'>" + SHOW_THREADS_LINK_STRING + "</a><br>&nbsp;");
    }

    private synchronized String getStackTrace() {
        if (this.stackTrace == null) {
            StringWriter stringWriter = new StringWriter();
            Heap heap = this.heapFragmentWalker.getHeapFragment();
            Collection collection = heap.getGCRoots();
            stringWriter.append("<pre>");
            for (GCRoot gCRoot : collection) {
                if (!gCRoot.getKind().equals("thread object")) continue;
                ThreadObjectGCRoot threadObjectGCRoot = (ThreadObjectGCRoot)gCRoot;
                Instance instance = threadObjectGCRoot.getInstance();
                if (instance != null) {
                    Object object2;
                    PrimitiveArrayInstance primitiveArrayInstance = (PrimitiveArrayInstance)instance.getValueOfField("name");
                    List list = primitiveArrayInstance.getValues();
                    char[] cArray = new char[list.size()];
                    int n = 0;
                    for (Object object2 : list) {
                        cArray[n++] = ((String)object2).charAt(0);
                    }
                    String string = new String(cArray);
                    object2 = (Boolean)instance.getValueOfField("daemon");
                    Integer n2 = (Integer)instance.getValueOfField("priority");
                    Long l = (Long)instance.getValueOfField("tid");
                    Integer n3 = (Integer)instance.getValueOfField("threadStatus");
                    StackTraceElement[] stackTraceElementArray = threadObjectGCRoot.getStackTrace();
                    stringWriter.append("&nbsp;&nbsp;<b>");
                    stringWriter.append("\"" + (String)string + "\"" + (((Boolean)object2).booleanValue() ? " daemon" : "") + " prio=" + n2);
                    if (l != null) {
                        stringWriter.append(" tid=" + l);
                    }
                    if (n3 != null) {
                        Thread.State state = VM.toThreadState((int)n3);
                        stringWriter.append(" " + (Object)((Object)state));
                    }
                    stringWriter.append("</b><br>");
                    if (stackTraceElementArray != null) {
                        for (int i = 0; i < stackTraceElementArray.length; ++i) {
                            String string2;
                            StackTraceElement stackTraceElement = stackTraceElementArray[i];
                            if (this.heapFragmentWalker.getHeapDumpProject() != null) {
                                String string3 = stackTraceElement.getClassName();
                                String string4 = stackTraceElement.getMethodName();
                                int n4 = stackTraceElement.getLineNumber();
                                String string5 = OPEN_THREADS_URL + string3 + "|" + string4 + "|" + n4;
                                string2 = "<a href=\"" + string5 + "\">" + stackTraceElement + "</a>";
                            } else {
                                string2 = stackTraceElement.toString();
                            }
                            stringWriter.append("\tat " + string2 + "<br>");
                        }
                    }
                } else {
                    stringWriter.append("&nbsp;&nbsp;Unknown thread");
                }
                stringWriter.append("<br>");
            }
            stringWriter.append("</pre>");
            this.stackTrace = stringWriter.toString();
        }
        return this.stackTrace;
    }

    private void refreshSummary() {
        if (!this.showSysprops) {
            this.dataArea.setText(IN_PROGRESS_MSG);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                String string = "<nobr>" + OverviewControllerUI.this.computeSummary() + "</nobr>";
                String string2 = "<nobr>" + OverviewControllerUI.this.computeEnvironment() + "</nobr>";
                String string3 = "<nobr>" + OverviewControllerUI.this.computeSystemProperties(OverviewControllerUI.this.showSysprops) + "</nobr>";
                String string4 = "<nobr>" + OverviewControllerUI.this.computeThreads(OverviewControllerUI.this.showThreads) + "</nobr>";
                final String string5 = string + "<br><br>" + string2 + "<br><br>" + string3 + "<br><br>" + string4;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        OverviewControllerUI.this.dataArea.setText(string5);
                        OverviewControllerUI.this.dataArea.setCaretPosition(0);
                    }
                });
            }
        });
    }

    private String formatSystemProperties(Properties properties) {
        StringBuffer stringBuffer = new StringBuffer(200);
        ArrayList arrayList = new ArrayList();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            String string2 = properties.getProperty(string);
            if ("line.separator".equals(string) && string2 != null) {
                string2 = string2.replace("\n", "\\n");
                string2 = string2.replace("\r", "\\r");
            }
            stringBuffer.append("<nobr>&nbsp;&nbsp;&nbsp;&nbsp;<b>");
            stringBuffer.append(string);
            stringBuffer.append("</b>=");
            stringBuffer.append(string2);
            stringBuffer.append("</nobr><br>");
        }
        return stringBuffer.toString();
    }

    private void initComponents() {
        this.dataArea = new HTMLTextArea(){

            protected void showURL(URL uRL) {
                if (uRL == null) {
                    return;
                }
                String string = uRL.toString();
                if (string.equals(OverviewControllerUI.SHOW_SYSPROPS_URL)) {
                    OverviewControllerUI.this.showSysprops = true;
                } else if (string.equals(OverviewControllerUI.SHOW_THREADS_URL)) {
                    OverviewControllerUI.this.showThreads = true;
                } else if (string.startsWith(OverviewControllerUI.OPEN_THREADS_URL)) {
                    string = string.substring(OverviewControllerUI.OPEN_THREADS_URL.length());
                    String[] stringArray = string.split("\\|");
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    int n = Integer.parseInt(stringArray[2]);
                    GoToSourceHelper.openSource(OverviewControllerUI.this.heapFragmentWalker.getHeapDumpProject(), new JavaSourceLocation(string2, string3, n));
                }
                OverviewControllerUI.this.refreshSummary();
            }
        };
        JScrollPane jScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
        jScrollPane.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIUtils.getProfilerResultsBackground()));
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.getTitleBorderColor()));
        jPanel.setLayout(new BorderLayout());
        jPanel.setOpaque(true);
        jPanel.setBackground(this.dataArea.getBackground());
        jPanel.add((Component)jScrollPane, "Center");
        this.setLayout(new BorderLayout());
        this.add(jPanel, "Center");
        this.setBackground(this.dataArea.getBackground());
    }
}

