/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.RootNode;
import org.openide.util.NbBundle;

public abstract class InstanceNode
extends AbstractHeapWalkerNode
implements HeapWalkerInstanceNode {
    private static final String LOOP_TO_STRING = NbBundle.getMessage(InstanceNode.class, (String)"InstanceNode_LoopToString");
    private static final String REFERENCES_STRING = NbBundle.getMessage(InstanceNode.class, (String)"InstanceNode_References");
    HeapWalkerNode loopTo;
    private Instance instance;
    private String name;

    public InstanceNode(Instance instance, String string, HeapWalkerNode heapWalkerNode) {
        this(instance, string, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
    }

    public InstanceNode(Instance instance, String string, HeapWalkerNode heapWalkerNode, int n) {
        super(heapWalkerNode, n);
        this.instance = instance;
        this.name = string;
        this.loopTo = this.computeLoopTo();
    }

    public abstract boolean isArray();

    public Instance getInstance() {
        return this.instance;
    }

    public boolean isLeaf() {
        return !this.hasInstance() || this.isLoop();
    }

    public boolean isLoop() {
        return this.getLoopTo() != null;
    }

    public HeapWalkerNode getLoopTo() {
        return this.loopTo;
    }

    public boolean hasInstance() {
        return this.instance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getReferences() {
        if (this.hasInstance()) {
            ProgressHandle progressHandle = null;
            try {
                progressHandle = ProgressHandleFactory.createHandle((String)REFERENCES_STRING);
                progressHandle.setInitialDelay(200);
                progressHandle.start(1000);
                InstanceNode.setProgress(progressHandle);
                List list = this.getInstance().getReferences();
                return list;
            }
            finally {
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected abstract ChildrenComputer getChildrenComputer();

    protected HeapWalkerNode[] computeChildren() {
        return BrowserUtils.lazilyCreateChildren(this, this.getChildrenComputer());
    }

    protected HeapWalkerNode computeLoopTo() {
        if (this.hasInstance()) {
            for (HeapWalkerNode heapWalkerNode = this.getParent(); heapWalkerNode != null && heapWalkerNode instanceof HeapWalkerInstanceNode; heapWalkerNode = heapWalkerNode.getParent()) {
                if (!((HeapWalkerInstanceNode)heapWalkerNode).getInstance().equals(this.instance)) continue;
                return heapWalkerNode;
            }
        }
        return null;
    }

    protected String computeName() {
        if (this.isLoop()) {
            return this.name + " " + MessageFormat.format(LOOP_TO_STRING, BrowserUtils.getFullNodeName(this.getLoopTo()));
        }
        return this.name;
    }

    protected String computeType() {
        if (!this.hasInstance()) {
            return "<object>";
        }
        return this.instance.getJavaClass().getName();
    }

    protected String computeValue() {
        JavaClass javaClass;
        HeapWalkerNode heapWalkerNode;
        if (!this.hasInstance()) {
            return "null";
        }
        if ("java.lang.Class".equals(this.instance.getJavaClass().getName()) && (heapWalkerNode = BrowserUtils.getRoot(this)) instanceof RootNode && (javaClass = ((RootNode)((Object)heapWalkerNode)).getJavaClassByID(this.instance.getInstanceId())) != null) {
            return "#" + this.instance.getInstanceNumber() + " (" + BrowserUtils.getSimpleType(javaClass.getName()) + ")";
        }
        return "#" + this.instance.getInstanceNumber();
    }

    protected String computeSize() {
        if (this.hasInstance()) {
            return String.valueOf(this.instance.getSize());
        }
        return "-";
    }

    protected String computeRetainedSize() {
        if (this.hasInstance()) {
            return String.valueOf(this.instance.getRetainedSize());
        }
        return "-";
    }

    protected ImageIcon processLoopIcon(ImageIcon imageIcon) {
        if (!this.isLoop()) {
            return imageIcon;
        }
        return BrowserUtils.createLoopIcon(imageIcon);
    }

    private static void setProgress(final ProgressHandle progressHandle) {
        final BoundedRangeModel boundedRangeModel = HeapProgress.getProgress();
        boundedRangeModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                progressHandle.progress(boundedRangeModel.getValue());
            }
        });
    }
}

