/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.sps.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.SignatureException;
import java.security.acl.NotOwnerException;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.sps.impl.SPSCommonImpl;
import org.netbeans.modules.nativeexecution.support.Encrypter;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SPSLocalImpl
extends SPSCommonImpl {
    private static final Map<String, Long> csums = new HashMap<String, Long>();
    private final String privp;
    private String pid = null;

    private SPSLocalImpl(ExecutionEnvironment executionEnvironment, String string) {
        super(executionEnvironment);
        this.privp = string;
    }

    public static SPSLocalImpl getNewInstance(ExecutionEnvironment executionEnvironment) throws SignatureException, MissingResourceException {
        String string = null;
        MacroExpanderFactory.MacroExpander macroExpander = MacroExpanderFactory.getExpander(executionEnvironment);
        String string2 = "$osname-$platform";
        try {
            string2 = macroExpander.expandPredefinedMacros(string2);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        string = "bin/nativeexecution/" + string2 + "/privp";
        InstalledFileLocator installedFileLocator = InstalledFileLocatorProvider.getDefault();
        File file = installedFileLocator.locate(string, null, false);
        if (file == null || !file.exists()) {
            throw new MissingResourceException(string, null, null);
        }
        string = file.getAbsolutePath();
        if (!Encrypter.checkCRC32(string, csums.get(string2))) {
            throw new SignatureException("Wrong privp executable! CRC check failed!");
        }
        Future<Integer> future = CommonTasksSupport.chmod(executionEnvironment, string, 493, null);
        try {
            future.get();
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        return new SPSLocalImpl(executionEnvironment, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPrivileges(Collection<String> collection, String string, char[] cArray) throws NotOwnerException {
        PrintWriter printWriter = null;
        try {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                for (String string2 : collection) {
                    stringBuffer.append(string2).append(",");
                }
                Process process = new ProcessBuilder(this.privp, string, stringBuffer.toString(), this.getPID()).start();
                printWriter = new PrintWriter(process.getOutputStream());
                printWriter.println(cArray);
                printWriter.flush();
                int n = process.waitFor();
                if (n != 0) {
                    Logger.getInstance().fine("privp returned " + n);
                    throw new NotOwnerException();
                }
                Object var9_11 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                Object var9_12 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (IOException iOException) {
                Logger.getInstance().fine("IOException in requestPrivileges : " + iOException);
                Object var9_13 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
    }

    @Override
    synchronized String getPID() {
        if (this.pid != null) {
            return this.pid;
        }
        try {
            File file = new File("/proc/self");
            this.pid = file.getCanonicalFile().getName();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return this.pid;
    }

    static {
        csums.put("SunOS-x86", 2839716019L);
        csums.put("SunOS-sparc", 2764559413L);
    }
}

