/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.tasklist.filter.OneOfFilterCondition;
import org.netbeans.modules.tasklist.filter.Util;

class StringFilterCondition
extends OneOfFilterCondition {
    public static final int EQUALS = 0;
    public static final int NOTEQUALS = 1;
    public static final int CONTAINS = 2;
    public static final int DOESNOTCONTAIN = 3;
    public static final int BEGINSWITH = 4;
    public static final int ENDSWITH = 5;
    public static final int CEQUALS = 6;
    public static final int CCONTAINS = 7;
    public static final int CDOESNOTCONTAIN = 8;
    public static final int CBEGINSWITH = 9;
    public static final int CENDSWITH = 10;
    private static String[] NAME_KEYS = new String[]{"Equals", "NotEquals", "Contains", "DoesNotContain", "BeginsWith", "EndsWith", "CEquals", "CContains", "CDoesNotContain", "CBeginsWith", "CEndsWith"};
    private String constant = "";

    public static StringFilterCondition[] createConditions() {
        return new StringFilterCondition[]{new StringFilterCondition(2), new StringFilterCondition(3), new StringFilterCondition(4), new StringFilterCondition(5), new StringFilterCondition(0), new StringFilterCondition(1), new StringFilterCondition(7), new StringFilterCondition(8), new StringFilterCondition(9), new StringFilterCondition(10), new StringFilterCondition(6)};
    }

    public StringFilterCondition(int n) {
        super(NAME_KEYS, n);
    }

    public StringFilterCondition(int n, String string) {
        this(n);
        this.constant = string;
    }

    public StringFilterCondition(StringFilterCondition stringFilterCondition) {
        super(stringFilterCondition);
        this.constant = stringFilterCondition.constant;
    }

    public Object clone() {
        return new StringFilterCondition(this);
    }

    StringFilterCondition() {
        super(NAME_KEYS);
        this.constant = null;
    }

    public String getConstant() {
        return this.constant;
    }

    public JComponent createConstantComponent() {
        final JTextField jTextField = new JTextField();
        jTextField.setText(this.constant);
        jTextField.setToolTipText(Util.getString("string_desc"));
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                Boolean bl = !"".equals(jTextField.getText());
                jTextField.putClientProperty("value-valid", bl);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                Boolean bl = !"".equals(jTextField.getText());
                jTextField.putClientProperty("value-valid", bl);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                Boolean bl = !"".equals(jTextField.getText());
                jTextField.putClientProperty("value-valid", bl);
            }
        });
        return jTextField;
    }

    public void getConstantFrom(JComponent jComponent) {
        JTextField jTextField = (JTextField)jComponent;
        this.constant = jTextField.getText();
    }

    public boolean isTrue(Object object) {
        String string = object == null ? "" : object.toString();
        switch (this.getId()) {
            case 0: {
                return string.equalsIgnoreCase(this.constant);
            }
            case 1: {
                return !string.equalsIgnoreCase(this.constant);
            }
            case 2: {
                return string.toLowerCase().indexOf(this.constant.toLowerCase()) >= 0;
            }
            case 3: {
                return string.toLowerCase().indexOf(this.constant.toLowerCase()) < 0;
            }
            case 4: {
                return string.toLowerCase().startsWith(this.constant.toLowerCase());
            }
            case 5: {
                return string.toLowerCase().endsWith(this.constant.toLowerCase());
            }
            case 6: {
                return string.equals(this.constant);
            }
            case 7: {
                return string.indexOf(this.constant) >= 0;
            }
            case 8: {
                return string.indexOf(this.constant) < 0;
            }
            case 9: {
                return string.startsWith(this.constant);
            }
            case 10: {
                return string.endsWith(this.constant);
            }
        }
        throw new InternalError("wrong id");
    }

    void load(Preferences preferences, String string) throws BackingStoreException {
        super.load(preferences, string);
        this.constant = preferences.get(string + "_constant", "");
    }

    void save(Preferences preferences, String string) throws BackingStoreException {
        super.save(preferences, string);
        preferences.put(string + "_constant", this.constant);
    }
}

