/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.timer;

import java.util.LinkedList;
import java.util.Queue;
import org.netbeans.modules.cnd.debugger.gdb.timer.GdbTimer;
import org.netbeans.modules.cnd.debugger.gdb.timer.TimerRecord;

class GdbTimerImpl
extends GdbTimer {
    private Queue<TimerRecord> queue = new LinkedList<TimerRecord>();
    private int skipCount = 0;
    private boolean in_use = false;

    GdbTimerImpl() {
    }

    public void reset() {
        this.skipCount = 0;
        this.in_use = false;
    }

    public void start(String string) {
        this.start(string, 0);
    }

    public void start(String string, int n) {
        if (this.queue.isEmpty() && this.skipCount == 0 && !this.in_use) {
            this.queue.add(new TimerRecord(TimerRecord.RecordType.Start, string));
            this.skipCount = n;
            this.in_use = true;
        } else {
            --this.skipCount;
        }
    }

    public void mark(String string) {
        if (this.in_use) {
            this.queue.add(new TimerRecord(TimerRecord.RecordType.Mark, string));
        }
    }

    public void stop(String string) {
        if (this.in_use) {
            this.queue.add(new TimerRecord(TimerRecord.RecordType.Stop, string));
        }
    }

    public void restart(String string) {
        if (this.in_use) {
            this.queue.add(new TimerRecord(TimerRecord.RecordType.Restart, string));
        }
    }

    public void free() {
        if (this.in_use) {
            this.queue.clear();
        }
    }

    public void report(String string) {
        if (this.in_use) {
            long l = -1L;
            if (!this.queue.isEmpty()) {
                TimerRecord timerRecord = this.queue.peek();
                l = timerRecord.getTime();
            }
            for (TimerRecord timerRecord : this.queue) {
                System.err.println(timerRecord.toString(l));
            }
            this.free();
        }
    }

    public int getSkipCount() {
        return this.skipCount;
    }
}

